/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.web.filter.beans.DependencyInjectedFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOLRAuthenticationFilter
implements DependencyInjectedFilter {
    private static Log logger = LogFactory.getLog(SOLRAuthenticationFilter.class);
    private SecureCommsType secureComms = SecureCommsType.HTTPS;

    public void setSecureComms(String type) {
        try {
            this.secureComms = SecureCommsType.getType(type);
        }
        catch (IllegalArgumentException e) {
            throw new AlfrescoRuntimeException("", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doFilter(ServletContext context, ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.secureComms == SecureCommsType.HTTPS) {
            if (!httpRequest.isSecure()) throw new AlfrescoRuntimeException("Expected a https request");
            chain.doFilter(request, response);
            return;
        } else {
            chain.doFilter(request, response);
        }
    }

    protected boolean validateTimestamp(String timestampStr) {
        if (timestampStr == null || timestampStr.equals("")) {
            throw new AlfrescoRuntimeException("Missing timestamp on request");
        }
        long timestamp = -1L;
        try {
            timestamp = Long.valueOf(timestampStr);
        }
        catch (NumberFormatException e) {
            throw new AlfrescoRuntimeException("Invalid timestamp on request");
        }
        if (timestamp == -1L) {
            throw new AlfrescoRuntimeException("Invalid timestamp on request");
        }
        long currentTime = System.currentTimeMillis();
        return currentTime - timestamp < 30000L;
    }

    public static class GenericResponseWrapper
    extends HttpServletResponseWrapper {
        private ByteArrayServletOutputStream output = new ByteArrayServletOutputStream();
        private int contentLength;
        private String contentType;

        public GenericResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public byte[] getData() {
            return this.output.getData();
        }

        public ServletOutputStream getOutputStream() {
            return this.output;
        }

        public PrintWriter getWriter() {
            return new PrintWriter((OutputStream)this.getOutputStream(), true);
        }

        public void setContentLength(int length) {
            this.contentLength = length;
            super.setContentLength(length);
        }

        public int getContentLength() {
            return this.contentLength;
        }

        public void setContentType(String type) {
            this.contentType = type;
            super.setContentType(type);
        }

        public String getContentType() {
            return this.contentType;
        }
    }

    private static class ByteArrayServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream out = new ByteArrayOutputStream();

        ByteArrayServletOutputStream() {
        }

        public byte[] getData() {
            return this.out.toByteArray();
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }
    }

    public static enum SecureCommsType {
        HTTPS,
        NONE;


        public static SecureCommsType getType(String type) {
            if (type.equalsIgnoreCase("https")) {
                return HTTPS;
            }
            if (type.equalsIgnoreCase("none")) {
                return NONE;
            }
            throw new IllegalArgumentException("Invalid communications type");
        }
    }
}

