/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.subscriptions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class SubscriptionServiceRestApiTest
extends BaseWebScriptTest {
    public static final String USER_BOB = "bob";
    public static final String USER_TOM = "tom";
    public static final String USER_LISA = "lisa";
    private static final String URL_FOLLOW = "/api/subscriptions/{userid}/follow";
    private static final String URL_UNFOLLOW = "/api/subscriptions/{userid}/unfollow";
    private static final String URL_FOLLOWERS = "/api/subscriptions/{userid}/followers";
    private static final String URL_FOLLOWERS_COUNT = "/api/subscriptions/{userid}/followers/count";
    private static final String URL_FOLLOWING = "/api/subscriptions/{userid}/following";
    private static final String URL_FOLLOWING_COUNT = "/api/subscriptions/{userid}/following/count";
    private static final String URL_FOLLOWS = "/api/subscriptions/{userid}/follows";
    private static final String URL_PRIVATE = "/api/subscriptions/{userid}/private";
    protected PersonService personService;

    @Override
    public void setUp() throws Exception {
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.createPerson(USER_BOB);
        this.createPerson(USER_TOM);
        this.createPerson(USER_LISA);
    }

    protected void tearDown() throws Exception {
        this.deletePerson(USER_BOB);
        this.deletePerson(USER_TOM);
        this.deletePerson(USER_LISA);
    }

    protected void deletePerson(String userId) {
        this.personService.deletePerson(userId);
    }

    protected NodeRef createPerson(String userId) {
        this.deletePerson(userId);
        PropertyMap properties = new PropertyMap(5);
        properties.put((Object)ContentModel.PROP_USERNAME, (Object)userId);
        properties.put((Object)ContentModel.PROP_FIRSTNAME, (Object)userId);
        properties.put((Object)ContentModel.PROP_LASTNAME, (Object)"Test");
        properties.put((Object)ContentModel.PROP_EMAIL, (Object)(userId + "@test.demo.alfresco.com"));
        return this.personService.createPerson((Map)properties);
    }

    protected String getUrl(String urlPattern, String user) {
        return urlPattern.replaceFirst("\\{userid\\}", user);
    }

    protected void follow(String user1, String user2) throws Exception {
        JSONArray jsonUsers = new JSONArray();
        jsonUsers.put((Object)user2);
        String url = this.getUrl(URL_FOLLOW, user1);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, jsonUsers.toString(), "application/json"), 204);
    }

    protected void unfollow(String user1, String user2) throws Exception {
        JSONArray jsonUsers = new JSONArray();
        jsonUsers.put((Object)user2);
        String url = this.getUrl(URL_UNFOLLOW, user1);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, jsonUsers.toString(), "application/json"), 204);
    }

    protected boolean follows(String user1, String user2) throws Exception {
        JSONArray jsonUsers = new JSONArray();
        jsonUsers.put((Object)user2);
        String url = this.getUrl(URL_FOLLOWS, user1);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, jsonUsers.toString(), "application/json"), 200);
        JSONArray resultArray = new JSONArray(response.getContentAsString());
        SubscriptionServiceRestApiTest.assertEquals((int)1, (int)resultArray.length());
        JSONObject resultObject = resultArray.getJSONObject(0);
        SubscriptionServiceRestApiTest.assertTrue((boolean)resultObject.has(user2));
        return resultObject.getBoolean(user2);
    }

    protected int getFollowingCount(String user) throws Exception {
        String url = this.getUrl(URL_FOLLOWING_COUNT, user);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject resultObject = new JSONObject(response.getContentAsString());
        SubscriptionServiceRestApiTest.assertTrue((boolean)resultObject.has("count"));
        return resultObject.getInt("count");
    }

    protected int getFollowersCount(String user) throws Exception {
        String url = this.getUrl(URL_FOLLOWERS_COUNT, user);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject resultObject = new JSONObject(response.getContentAsString());
        SubscriptionServiceRestApiTest.assertTrue((boolean)resultObject.has("count"));
        return resultObject.getInt("count");
    }

    protected List<String> getFollowing(String user) throws Exception {
        String url = this.getUrl(URL_FOLLOWING, user);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject resultObject = new JSONObject(response.getContentAsString());
        SubscriptionServiceRestApiTest.assertTrue((boolean)resultObject.has("people"));
        ArrayList<String> result = new ArrayList<String>();
        JSONArray people = resultObject.getJSONArray("people");
        for (int i = 0; i < people.length(); ++i) {
            JSONObject person = people.getJSONObject(i);
            SubscriptionServiceRestApiTest.assertTrue((boolean)person.has("userName"));
            SubscriptionServiceRestApiTest.assertTrue((boolean)person.has("firstName"));
            SubscriptionServiceRestApiTest.assertTrue((boolean)person.has("lastName"));
            result.add(person.getString("userName"));
        }
        return result;
    }

    protected List<String> getFollowers(String user) throws Exception {
        String url = this.getUrl(URL_FOLLOWERS, user);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject resultObject = new JSONObject(response.getContentAsString());
        SubscriptionServiceRestApiTest.assertTrue((boolean)resultObject.has("people"));
        ArrayList<String> result = new ArrayList<String>();
        JSONArray people = resultObject.getJSONArray("people");
        for (int i = 0; i < people.length(); ++i) {
            JSONObject person = people.getJSONObject(i);
            SubscriptionServiceRestApiTest.assertTrue((boolean)person.has("userName"));
            SubscriptionServiceRestApiTest.assertTrue((boolean)person.has("firstName"));
            SubscriptionServiceRestApiTest.assertTrue((boolean)person.has("lastName"));
            result.add(person.getString("userName"));
        }
        return result;
    }

    protected boolean isSubscriptionListPrivate(String user) throws Exception {
        String url = this.getUrl(URL_PRIVATE, user);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject resultObject = new JSONObject(response.getContentAsString());
        SubscriptionServiceRestApiTest.assertTrue((boolean)resultObject.has("private"));
        return resultObject.getBoolean("private");
    }

    protected void setSubscriptionListPrivate(String user, boolean setPrivate) throws Exception {
        JSONObject privateObject = new JSONObject();
        privateObject.put("private", setPrivate);
        String url = this.getUrl(URL_PRIVATE, user);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(url, privateObject.toString(), "application/json"), 200);
        JSONObject resultObject = new JSONObject(response.getContentAsString());
        SubscriptionServiceRestApiTest.assertTrue((boolean)resultObject.has("private"));
        SubscriptionServiceRestApiTest.assertEquals((boolean)setPrivate, (boolean)resultObject.getBoolean("private"));
    }

    public void testFollow() throws Exception {
        String userId1 = USER_BOB;
        String userId2 = USER_TOM;
        String userId3 = USER_LISA;
        if (this.follows(userId1, userId2)) {
            this.unfollow(userId1, userId2);
        }
        SubscriptionServiceRestApiTest.assertFalse((boolean)this.follows(userId1, userId2));
        int count = this.getFollowingCount(userId1);
        SubscriptionServiceRestApiTest.assertTrue((count >= 0 ? 1 : 0) != 0);
        this.follow(userId1, userId2);
        this.follow(userId1, userId2);
        SubscriptionServiceRestApiTest.assertEquals((int)(count + 1), (int)this.getFollowingCount(userId1));
        SubscriptionServiceRestApiTest.assertTrue((boolean)this.follows(userId1, userId2));
        this.follow(userId1, userId3);
        SubscriptionServiceRestApiTest.assertEquals((int)(count + 2), (int)this.getFollowingCount(userId1));
        SubscriptionServiceRestApiTest.assertTrue((boolean)this.follows(userId1, userId3));
        List<String> following = this.getFollowing(userId1);
        SubscriptionServiceRestApiTest.assertNotNull(following);
        SubscriptionServiceRestApiTest.assertTrue((boolean)following.contains(userId2));
        SubscriptionServiceRestApiTest.assertTrue((boolean)following.contains(userId3));
        int followerCount = this.getFollowersCount(userId2);
        SubscriptionServiceRestApiTest.assertTrue((followerCount > 0 ? 1 : 0) != 0);
        List<String> followers = this.getFollowers(userId2);
        SubscriptionServiceRestApiTest.assertNotNull(followers);
        SubscriptionServiceRestApiTest.assertTrue((boolean)followers.contains(userId1));
        this.unfollow(userId1, userId2);
        SubscriptionServiceRestApiTest.assertEquals((int)(count + 1), (int)this.getFollowingCount(userId1));
        SubscriptionServiceRestApiTest.assertFalse((boolean)this.follows(userId1, userId2));
        SubscriptionServiceRestApiTest.assertTrue((boolean)this.follows(userId1, userId3));
        this.unfollow(userId1, userId3);
        SubscriptionServiceRestApiTest.assertEquals((int)count, (int)this.getFollowingCount(userId1));
        SubscriptionServiceRestApiTest.assertFalse((boolean)this.follows(userId1, userId3));
    }

    public void testPrivateList() throws Exception {
        String userId1 = USER_BOB;
        SubscriptionServiceRestApiTest.assertFalse((boolean)this.isSubscriptionListPrivate(USER_BOB));
        this.setSubscriptionListPrivate(USER_BOB, false);
        SubscriptionServiceRestApiTest.assertFalse((boolean)this.isSubscriptionListPrivate(USER_BOB));
        this.setSubscriptionListPrivate(USER_BOB, true);
        SubscriptionServiceRestApiTest.assertTrue((boolean)this.isSubscriptionListPrivate(USER_BOB));
        this.setSubscriptionListPrivate(USER_BOB, false);
        SubscriptionServiceRestApiTest.assertFalse((boolean)this.isSubscriptionListPrivate(USER_BOB));
        this.setSubscriptionListPrivate(USER_BOB, true);
        SubscriptionServiceRestApiTest.assertTrue((boolean)this.isSubscriptionListPrivate(USER_BOB));
    }
}

