/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.tagging;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.json.JSONArray;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class TaggingServiceTest
extends BaseWebScriptTest {
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private TaggingService taggingService;
    private FileFolderService fileFolderService;
    private Repository repositoryHelper;
    private NodeService nodeService;
    private static final String TEST_USER = "TaggingServiceTestUser";
    private static final String TAG_1 = "tagOneREST";
    private static final String TAG_2 = "tagTwoREST";
    private static final String TAG_3 = "tagThreeREST";
    private static final String TAG_4 = "tagFourREST";
    private static final String TAG_5 = "tagFiveREST";
    private NodeRef nodeOne;
    private NodeRef nodeTwo;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.taggingService = (TaggingService)this.getServer().getApplicationContext().getBean("TaggingService");
        this.fileFolderService = (FileFolderService)this.getServer().getApplicationContext().getBean("FileFolderService");
        this.repositoryHelper = (Repository)this.getServer().getApplicationContext().getBean("repositoryHelper");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.taggingService.createTag(new StoreRef("workspace", "SpacesStore"), TAG_1);
        this.taggingService.createTag(new StoreRef("workspace", "SpacesStore"), TAG_2);
        this.taggingService.createTag(new StoreRef("workspace", "SpacesStore"), TAG_3);
        this.taggingService.createTag(new StoreRef("workspace", "SpacesStore"), TAG_4);
        this.taggingService.createTag(new StoreRef("workspace", "SpacesStore"), TAG_5);
        NodeRef testRoot = this.repositoryHelper.getCompanyHome();
        String guid = GUID.generate();
        this.nodeOne = this.fileFolderService.create(testRoot, "test_doc1" + guid + ".txt", ContentModel.TYPE_CONTENT).getNodeRef();
        this.nodeTwo = this.fileFolderService.create(testRoot, "test_dco2" + guid + ".txt", ContentModel.TYPE_CONTENT).getNodeRef();
        this.taggingService.addTag(this.nodeOne, TAG_1);
        this.taggingService.addTag(this.nodeOne, TAG_2);
        this.taggingService.addTag(this.nodeTwo, TAG_2);
        this.createUser(TEST_USER);
        this.authenticationComponent.setCurrentUser(TEST_USER);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.taggingService.deleteTag(new StoreRef("workspace", "SpacesStore"), TAG_1);
        this.taggingService.deleteTag(new StoreRef("workspace", "SpacesStore"), TAG_2);
        this.taggingService.deleteTag(new StoreRef("workspace", "SpacesStore"), TAG_3);
        this.taggingService.deleteTag(new StoreRef("workspace", "SpacesStore"), TAG_4);
        this.taggingService.deleteTag(new StoreRef("workspace", "SpacesStore"), TAG_5);
        this.nodeService.deleteNode(this.nodeOne);
        this.nodeService.deleteNode(this.nodeTwo);
    }

    public void testGetTags() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/tags/workspace/SpacesStore"), 200);
        JSONArray jsonArray = new JSONArray(response.getContentAsString());
        TaggingServiceTest.assertNotNull((Object)jsonArray);
        TaggingServiceTest.assertTrue((jsonArray.length() > 0 ? 1 : 0) != 0);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/tags/workspace/SpacesStore?tf=one"), 200);
        jsonArray = new JSONArray(response.getContentAsString());
        TaggingServiceTest.assertNotNull((Object)jsonArray);
        TaggingServiceTest.assertTrue((jsonArray.length() > 0 ? 1 : 0) != 0);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/tags/workspace/SpacesStore?tf=none"), 200);
        jsonArray = new JSONArray(response.getContentAsString());
        TaggingServiceTest.assertNotNull((Object)jsonArray);
        TaggingServiceTest.assertEquals((int)0, (int)jsonArray.length());
    }

    public void testGetNodes() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/tags/workspace/SpacesStore/tagOneREST/nodes"), 200);
        JSONArray jsonArray = new JSONArray(response.getContentAsString());
        TaggingServiceTest.assertNotNull((Object)jsonArray);
        TaggingServiceTest.assertEquals((int)1, (int)jsonArray.length());
        System.out.println(response.getContentAsString());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/tags/workspace/SpacesStore/tagTwoREST/nodes"), 200);
        jsonArray = new JSONArray(response.getContentAsString());
        TaggingServiceTest.assertNotNull((Object)jsonArray);
        TaggingServiceTest.assertEquals((int)2, (int)jsonArray.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/tags/workspace/SpacesStore/jumk/nodes"), 200);
        jsonArray = new JSONArray(response.getContentAsString());
        TaggingServiceTest.assertNotNull((Object)jsonArray);
        TaggingServiceTest.assertEquals((int)0, (int)jsonArray.length());
    }
}

