/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.transfer;

import java.io.StringWriter;
import java.io.Writer;
import org.alfresco.repo.transfer.TransferVersionImpl;
import org.alfresco.repo.web.scripts.transfer.CommandProcessor;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.cmr.transfer.TransferVersion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.json.JSONWriter;

public class BeginTransferCommandProcessor
implements CommandProcessor {
    private static final String MSG_CAUGHT_UNEXPECTED_EXCEPTION = "transfer_service.receiver.caught_unexpected_exception";
    private TransferReceiver receiver;
    private static final Log logger = LogFactory.getLog(BeginTransferCommandProcessor.class);

    @Override
    public int process(WebScriptRequest req, WebScriptResponse resp) {
        String transferId = null;
        try {
            String[] fromRepositoryIdValues = req.getParameterValues("fromRepositoryId");
            String[] transferToSelfValues = req.getParameterValues("allowTransferToSelf");
            String[] editionValues = req.getParameterValues("versionEdition");
            String[] majorValues = req.getParameterValues("versionMajor");
            String[] minorValues = req.getParameterValues("versionMinor");
            String[] revisionValues = req.getParameterValues("versionRevision");
            String[] rootFileTransfer = req.getParameterValues("rootFileTransfer");
            String fromRepositoryId = null;
            if (fromRepositoryIdValues != null && fromRepositoryIdValues.length > 0) {
                fromRepositoryId = fromRepositoryIdValues[0];
            }
            boolean transferToSelf = false;
            if (transferToSelfValues != null && transferToSelfValues.length > 0 && transferToSelfValues[0].equalsIgnoreCase("true")) {
                transferToSelf = true;
            }
            String edition = "Unknown";
            if (editionValues != null && editionValues.length > 0) {
                edition = editionValues[0];
            }
            String major = "0";
            if (majorValues != null && majorValues.length > 0) {
                major = majorValues[0];
            }
            String minor = "0";
            if (minorValues != null && minorValues.length > 0) {
                minor = minorValues[0];
            }
            String revision = "0";
            if (revisionValues != null && revisionValues.length > 0) {
                revision = revisionValues[0];
            }
            TransferVersionImpl fromVersion = new TransferVersionImpl(major, minor, revision, edition);
            if (rootFileTransfer != null && rootFileTransfer.length > 0) {
                this.receiver.setTransferRootNode(rootFileTransfer[0]);
            }
            transferId = this.receiver.start(fromRepositoryId, transferToSelf, (TransferVersion)fromVersion);
            this.receiver.getStagingFolder(transferId);
            TransferVersion version = this.receiver.getVersion();
            StringWriter stringWriter = new StringWriter(1000);
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.startObject();
            jsonWriter.writeValue("transferId", transferId);
            if (version != null) {
                jsonWriter.writeValue("versionEdition", version.getEdition());
                jsonWriter.writeValue("versionMajor", version.getVersionMajor());
                jsonWriter.writeValue("versionMinor", version.getVersionMinor());
                jsonWriter.writeValue("versionRevision", version.getVersionRevision());
            }
            jsonWriter.endObject();
            String response = stringWriter.toString();
            resp.setContentType("application/json");
            resp.setContentEncoding("UTF-8");
            int length = response.getBytes("UTF-8").length;
            resp.addHeader("Content-Length", "" + length);
            resp.setStatus(200);
            resp.getWriter().write(response);
            logger.debug((Object)("transfer started" + transferId));
            return 200;
        }
        catch (Exception ex) {
            logger.debug((Object)"exception caught", (Throwable)ex);
            if (transferId != null) {
                logger.debug((Object)"ending transfer", (Throwable)ex);
                this.receiver.end(transferId);
            }
            if (ex instanceof TransferException) {
                throw (TransferException)ex;
            }
            throw new TransferException(MSG_CAUGHT_UNEXPECTED_EXCEPTION, (Throwable)ex);
        }
    }

    public void setReceiver(TransferReceiver receiver) {
        this.receiver = receiver;
    }
}

