/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.transfer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.repo.web.scripts.transfer.TransferWebScript;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class TransferWebScriptTest
extends BaseWebScriptTest {
    private static final String USERNAME = "noddy.transfer";
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private List<String> createdPeople = new ArrayList<String>(5);

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createUser(USERNAME);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"myFirstName");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"myLastName");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"myFirstName.myLastName@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"myJobTitle");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"myOrganisation");
            this.personService.createPerson((Map)personProps);
            this.createdPeople.add(userName);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        String adminUser = this.authenticationComponent.getSystemUserName();
        this.authenticationComponent.setCurrentUser(adminUser);
        for (String userName : this.createdPeople) {
            this.personService.deletePerson(userName);
        }
        this.createdPeople.clear();
    }

    public void testVerify() throws Exception {
        String url = "/api/transfer/test";
        TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(url, new JSONObject().toString(), "application/json");
        AuthenticationUtil.setFullyAuthenticatedUser((String)USERNAME);
        this.sendRequest((TestWebScriptServer.Request)req, 401);
        AuthenticationUtil.setFullyAuthenticatedUser((String)"System");
        this.sendRequest((TestWebScriptServer.Request)req, 200);
        TransferWebScript webscript = (TransferWebScript)((Object)this.getServer().getApplicationContext().getBean("webscript.org.alfresco.repository.transfer.transfer.post"));
        webscript.setEnabled(false);
        this.sendRequest((TestWebScriptServer.Request)req, 404);
    }
}

