/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.wcm.sandbox;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class AssetTest
extends BaseWebScriptTest {
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private static final String USER_ONE = "WebProjectTestOne";
    private static final String USER_TWO = "WebProjectTestTwo";
    private static final String USER_THREE = "WebProjectTestThree";
    private static final String USER_FOUR = "WebProjectTestFour";
    public static final String ROLE_CONTENT_MANAGER = "ContentManager";
    public static final String ROLE_CONTENT_PUBLISHER = "ContentPublisher";
    public static final String ROLE_CONTENT_REVIEWER = "ContentReviewer";
    public static final String ROLE_CONTENT_CONTRIBUTOR = "ContentContributor";
    private static final String URL_WEB_PROJECT = "/api/wcm/webprojects";
    private static final String URI_MEMBERSHIPS = "/memberships";
    private static final String URI_SANDBOXES = "/sandboxes";
    private static final String BASIC_NAME = "testProj";
    private static final String BASIC_DESCRIPTION = "testDescription";
    private static final String BASIC_TITLE = "testTitle";
    private static final String BASIC_DNSNAME = "testDNSName";
    private static final String WEBAPP_ROOT = "ROOT";
    private static final String WEBAPP_YELLOW = "YELLOW";
    private static final String WEBAPP_GREEN = "GREEN";
    private static final String ROOT_FILE = "index.htm";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_PROPERTIES = "properties";
    private static final String FIELD_CONTENT = "content";
    private static final String PROP_NAME = "cm:name";
    private static final String PROP_TITLE = "cm:title";
    private static final String TEST_CONTENT_ENTRY = "This is test content entry for an Asset";
    private static final String SUBMIT_CONFIG_LOCATION = "classpath:wcm/wcm-jbpm-context.xml";
    private static final long SUBMIT_DELAY = 15000L;
    private List<String> createdWebProjects = new ArrayList<String>(5);

    @Override
    protected void setUp() throws Exception {
        this.setCustomContext(SUBMIT_CONFIG_LOCATION);
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        this.createUser(USER_THREE);
        this.createUser(USER_FOUR);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    private String createWebProject() throws Exception {
        JSONObject webProj = new JSONObject();
        webProj.put("name", (Object)BASIC_NAME);
        webProj.put("description", (Object)BASIC_DESCRIPTION);
        webProj.put("title", (Object)BASIC_TITLE);
        webProj.put("dnsName", (Object)BASIC_DNSNAME);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_WEB_PROJECT, webProj.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject data = result.getJSONObject(FIELD_DATA);
        String webProjectRef = data.getString("webprojectref");
        AssetTest.assertNotNull((String)"webproject ref is null", (Object)webProjectRef);
        this.createdWebProjects.add(webProjectRef);
        return webProjectRef;
    }

    private void createMembership(String webProjectRef, String userName, String role) throws Exception {
        String validURL = "/api/wcm/webprojects/" + webProjectRef + URI_MEMBERSHIPS;
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)ROLE_CONTENT_MANAGER);
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, membership.toString(), "application/json"), 200);
    }

    private String createSandbox(String webprojref, String userName) throws JSONException, IOException {
        String sandboxref = null;
        JSONObject box = new JSONObject();
        box.put("userName", (Object)userName);
        String validURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, box.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject data = result.getJSONObject(FIELD_DATA);
        sandboxref = data.getString("sandboxref");
        AssetTest.assertNotNull((String)"sandboxref is null", (Object)sandboxref);
        return sandboxref;
    }

    private void checkSandboxEmpty(String webprojref, String sandboxref) throws Exception {
        String sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        TestWebScriptServer.Response list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        JSONObject result = new JSONObject(list.getContentAsString());
        JSONArray lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"sandbox is not empty", (lookupResult.length() == 0 ? 1 : 0) != 0);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        for (String webProjectRef : this.createdWebProjects) {
            try {
                this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/wcm/webprojects/" + webProjectRef), 0);
            }
            catch (Exception exception) {}
        }
        this.createdWebProjects.clear();
    }

    public void testModifiedAssetsWebAppTest() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        String sandboxref = this.createSandbox(webprojref, USER_ONE);
        this.createFolder(webprojref, sandboxref, "/www/avm_webapps", WEBAPP_YELLOW);
        String submitterURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/submitter";
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "rootFile1");
        JSONObject submitForm = new JSONObject();
        submitForm.put("label", (Object)"the label");
        submitForm.put("comment", (Object)"the comment");
        submitForm.put("all", true);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL, submitForm.toString(), "application/json"), 200);
        Thread.sleep(15000L);
        this.createFile(webprojref, sandboxref, "/www/avm_webapps/YELLOW", "yellowFile1");
        String sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified?webApp=" + WEBAPP_YELLOW;
        TestWebScriptServer.Response list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        JSONObject result = new JSONObject(list.getContentAsString());
        System.out.println(list.getContentAsString());
        JSONArray lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult.length() == 1 ? 1 : 0) != 0);
        JSONObject x = lookupResult.getJSONObject(0);
        String name = x.getString("name");
        String path = x.getString("path");
        String creator = x.getString("creator");
        boolean isFile = x.getBoolean("isFile");
        boolean isDeleted = x.getBoolean("isDeleted");
        boolean isFolder = x.getBoolean("isFolder");
        AssetTest.assertNotNull((String)"name is null", (Object)name);
        AssetTest.assertEquals((String)"name is wrong", (String)"yellowFile1", (String)name);
        AssetTest.assertEquals((String)"creator is wrong", (String)AuthenticationUtil.getAdminUserName(), (String)creator);
        AssetTest.assertTrue((String)"not isFile", (boolean)isFile);
        AssetTest.assertFalse((String)"not isFolder", (boolean)isFolder);
        AssetTest.assertFalse((String)"not isDeleted", (boolean)isDeleted);
        AssetTest.assertNotNull((String)"path is null", (Object)path);
        AssetTest.assertEquals((String)"path of MyFile1 is not correct", (String)path, (String)"/www/avm_webapps/YELLOW/yellowFile1");
    }

    public void testModifiedAssetsTest() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        String sandboxref = this.createSandbox(webprojref, USER_ONE);
        String sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        TestWebScriptServer.Response list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        JSONObject result = new JSONObject(list.getContentAsString());
        JSONArray lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult.length() == 0 ? 1 : 0) != 0);
        sandboxesURL = "/api/wcm/webprojects/crap/sandboxes/" + sandboxref + "/modified";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 404);
        sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + "crap" + "/modified";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 404);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "myFile1");
        sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        result = new JSONObject(list.getContentAsString());
        lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult.length() == 1 ? 1 : 0) != 0);
        JSONObject x = lookupResult.getJSONObject(0);
        String name = x.getString("name");
        String path = x.getString("path");
        String creator = x.getString("creator");
        boolean isFile = x.getBoolean("isFile");
        boolean isDeleted = x.getBoolean("isDeleted");
        boolean isFolder = x.getBoolean("isFolder");
        AssetTest.assertNotNull((String)"name is null", (Object)name);
        AssetTest.assertEquals((String)"name is wrong", (String)"myFile1", (String)name);
        AssetTest.assertEquals((String)"creator is wrong", (String)AuthenticationUtil.getAdminUserName(), (String)creator);
        AssetTest.assertTrue((String)"not isFile", (boolean)isFile);
        AssetTest.assertFalse((String)"not isDirectory", (boolean)isFolder);
        AssetTest.assertFalse((String)"not isDeleted", (boolean)isDeleted);
        AssetTest.assertNotNull((String)"path is null", (Object)path);
        AssetTest.assertEquals((String)"path of MyFile1 is not correct", (String)path, (String)"/www/avm_webapps/ROOT/myFile1");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "fileA");
        sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        result = new JSONObject(list.getContentAsString());
        lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult.length() == 2 ? 1 : 0) != 0);
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/", "dir1");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/dir1", "filex");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/dir1", "filey");
        sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        result = new JSONObject(list.getContentAsString());
        lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult.length() == 3 ? 1 : 0) != 0);
    }

    public void testSubmitAssetsTest() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        String sandboxref = this.createSandbox(webprojref, USER_ONE);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "myFile1");
        String submitterURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/submitter";
        JSONObject submitForm = new JSONObject();
        submitForm.put("comment", (Object)"the comment");
        submitForm.put("all", true);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL, submitForm.toString(), "application/json"), 400);
        submitForm = new JSONObject();
        submitForm.put("label", (Object)"the label");
        submitForm.put("all", true);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL, submitForm.toString(), "application/json"), 400);
        String crapURL = "/api/wcm/webprojects/crap/sandboxes/" + sandboxref + "/submitter";
        JSONObject submitForm2 = new JSONObject();
        submitForm2.put("label", (Object)"the label");
        submitForm2.put("comment", (Object)"the comment");
        submitForm2.put("all", true);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(crapURL, submitForm2.toString(), "application/json"), 404);
        crapURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + "crap" + "/submitter";
        submitForm2 = new JSONObject();
        submitForm2.put("label", (Object)"the label");
        submitForm2.put("comment", (Object)"the comment");
        submitForm2.put("all", true);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(crapURL, submitForm2.toString(), "application/json"), 404);
        submitForm = new JSONObject();
        submitForm.put("label", (Object)"the label");
        submitForm.put("comment", (Object)"the comment");
        submitForm.put("all", false);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL, submitForm.toString(), "application/json"), 400);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "myFile2");
        String sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        TestWebScriptServer.Response list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        JSONObject result = new JSONObject(list.getContentAsString());
        JSONArray lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult.length() > 0 ? 1 : 0) != 0);
        submitForm = new JSONObject();
        submitForm.put("label", (Object)"the label");
        submitForm.put("comment", (Object)"the comment");
        submitForm.put("all", true);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL, submitForm.toString(), "application/json"), 200);
        Thread.sleep(15000L);
        this.checkSandboxEmpty(webprojref, sandboxref);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "myFile3");
        submitForm = new JSONObject();
        submitForm.put("label", (Object)"the label");
        submitForm.put("comment", (Object)"the comment");
        JSONArray paths = new JSONArray();
        paths.put((Object)"/www/avm_webapps/ROOT/myFile3");
        submitForm.put("paths", (Object)paths);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL, submitForm.toString(), "application/json"), 200);
        Thread.sleep(15000L);
        this.checkSandboxEmpty(webprojref, sandboxref);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "myFile4");
        sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        result = new JSONObject(list.getContentAsString());
        lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult.length() > 0 ? 1 : 0) != 0);
        JSONObject submitForm3 = new JSONObject();
        submitForm3.put("label", (Object)"the label");
        submitForm3.put("comment", (Object)"the comment");
        submitForm3.put("assets", (Object)lookupResult);
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL, submitForm3.toString(), "application/json"), 200);
        Thread.sleep(15000L);
        this.checkSandboxEmpty(webprojref, sandboxref);
        this.deleteFile(webprojref, sandboxref, "/www/avm_webapps/ROOT/myFile3");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "buffy.jpg");
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/", "vampires");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/vampires", "master");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/vampires", "drusilla");
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/", "humans");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/humans", "willow");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/humans", "xander");
        sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        result = new JSONObject(list.getContentAsString());
        lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult.length() > 0 ? 1 : 0) != 0);
        submitForm3 = new JSONObject();
        submitForm3.put("label", (Object)"the label");
        submitForm3.put("comment", (Object)"the comment");
        submitForm3.put("assets", (Object)lookupResult);
        response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL, submitForm3.toString(), "application/json"), 200);
        Thread.sleep(15000L);
        this.checkSandboxEmpty(webprojref, sandboxref);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/vampires", "angel");
        this.deleteFile(webprojref, sandboxref, "/www/avm_webapps/ROOT/vampires/drusilla");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/humans", "giles");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/humans", "dawn");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/humans", "anya");
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/", "cast");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/cast", "Anthony Head");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/cast", "James Marsters");
        sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        result = new JSONObject(list.getContentAsString());
        lookupResult = result.getJSONArray(FIELD_DATA);
        JSONArray assets = new JSONArray();
        JSONArray paths2 = new JSONArray();
        JSONArray omitted = new JSONArray();
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult.length() > 4 ? 1 : 0) != 0);
        for (int i = 0; i < lookupResult.length(); ++i) {
            if (i < 2) {
                omitted.put(lookupResult.getJSONObject(i).get("path"));
                continue;
            }
            if (i < 4) {
                paths2.put(lookupResult.getJSONObject(i).get("path"));
                continue;
            }
            assets.put((Object)lookupResult.getJSONObject(i));
        }
        JSONObject submitForm4 = new JSONObject();
        submitForm4.put("label", (Object)"the label");
        submitForm4.put("comment", (Object)"the comment");
        submitForm4.put("assets", (Object)assets);
        submitForm4.put("paths", (Object)paths2);
        TestWebScriptServer.Response response3 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL, submitForm4.toString(), "application/json"), 200);
        Thread.sleep(15000L);
        TestWebScriptServer.Response listTwo = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        JSONObject resultTwo = new JSONObject(listTwo.getContentAsString());
        JSONArray lookupResultTwo = resultTwo.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResultTwo.length() == 2 ? 1 : 0) != 0);
        JSONObject submitOmitted = new JSONObject();
        submitOmitted.put("label", (Object)"the label");
        submitOmitted.put("comment", (Object)"the comment");
        submitOmitted.put("paths", (Object)omitted);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL, submitOmitted.toString(), "application/json"), 200);
        Thread.sleep(15000L);
        this.checkSandboxEmpty(webprojref, sandboxref);
    }

    public void testSubmitAssetsWebAppTest() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        String sandboxref = this.createSandbox(webprojref, USER_ONE);
        this.createFolder(webprojref, sandboxref, "/www/avm_webapps", WEBAPP_YELLOW);
        String submitterURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/submitter";
        JSONObject submitForm = new JSONObject();
        submitForm.put("label", (Object)"the label");
        submitForm.put("comment", (Object)"the comment");
        submitForm.put("all", true);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL, submitForm.toString(), "application/json"), 200);
        this.createFile(webprojref, sandboxref, "/www/avm_webapps/ROOT", "rootFile1");
        this.createFile(webprojref, sandboxref, "/www/avm_webapps/YELLOW", "yellowFile1");
        submitForm.put("label", (Object)"yellow submit");
        submitForm.put("comment", (Object)"yellow submit");
        submitForm.put("all", true);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL + "?webApp=" + WEBAPP_YELLOW, submitForm.toString(), "application/json"), 200);
        Thread.sleep(15000L);
        String sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        TestWebScriptServer.Response list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        JSONObject result = new JSONObject(list.getContentAsString());
        JSONArray lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertEquals((String)"testListUserSandbox", (int)lookupResult.length(), (int)1);
        JSONObject x = lookupResult.getJSONObject(0);
        String name = x.getString("name");
        AssetTest.assertNotNull((String)"name is null", (Object)name);
        AssetTest.assertEquals((String)"name is wrong", (String)"rootFile1", (String)name);
    }

    public void testRevertAssetsTest() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        String sandboxref = this.createSandbox(webprojref, USER_ONE);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "myFile1");
        String reverterURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/reverter";
        String crapURL = "/api/wcm/webprojects/crap/sandboxes/" + sandboxref + "/reverter";
        JSONObject submitForm = new JSONObject();
        submitForm.put("all", true);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(crapURL, submitForm.toString(), "application/json"), 404);
        crapURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + "crap" + "/reverter";
        submitForm = new JSONObject();
        submitForm.put("all", true);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(crapURL, submitForm.toString(), "application/json"), 404);
        JSONObject submitForm2 = new JSONObject();
        submitForm2.put("all", false);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(reverterURL, submitForm2.toString(), "application/json"), 400);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "myFile2");
        String sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        TestWebScriptServer.Response list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        JSONObject result = new JSONObject(list.getContentAsString());
        JSONArray lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult.length() > 0 ? 1 : 0) != 0);
        submitForm2 = new JSONObject();
        submitForm2.put("all", true);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(reverterURL, submitForm2.toString(), "application/json"), 200);
        this.checkSandboxEmpty(webprojref, sandboxref);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "myFile3");
        submitForm2 = new JSONObject();
        JSONArray paths = new JSONArray();
        paths.put((Object)"/www/avm_webapps/ROOT/myFile3");
        submitForm2.put("paths", (Object)paths);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(reverterURL, submitForm2.toString(), "application/json"), 200);
        this.checkSandboxEmpty(webprojref, sandboxref);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "myFile4");
        sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        result = new JSONObject(list.getContentAsString());
        lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult.length() > 0 ? 1 : 0) != 0);
        JSONObject submitForm3 = new JSONObject();
        submitForm3.put("assets", (Object)lookupResult);
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(reverterURL, submitForm3.toString(), "application/json"), 200);
        this.checkSandboxEmpty(webprojref, sandboxref);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "buffy.jpg");
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/", "vampires");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/vampires", "master");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/vampires", "drusilla");
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/", "humans");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/humans", "willow");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/humans", "xander");
        sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        result = new JSONObject(list.getContentAsString());
        lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult.length() > 0 ? 1 : 0) != 0);
        submitForm3 = new JSONObject();
        submitForm3.put("assets", (Object)lookupResult);
        response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(reverterURL, submitForm3.toString(), "application/json"), 200);
        this.checkSandboxEmpty(webprojref, sandboxref);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "buffy.jpg");
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/", "vampires");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/vampires", "master");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/vampires", "drusilla");
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/", "humans");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/humans", "willow");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/humans", "xander");
        submitForm2 = new JSONObject();
        submitForm2.put("label", (Object)"the label");
        submitForm2.put("comment", (Object)"the comment");
        submitForm2.put("all", true);
        String submitterURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/submitter";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL, submitForm2.toString(), "application/json"), 200);
        Thread.sleep(15000L);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/vampires", "angel");
        this.deleteFile(webprojref, sandboxref, "/www/avm_webapps/ROOT/vampires/drusilla");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/humans", "giles");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/humans", "dawn");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/humans", "anya");
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/", "cast");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/cast", "Anthony Head");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/cast", "James Marsters");
        String sandboxesURL2 = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        TestWebScriptServer.Response list2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL2), 200);
        JSONObject result2 = new JSONObject(list2.getContentAsString());
        JSONArray lookupResult2 = result2.getJSONArray(FIELD_DATA);
        JSONArray assets = new JSONArray();
        JSONArray paths2 = new JSONArray();
        JSONArray omitted = new JSONArray();
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult2.length() > 4 ? 1 : 0) != 0);
        for (int i = 0; i < lookupResult2.length(); ++i) {
            if (i < 2) {
                omitted.put(lookupResult2.getJSONObject(i).get("path"));
                continue;
            }
            if (i < 4) {
                paths2.put(lookupResult2.getJSONObject(i).get("path"));
                continue;
            }
            assets.put((Object)lookupResult2.getJSONObject(i));
        }
        JSONObject revertForm = new JSONObject();
        revertForm.put("assets", (Object)assets);
        revertForm.put("paths", (Object)paths2);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(reverterURL, revertForm.toString(), "application/json"), 200);
        TestWebScriptServer.Response listTwo = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL2), 200);
        JSONObject resultTwo = new JSONObject(listTwo.getContentAsString());
        JSONArray lookupResultTwo = resultTwo.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResultTwo.length() == 2 ? 1 : 0) != 0);
        JSONObject submitOmitted = new JSONObject();
        submitOmitted.put("paths", (Object)omitted);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(reverterURL, submitOmitted.toString(), "application/json"), 200);
        this.checkSandboxEmpty(webprojref, sandboxref);
    }

    public void testRevertAssetsWebAppTest() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        String sandboxref = this.createSandbox(webprojref, USER_ONE);
        this.createFolder(webprojref, sandboxref, "/www/avm_webapps", WEBAPP_YELLOW);
        String submitterURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/submitter";
        JSONObject submitForm = new JSONObject();
        submitForm.put("label", (Object)"the label");
        submitForm.put("comment", (Object)"the comment");
        submitForm.put("all", true);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(submitterURL, submitForm.toString(), "application/json"), 200);
        Thread.sleep(15000L);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "rootFile1");
        this.createFile(webprojref, sandboxref, WEBAPP_YELLOW, "/", "yellowFile1");
        String reverterURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/reverter?webApp=" + WEBAPP_YELLOW;
        JSONObject revertForm = new JSONObject();
        revertForm.put("all", true);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(reverterURL, revertForm.toString(), "application/json"), 200);
        String sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/modified";
        TestWebScriptServer.Response list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        JSONObject result = new JSONObject(list.getContentAsString());
        JSONArray lookupResult = result.getJSONArray(FIELD_DATA);
        AssetTest.assertTrue((String)"testListUserSandbox", (lookupResult.length() == 1 ? 1 : 0) != 0);
        JSONObject x = lookupResult.getJSONObject(0);
        String name = x.getString("name");
        AssetTest.assertNotNull((String)"name is null", (Object)name);
        AssetTest.assertEquals((String)"name is wrong", (String)"rootFile1", (String)name);
    }

    public void testGetAsset() throws Exception {
        String YELLOW_FILE = "YellowFile.xyz";
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        String sandboxref = this.createSandbox(webprojref, USER_ONE);
        this.createFolder(webprojref, sandboxref, "/www/avm_webapps", WEBAPP_YELLOW);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", ROOT_FILE);
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/", "characters");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/characters", "Buffy Ann Summers.jpg");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/characters", "Willow Rosenberg.png");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/characters", "Joyce Summers.jpg");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/characters", "Cordelia Chase.jpg");
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/characters", "out");
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/characters/out", "Giles");
        this.createFile(webprojref, sandboxref, WEBAPP_YELLOW, "/", "YellowFile.xyz");
        String rootURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + "/www/avm_webapps/" + WEBAPP_ROOT;
        TestWebScriptServer.Response root = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(rootURL), 200);
        JSONObject result = new JSONObject(root.getContentAsString());
        System.out.println(root.getContentAsString());
        JSONObject rootDir = result.getJSONObject(FIELD_DATA);
        String name = rootDir.getString("name");
        JSONArray children = rootDir.getJSONArray("children");
        AssetTest.assertEquals((String)"name is wrong", (String)WEBAPP_ROOT, (String)name);
        AssetTest.assertEquals((String)"too many children", (int)children.length(), (int)2);
        String yellowURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + "/www/avm_webapps/" + WEBAPP_YELLOW + "/" + "YellowFile.xyz";
        TestWebScriptServer.Response yellow = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(yellowURL), 200);
        result = new JSONObject(yellow.getContentAsString());
        JSONObject yellowFile = result.getJSONObject(FIELD_DATA);
        name = yellowFile.getString("name");
        long version = yellowFile.getLong("version");
        long fileSize = yellowFile.getLong("fileSize");
        AssetTest.assertEquals((String)"name is wrong", (String)"YellowFile.xyz", (String)name);
        yellowURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + "/" + "YellowFile.xyz" + "?webApp=" + WEBAPP_YELLOW;
        yellow = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(yellowURL), 200);
        result = new JSONObject(yellow.getContentAsString());
        yellowFile = result.getJSONObject(FIELD_DATA);
        name = yellowFile.getString("name");
        version = yellowFile.getLong("version");
        fileSize = yellowFile.getLong("fileSize");
        AssetTest.assertEquals((String)"name is wrong", (String)"YellowFile.xyz", (String)name);
        yellowURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + "/www/avm_webapps/" + WEBAPP_YELLOW + "/crap";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(yellowURL), 404);
        yellowURL = "/api/wcm/webprojects/crap/sandboxes/" + sandboxref + "/assets" + "/www/avm_webapps/" + WEBAPP_YELLOW + "/" + "YellowFile.xyz";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(yellowURL), 404);
        yellowURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + "crap" + "/assets" + "/www/avm_webapps/" + WEBAPP_YELLOW + "/" + "YellowFile.xyz";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(yellowURL), 404);
    }

    public void testDeleteAsset() throws Exception {
        String YELLOW_FILE = "YellowFile.xyz";
        String YELLOW_FILE2 = "Buffy.jpg";
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        String sandboxref = this.createSandbox(webprojref, USER_ONE);
        this.createFolder(webprojref, sandboxref, "/www/avm_webapps", WEBAPP_YELLOW);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", ROOT_FILE);
        this.createFile(webprojref, sandboxref, WEBAPP_YELLOW, "/", "YellowFile.xyz");
        this.createFile(webprojref, sandboxref, WEBAPP_YELLOW, "/", "Buffy.jpg");
        String rootURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + "/www/avm_webapps/" + WEBAPP_ROOT;
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(rootURL), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(rootURL), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(rootURL), 404);
        String yellowURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + "/www/avm_webapps/" + WEBAPP_YELLOW + "/" + "YellowFile.xyz";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(yellowURL), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(yellowURL), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(yellowURL), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(yellowURL), 404);
        yellowURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + "/" + "Buffy.jpg" + "?webApp=" + WEBAPP_YELLOW;
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(yellowURL), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(yellowURL), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(yellowURL), 404);
        yellowURL = "/api/wcm/webprojects/crap/sandboxes/" + sandboxref + "/assets" + "/www/avm_webapps/" + WEBAPP_YELLOW + "/" + "YellowFile.xyz";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(yellowURL), 404);
        yellowURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + "crap" + "/assets" + "/www/avm_webapps/" + WEBAPP_YELLOW + "/" + "YellowFile.xyz";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(yellowURL), 404);
    }

    public void testCreateAsset() throws Exception {
        String YELLOW_FILE = "YellowFile.xyz";
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        String sandboxref = this.createSandbox(webprojref, USER_ONE);
        String rootURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + "/www/avm_webapps";
        JSONObject submitForm = new JSONObject();
        submitForm.put("name", (Object)WEBAPP_YELLOW);
        submitForm.put("type", (Object)"folder");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(rootURL, submitForm.toString(), "application/json"), 201);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject lookupResult = result.getJSONObject(FIELD_DATA);
        String name = lookupResult.getString("name");
        boolean isFolder = lookupResult.getBoolean("isFolder");
        boolean isFile = lookupResult.getBoolean("isFile");
        AssetTest.assertEquals((String)"name is wrong", (String)WEBAPP_YELLOW, (String)name);
        AssetTest.assertTrue((String)"folder not true", (boolean)isFolder);
        AssetTest.assertFalse((String)"file not false", (boolean)isFile);
        rootURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + "/www/avm_webapps/" + WEBAPP_ROOT;
        submitForm = new JSONObject();
        submitForm.put("name", (Object)ROOT_FILE);
        submitForm.put("type", (Object)"file");
        submitForm.put(FIELD_CONTENT, (Object)"Hello World");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(rootURL, submitForm.toString(), "application/json"), 201);
        result = new JSONObject(response.getContentAsString());
        lookupResult = result.getJSONObject(FIELD_DATA);
        name = lookupResult.getString("name");
        long fileSize = lookupResult.getLong("fileSize");
        AssetTest.assertEquals((String)"name is wrong", (String)ROOT_FILE, (String)name);
        boolean isFolder2 = lookupResult.getBoolean("isFolder");
        boolean isFile2 = lookupResult.getBoolean("isFile");
        AssetTest.assertTrue((String)"file not true", (boolean)isFile2);
        AssetTest.assertFalse((String)"folder not false", (boolean)isFolder2);
        AssetTest.assertTrue((String)"file is empty", (fileSize > 0L ? 1 : 0) != 0);
        rootURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + "/www/avm_webapps/" + WEBAPP_YELLOW;
        submitForm = new JSONObject();
        submitForm.put("name", (Object)"YellowFile.xyz");
        submitForm.put("type", (Object)"file");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(rootURL, submitForm.toString(), "application/json"), 201);
        rootURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets/" + "?webApp=" + WEBAPP_YELLOW;
        submitForm = new JSONObject();
        submitForm.put("name", (Object)"willow.jpg");
        submitForm.put("type", (Object)"file");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(rootURL, submitForm.toString(), "application/json"), 201);
        this.createFolder(webprojref, sandboxref, WEBAPP_YELLOW, "/", "humans");
        rootURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets/humans" + "?webApp=" + WEBAPP_YELLOW;
        submitForm = new JSONObject();
        submitForm.put("name", (Object)"dawn.jpg");
        submitForm.put("type", (Object)"file");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(rootURL, submitForm.toString(), "application/json"), 201);
        result = new JSONObject(response.getContentAsString());
        lookupResult = result.getJSONObject(FIELD_DATA);
        name = lookupResult.getString("name");
        String path = lookupResult.getString("path");
        AssetTest.assertEquals((String)"name not correct", (String)name, (String)"dawn.jpg");
        AssetTest.assertEquals((String)"path not correct", (String)path, (String)"/www/avm_webapps/YELLOW/humans/dawn.jpg");
    }

    public void testRenameAsset() throws Exception {
        String YELLOW_FILE = "buffy.jpg";
        String PURPLE_FILE = "buffy.htm";
        String PURPLE_FILE2 = "willow.htm";
        String ROOT_MOVED_FILE = "smashing.htm";
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        String sandboxref = this.createSandbox(webprojref, USER_ONE);
        this.createFolder(webprojref, sandboxref, "/www/avm_webapps", WEBAPP_YELLOW);
        this.createFile(webprojref, sandboxref, WEBAPP_YELLOW, "/", "buffy.jpg");
        String yellowURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + "/www/avm_webapps/" + WEBAPP_YELLOW;
        JSONObject submitForm = new JSONObject();
        submitForm.put("name", (Object)WEBAPP_GREEN);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(yellowURL, submitForm.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject lookupResult = result.getJSONObject(FIELD_DATA);
        String name = lookupResult.getString("name");
        AssetTest.assertEquals((String)"name is wrong", (String)WEBAPP_GREEN, (String)name);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", ROOT_FILE);
        yellowURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + "/www/avm_webapps/" + WEBAPP_ROOT + "/" + ROOT_FILE;
        submitForm = new JSONObject();
        submitForm.put("name", (Object)"smashing.htm");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(yellowURL, submitForm.toString(), "application/json"), 200);
        result = new JSONObject(response.getContentAsString());
        lookupResult = result.getJSONObject(FIELD_DATA);
        name = lookupResult.getString("name");
        AssetTest.assertEquals((String)"name is wrong", (String)"smashing.htm", (String)name);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(yellowURL, submitForm.toString(), "application/json"), 404);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", "buffy.htm");
        String purpleURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets/" + "buffy.htm" + "?webApp=" + WEBAPP_ROOT;
        submitForm = new JSONObject();
        submitForm.put("name", (Object)"willow.htm");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(purpleURL, submitForm.toString(), "application/json"), 200);
        result = new JSONObject(response.getContentAsString());
        lookupResult = result.getJSONObject(FIELD_DATA);
        name = lookupResult.getString("name");
        AssetTest.assertEquals((String)"name is wrong", (String)"willow.htm", (String)name);
        yellowURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + "crap" + "/assets" + "/www/avm_webapps/" + WEBAPP_ROOT + "/" + "smashing.htm";
        submitForm = new JSONObject();
        submitForm.put("name", (Object)"smashing.htm");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(yellowURL, submitForm.toString(), "application/json"), 404);
    }

    public void testMoveAsset() throws Exception {
        String YELLOW_FILE = "buffy.jpg";
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        String sandboxref = this.createSandbox(webprojref, USER_ONE);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", ROOT_FILE);
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/", "actors");
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/actors", "humans");
        String myURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + "/www/avm_webapps/" + WEBAPP_ROOT + "/" + ROOT_FILE;
        JSONObject submitForm = new JSONObject();
        submitForm.put("path", (Object)"/www/avm_webapps/ROOT/actors/humans");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(myURL, submitForm.toString(), "application/json"), 200);
        System.out.println(response.getContentAsString());
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject lookupResult = result.getJSONObject(FIELD_DATA);
        String name = lookupResult.getString("name");
        AssetTest.assertEquals((String)"name is wrong", (String)ROOT_FILE, (String)name);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(myURL, submitForm.toString(), "application/json"), 404);
    }

    public void testUpdateAssetProperties() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        String sandboxref = this.createSandbox(webprojref, AuthenticationUtil.getAdminUserName());
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", ROOT_FILE);
        this.updatePropertiesAndAssert(webprojref, sandboxref, ROOT_FILE, "Renamed_index.htm");
        this.createFolder(webprojref, sandboxref, WEBAPP_ROOT, "/", WEBAPP_GREEN);
        this.updatePropertiesAndAssert(webprojref, sandboxref, WEBAPP_GREEN, "Renamed_GREEN");
    }

    private void updatePropertiesAndAssert(String webprojref, String sandboxref, String oldName, String updatedName) throws JSONException, IOException, UnsupportedEncodingException {
        String propertiesUrl = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets/properties/www/avm_webapps/" + WEBAPP_ROOT + "/" + oldName;
        JSONObject properties = new JSONObject();
        properties.put(ContentModel.PROP_TITLE.getLocalName(), (Object)updatedName);
        properties.put(ContentModel.PROP_NAME.getLocalName(), (Object)updatedName);
        JSONObject submitForm = new JSONObject();
        submitForm.put(FIELD_PROPERTIES, (Object)properties);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(propertiesUrl, submitForm.toString(), "application/json"), 202);
        this.assertUpdatedProperties(updatedName, response);
        String assetRequestUrl = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets/www/avm_webapps/" + WEBAPP_ROOT + "/" + updatedName;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(assetRequestUrl), 200);
        this.assertUpdatedProperties(updatedName, response);
        assetRequestUrl = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets/www/avm_webapps" + WEBAPP_ROOT + "/" + oldName;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(assetRequestUrl), 404);
    }

    private void assertUpdatedProperties(String updatedName, TestWebScriptServer.Response response) throws JSONException, UnsupportedEncodingException {
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject properties = (JSONObject)result.get(FIELD_DATA);
        properties = (JSONObject)properties.get(FIELD_PROPERTIES);
        AssetTest.assertEquals((Object)updatedName, (Object)properties.get(PROP_TITLE));
        AssetTest.assertEquals((Object)updatedName, (Object)properties.get(PROP_NAME));
    }

    public void testGetAndUpdateAssetContent() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        String sandboxref = this.createSandbox(webprojref, USER_ONE);
        this.createFile(webprojref, sandboxref, WEBAPP_ROOT, "/", ROOT_FILE);
        String contentRequestUrl = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets/content/www/avm_webapps/" + WEBAPP_ROOT + "/" + ROOT_FILE;
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(contentRequestUrl), 500);
        String propertiesRequestUrl = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets/properties/www/avm_webapps/" + WEBAPP_ROOT + "/" + ROOT_FILE;
        JSONObject contentEntry = new JSONObject();
        String content = TEST_CONTENT_ENTRY;
        contentEntry.put(FIELD_CONTENT, (Object)content);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(propertiesRequestUrl, contentEntry.toString(), "application/json"), 202);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(contentRequestUrl), 200);
        contentEntry = new JSONObject(response.getContentAsString());
        AssetTest.assertEquals((Object)content, (Object)contentEntry.get(FIELD_CONTENT));
    }

    private void createFolder(String webprojref, String sandboxref, String parent, String name) throws Exception {
        String rootURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + parent;
        JSONObject submitForm = new JSONObject();
        submitForm.put("name", (Object)name);
        submitForm.put("type", (Object)"folder");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(rootURL, submitForm.toString(), "application/json"), 201);
    }

    private void createFolder(String webprojref, String sandboxref, String webApp, String parent, String name) throws Exception {
        String rootURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + parent + "?webApp=" + webApp;
        JSONObject submitForm = new JSONObject();
        submitForm.put("name", (Object)name);
        submitForm.put("type", (Object)"folder");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(rootURL, submitForm.toString(), "application/json"), 201);
    }

    private void createFile(String webprojref, String sandboxref, String parent, String name) throws Exception {
        String rootURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + parent;
        JSONObject submitForm = new JSONObject();
        submitForm.put("name", (Object)name);
        submitForm.put("type", (Object)"file");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(rootURL, submitForm.toString(), "application/json"), 201);
    }

    private void createFile(String webprojref, String sandboxref, String webApp, String parent, String name) throws Exception {
        String rootURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + parent + "?webApp=" + webApp;
        JSONObject submitForm = new JSONObject();
        submitForm.put("name", (Object)name);
        submitForm.put("type", (Object)"file");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(rootURL, submitForm.toString(), "application/json"), 201);
    }

    private void deleteFile(String webprojref, String sandboxref, String path) throws Exception {
        String deleteURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "/" + sandboxref + "/assets" + path;
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(deleteURL), 200);
    }
}

