/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.wiki;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.wiki.AbstractWikiWebScript;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.wiki.WikiPageInfo;
import org.alfresco.util.UrlUtil;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class WikiPageListGet
extends AbstractWikiWebScript {
    protected static final int RECENT_SEARCH_PERIOD_DAYS = 7;
    protected static final long ONE_DAY_MS = 86400000L;
    private SysAdminParams sysAdminParams;

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String pageTitle, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        NodeRef container;
        String filter = req.getParameter("filter");
        String strPageMetaOnly = req.getParameter("pageMetaOnly");
        boolean pageMetaOnly = strPageMetaOnly != null ? Boolean.parseBoolean(strPageMetaOnly) : false;
        boolean userFiltering = false;
        String user = null;
        if ("user".equals(filter) || "myPages".equals(filter)) {
            userFiltering = true;
            user = AuthenticationUtil.getFullyAuthenticatedUser();
        }
        boolean dateFiltering = false;
        boolean dateIsCreated = true;
        Date from = null;
        Date to = null;
        if ("recentlyAdded".equals(filter) || "recentlyCreated".equals(filter) || "recentlyModified".equals(filter)) {
            dateFiltering = true;
            if ("recentlyModified".equals(filter)) {
                dateIsCreated = false;
            }
            int days = 7;
            String daysS = req.getParameter("days");
            if (daysS != null && daysS.length() > 0) {
                days = Integer.parseInt(daysS);
            }
            Date now = new Date();
            from = new Date(now.getTime() - (long)days * 86400000L);
            to = new Date(now.getTime() + 86400000L);
        }
        PagingRequest paging = this.buildPagingRequest(req);
        PagingResults pages = userFiltering ? this.wikiService.listWikiPages(site.getShortName(), user, paging) : (dateFiltering ? (dateIsCreated ? this.wikiService.listWikiPagesByCreated(site.getShortName(), from, to, paging) : this.wikiService.listWikiPagesByModified(site.getShortName(), from, to, paging)) : this.wikiService.listWikiPages(site.getShortName(), paging));
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        for (WikiPageInfo page : pages.getPage()) {
            Map<String, Object> result = this.renderWikiPage(page);
            items.add(result);
        }
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        data.put("pages", items);
        data.put("pageSize", Integer.valueOf(paging.getMaxItems()));
        data.put("startIndex", Integer.valueOf(paging.getSkipCount()));
        data.put("itemCount", Integer.valueOf(items.size()));
        int total = items.size();
        if (pages.getTotalResultCount() != null && pages.getTotalResultCount().getFirst() != null) {
            total = (Integer)pages.getTotalResultCount().getFirst();
        }
        data.put("total", Integer.valueOf(total));
        if (pages.getPage().size() > 0) {
            container = ((WikiPageInfo)pages.getPage().get(0)).getContainerNodeRef();
        } else {
            container = this.siteService.getContainer(site.getShortName(), "wiki");
            if (container == null) {
                container = site.getNodeRef();
            }
        }
        HashMap<String, ArrayList<Map<String, Object>>> wiki = new HashMap<String, ArrayList<Map<String, Object>>>();
        wiki.put("pages", items);
        wiki.put("container", (ArrayList<Map<String, Object>>)container);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("data", data);
        model.put("wiki", wiki);
        model.put("siteId", site.getShortName());
        model.put("site", site);
        model.put("shareUrl", UrlUtil.getShareUrl((SysAdminParams)this.sysAdminParams));
        model.put("pageMetaOnly", pageMetaOnly);
        return model;
    }
}

