/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.wiki;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.wiki.AbstractWikiWebScript;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.wiki.WikiPageInfo;
import org.alfresco.service.namespace.QName;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class WikiPagePut
extends AbstractWikiWebScript {
    private static final String DEFAULT_PAGE_CONTENT = "This is a new page. It has no content";
    private VersionService versionService;

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String pageTitle, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        WikiPageInfo page;
        HashMap<String, Object> model = new HashMap<String, Object>();
        String contents = (String)json.get((Object)"pagecontent");
        String title = json.containsKey((Object)"title") ? (String)json.get((Object)"title") : pageTitle;
        boolean forceSave = json.containsKey((Object)"forceSave");
        String currentVersion = null;
        if (json.containsKey((Object)"currentVersion")) {
            currentVersion = (String)json.get((Object)"currentVersion");
        }
        ArrayList<String> tags = null;
        if (json.containsKey((Object)"tags")) {
            tags = new ArrayList<String>();
            if (!json.get((Object)"tags").equals("")) {
                JSONArray tagsA = (JSONArray)json.get((Object)"tags");
                for (int i = 0; i < tagsA.size(); ++i) {
                    tags.add((String)tagsA.get(i));
                }
            }
        }
        if ((page = this.wikiService.getWikiPage(site.getShortName(), pageTitle)) == null) {
            page = this.wikiService.createWikiPage(site.getShortName(), title, contents);
            if (tags != null && tags.size() > 0) {
                page.getTags().addAll(tags);
                this.wikiService.updateWikiPage(page);
            }
            this.makeVersioned(page);
            this.addActivityEntry("created", page, site, req, json);
        } else {
            if (forceSave || this.pageVersionMatchesSubmitted(page, currentVersion)) {
                page.setContents(contents);
                if (tags != null) {
                    page.getTags().clear();
                    page.getTags().addAll(tags);
                }
            } else {
                String message = "Repository version is newer.";
                throw new WebScriptException(409, message);
            }
            this.wikiService.updateWikiPage(page);
            this.addActivityEntry("edited", page, site, req, json);
        }
        model.put("page", page);
        model.put("site", site);
        model.put("siteId", site.getShortName());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", model);
        return result;
    }

    private boolean pageVersionMatchesSubmitted(WikiPageInfo page, String currentVersion) {
        if (currentVersion == null) {
            return false;
        }
        Version version = this.versionService.getCurrentVersion(page.getNodeRef());
        if (version == null) {
            this.makeVersioned(page);
            return true;
        }
        return version.getVersionLabel().equals(currentVersion);
    }

    private void makeVersioned(WikiPageInfo page) {
        HashMap<QName, Boolean> versionProps = new HashMap<QName, Boolean>();
        versionProps.put(ContentModel.PROP_AUTO_VERSION, true);
        versionProps.put(ContentModel.PROP_AUTO_VERSION_PROPS, true);
        this.versionService.ensureVersioningEnabled(page.getNodeRef(), versionProps);
    }
}

