/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.wiki;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.wiki.WikiPageInfo;
import org.alfresco.service.cmr.wiki.WikiService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class WikiRestApiTest
extends BaseWebScriptTest {
    private static Log logger = LogFactory.getLog(WikiRestApiTest.class);
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private BehaviourFilter policyBehaviourFilter;
    private PersonService personService;
    private NodeService nodeService;
    private NodeService internalNodeService;
    private SiteService siteService;
    private WikiService wikiService;
    private static final String USER_ONE = "UserOneSecondToo";
    private static final String USER_TWO = "UserTwoSecondToo";
    private static final String USERDETAILS_FIRSTNAME = "FirstName123";
    private static final String USERDETAILS_LASTNAME = "LastName123";
    private static final String SITE_SHORT_NAME_WIKI = "WikiSiteShortNameTest";
    private static final String PAGE_TITLE_ONE = "TestPageOne";
    private static final String PAGE_TITLE_TWO = "Test Page Two";
    private static final String PAGE_TITLE_THREE = "Still Test Page Three";
    private static final String PAGE_CONTENTS_ONE = "http://google.com/";
    private static final String PAGE_CONTENTS_TWO = "http://alfresco.com/";
    private static final String PAGE_CONTENTS_THREE = "http://share.alfresco.com/";
    private static final String PAGE_CONTENTS_LINK = "Text text [[TestPageOne|P1]] [[Test_Page_Two|P2]] [[Invalid|Invalid]] text";
    private static final String URL_WIKI_BASE = "/slingshot/wiki/page";
    private static final String URL_WIKI_LIST = "/slingshot/wiki/pages/WikiSiteShortNameTest";
    private static final String URL_WIKI_FETCH = "/slingshot/wiki/page/WikiSiteShortNameTest/";
    private static final String URL_WIKI_UPDATE = "/slingshot/wiki/page/WikiSiteShortNameTest/";
    private static final String URL_WIKI_DELETE = "/slingshot/wiki/page/WikiSiteShortNameTest/";
    private static final String URL_WIKI_RENAME = "/slingshot/wiki/page/WikiSiteShortNameTest/";
    private static final String URL_WIKI_VERSION = "/slingshot/wiki/version/WikiSiteShortNameTest/";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.policyBehaviourFilter = (BehaviourFilter)this.getServer().getApplicationContext().getBean("policyBehaviourFilter");
        this.transactionService = (TransactionService)this.getServer().getApplicationContext().getBean("transactionService");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.wikiService = (WikiService)this.getServer().getApplicationContext().getBean("WikiService");
        this.internalNodeService = (NodeService)this.getServer().getApplicationContext().getBean("nodeService");
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME_WIKI);
        if (siteInfo == null) {
            this.siteService.createSite("WikiSitePreset", SITE_SHORT_NAME_WIKI, "WikiSiteTitle", "TestDescription", SiteVisibility.PUBLIC);
        }
        if (!this.siteService.hasContainer(SITE_SHORT_NAME_WIKI, "wiki")) {
            this.siteService.createContainer(SITE_SHORT_NAME_WIKI, "wiki", null, null);
        }
        this.createUser(USER_ONE, "SiteCollaborator");
        this.createUser(USER_TWO, "SiteCollaborator");
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.siteService.deleteSite(SITE_SHORT_NAME_WIKI);
        if (this.personService.personExists(USER_ONE)) {
            this.personService.deletePerson(USER_ONE);
        }
        if (this.authenticationService.authenticationExists(USER_ONE)) {
            this.authenticationService.deleteAuthentication(USER_ONE);
        }
        if (this.personService.personExists(USER_TWO)) {
            this.personService.deletePerson(USER_TWO);
        }
        if (this.authenticationService.authenticationExists(USER_TWO)) {
            this.authenticationService.deleteAuthentication(USER_TWO);
        }
    }

    private void createUser(String userName, String role) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)USERDETAILS_FIRSTNAME);
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)USERDETAILS_LASTNAME);
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
            this.personService.createPerson((Map)personProps);
        }
        this.siteService.setMembership(SITE_SHORT_NAME_WIKI, userName, role);
    }

    private JSONObject getPages(String filter, String username) throws Exception {
        String origUser = this.authenticationComponent.getCurrentUserName();
        if (username != null) {
            this.authenticationComponent.setCurrentUser(username);
            filter = "myPages";
        }
        String url = URL_WIKI_LIST;
        if (filter == null) {
            filter = "all";
        }
        url = url + "?filter=" + filter;
        url = url + "&startIndex=0&page=1&pageSize=4";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        if (username != null) {
            this.authenticationComponent.setCurrentUser(origUser);
        }
        return result;
    }

    private JSONObject getPage(String name, int expectedStatus) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/slingshot/wiki/page/WikiSiteShortNameTest/" + name), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            if (result.has("page")) {
                return result.getJSONObject("page");
            }
            return result;
        }
        if (expectedStatus == 404) {
            JSONObject result = new JSONObject(response.getContentAsString());
            return result;
        }
        return null;
    }

    private String getPageAtVersion(String name, String version, int expectedStatus) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_WIKI_VERSION + name + "/" + version), expectedStatus);
        if (expectedStatus == 200) {
            return response.getContentAsString();
        }
        if (expectedStatus == 404) {
            return response.getContentAsString();
        }
        return null;
    }

    private JSONObject createOrUpdatePage(String title, String contents, String version, int expectedStatus) throws Exception {
        String name = title.replace(' ', '_');
        JSONObject json = new JSONObject();
        json.put("site", (Object)SITE_SHORT_NAME_WIKI);
        json.put("title", (Object)title);
        json.put("pagecontent", (Object)contents);
        json.put("tags", (Object)"");
        json.put("page", (Object)"wiki-page");
        if (version == null || "force".equals(version)) {
            json.put("forceSave", (Object)"true");
        } else if (!"none".equals(version)) {
            json.put("currentVersion", (Object)version);
        }
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/slingshot/wiki/page/WikiSiteShortNameTest/" + name, json.toString(), "application/json"), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            if (result.has("page")) {
                return result.getJSONObject("page");
            }
            return result;
        }
        return null;
    }

    private JSONObject renamePage(String oldTitle, String newTitle, int expectedStatus) throws Exception {
        String name = oldTitle.replace(' ', '_');
        JSONObject json = new JSONObject();
        json.put("site", (Object)SITE_SHORT_NAME_WIKI);
        json.put("name", (Object)newTitle);
        json.put("page", (Object)"wiki-page");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/slingshot/wiki/page/WikiSiteShortNameTest/" + name, json.toString(), "application/json"), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            return result;
        }
        return null;
    }

    private JSONObject deletePage(String title, int expectedStatus) throws Exception {
        String name = title.replace(' ', '_');
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/slingshot/wiki/page/WikiSiteShortNameTest/" + name), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            return result;
        }
        return null;
    }

    private void pushPageCreatedDateBack(String name, int daysAgo) throws Exception {
        NodeRef container = this.siteService.getContainer(SITE_SHORT_NAME_WIKI, "wiki");
        NodeRef node = this.nodeService.getChildByName(container, ContentModel.ASSOC_CONTAINS, name);
        Date created = (Date)this.nodeService.getProperty(node, ContentModel.PROP_CREATED);
        Date newCreated = new Date(created.getTime() - (long)(daysAgo * 24 * 60 * 60 * 1000));
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        this.internalNodeService.setProperty(node, ContentModel.PROP_CREATED, (Serializable)newCreated);
        this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
        txn.commit();
        this.nodeService.setProperty(node, ContentModel.PROP_CREATED, (Serializable)newCreated);
        this.nodeService.setProperty(node, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Forced change"));
    }

    public void testCreateEditDeleteEntry() throws Exception {
        JSONObject page = this.getPages(null, null);
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + page.toString()), (boolean)true, (boolean)page.has("totalPages"));
        WikiRestApiTest.assertEquals((int)0, (int)page.getInt("totalPages"));
        page = this.getPage(PAGE_TITLE_ONE, 404);
        page = this.createOrUpdatePage(PAGE_TITLE_ONE, PAGE_CONTENTS_ONE, null, 200);
        String name = PAGE_TITLE_ONE.replace(' ', '_');
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + page.toString()), (boolean)true, (boolean)page.has("title"));
        WikiRestApiTest.assertEquals((String)name, (String)page.getString("name"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)page.getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_CONTENTS_ONE, (String)page.getString("pagetext"));
        WikiRestApiTest.assertEquals((int)0, (int)page.getJSONArray("tags").length());
        page = this.getPage(name, 200);
        WikiRestApiTest.assertEquals((String)name, (String)page.getString("name"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)page.getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_CONTENTS_ONE, (String)page.getString("pagetext"));
        WikiRestApiTest.assertEquals((int)0, (int)page.getJSONArray("tags").length());
        WikiRestApiTest.assertEquals((int)0, (int)page.getJSONArray("links").length());
        WikiRestApiTest.assertEquals((boolean)true, (boolean)page.has("permissions"));
        JSONObject permissions = page.getJSONObject("permissions");
        WikiRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("create"));
        WikiRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("edit"));
        WikiRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("delete"));
        page = this.createOrUpdatePage(PAGE_TITLE_ONE, "Mhttp://google.com/", null, 200);
        WikiRestApiTest.assertEquals((String)name, (String)page.getString("name"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)page.getString("title"));
        WikiRestApiTest.assertEquals((String)"Mhttp://google.com/", (String)page.getString("pagetext"));
        WikiRestApiTest.assertEquals((int)0, (int)page.getJSONArray("tags").length());
        page = this.getPage(name, 200);
        WikiRestApiTest.assertEquals((String)name, (String)page.getString("name"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)page.getString("title"));
        WikiRestApiTest.assertEquals((String)"Mhttp://google.com/", (String)page.getString("pagetext"));
        WikiRestApiTest.assertEquals((int)0, (int)page.getJSONArray("tags").length());
        WikiRestApiTest.assertEquals((int)0, (int)page.getJSONArray("links").length());
        this.authenticationComponent.setCurrentUser(USER_TWO);
        page = this.getPage(name, 200);
        WikiRestApiTest.assertEquals((String)name, (String)page.getString("name"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)page.getString("title"));
        WikiRestApiTest.assertEquals((String)"Mhttp://google.com/", (String)page.getString("pagetext"));
        WikiRestApiTest.assertEquals((int)0, (int)page.getJSONArray("tags").length());
        WikiRestApiTest.assertEquals((int)0, (int)page.getJSONArray("links").length());
        WikiRestApiTest.assertEquals((boolean)true, (boolean)page.has("permissions"));
        permissions = page.getJSONObject("permissions");
        WikiRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("create"));
        WikiRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("edit"));
        WikiRestApiTest.assertEquals((boolean)false, (boolean)permissions.getBoolean("delete"));
        this.authenticationComponent.setCurrentUser(USER_ONE);
        page = this.deletePage(name, 204);
        WikiRestApiTest.assertEquals(null, (Object)page);
        page = this.getPage(name, 404);
        WikiRestApiTest.assertEquals((boolean)true, (boolean)page.has("permissions"));
        permissions = page.getJSONObject("permissions");
        WikiRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("create"));
        WikiRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("edit"));
        WikiRestApiTest.assertEquals((boolean)false, (boolean)permissions.has("delete"));
        this.deletePage(name, 404);
    }

    public void testRenaming() throws Exception {
        JSONObject page = this.createOrUpdatePage(PAGE_TITLE_TWO, PAGE_CONTENTS_ONE, null, 200);
        String name = PAGE_TITLE_TWO.replace(' ', '_');
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + page.toString()), (boolean)true, (boolean)page.has("title"));
        page = this.getPage(name, 200);
        WikiRestApiTest.assertEquals((String)name, (String)page.getString("name"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_TWO, (String)page.getString("title"));
        page = this.renamePage(PAGE_TITLE_TWO, PAGE_TITLE_THREE, 200);
        String name2 = PAGE_TITLE_THREE.replace(' ', '_');
        WikiRestApiTest.assertEquals((String)name2, (String)page.getString("name"));
        page = this.getPage(name2, 200);
        WikiRestApiTest.assertEquals((String)name2, (String)page.getString("name"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_THREE, (String)page.getString("title"));
        page = this.getPage(name, 200);
        WikiRestApiTest.assertEquals((String)name, (String)page.getString("name"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_TWO, (String)page.getString("title"));
        WikiRestApiTest.assertEquals((String)("This page has been moved [[" + name2 + "|here]]."), (String)page.getString("pagetext"));
        page = this.createOrUpdatePage(PAGE_TITLE_ONE, PAGE_CONTENTS_THREE, null, 200);
        String name1 = PAGE_TITLE_ONE.replace(' ', '_');
        this.renamePage(PAGE_TITLE_THREE, PAGE_TITLE_ONE, 409);
        page = this.getPage(name2, 200);
        WikiRestApiTest.assertEquals((String)name2, (String)page.getString("name"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_THREE, (String)page.getString("title"));
        page = this.getPage(name1, 200);
        WikiRestApiTest.assertEquals((String)name1, (String)page.getString("name"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)page.getString("title"));
    }

    public void testVersioning() throws Exception {
        JSONObject page = this.createOrUpdatePage(PAGE_TITLE_TWO, PAGE_CONTENTS_ONE, null, 200);
        String name = PAGE_TITLE_TWO.replace(' ', '_');
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + page.toString()), (boolean)true, (boolean)page.has("title"));
        WikiPageInfo wikiInfo = this.wikiService.getWikiPage(SITE_SHORT_NAME_WIKI, name);
        WikiRestApiTest.assertNotNull((Object)wikiInfo);
        WikiRestApiTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(wikiInfo.getNodeRef(), ContentModel.ASPECT_VERSIONABLE));
        page = this.getPage(name, 200);
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + page.toString()), (boolean)true, (boolean)page.has("versionhistory"));
        JSONArray versions = page.getJSONArray("versionhistory");
        WikiRestApiTest.assertEquals((int)1, (int)versions.length());
        WikiRestApiTest.assertEquals((Object)"1.0", (Object)versions.getJSONObject(0).get("version"));
        WikiRestApiTest.assertEquals((Object)USER_ONE, (Object)versions.getJSONObject(0).get("author"));
        String content = this.getPageAtVersion(name, "1.0", 200);
        WikiRestApiTest.assertEquals((String)PAGE_CONTENTS_ONE, (String)content);
        this.createOrUpdatePage(PAGE_TITLE_TWO, "Changed Contents", "none", 409);
        String PAGE_CONTENTS_CHANGED = "Changed Contents 2";
        page = this.createOrUpdatePage(PAGE_TITLE_TWO, PAGE_CONTENTS_CHANGED, "1.0", 200);
        page = this.getPage(name, 200);
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + page.toString()), (boolean)true, (boolean)page.has("versionhistory"));
        versions = page.getJSONArray("versionhistory");
        WikiRestApiTest.assertEquals((int)2, (int)versions.length());
        WikiRestApiTest.assertEquals((Object)"1.1", (Object)versions.getJSONObject(0).get("version"));
        WikiRestApiTest.assertEquals((Object)USER_ONE, (Object)versions.getJSONObject(0).get("author"));
        WikiRestApiTest.assertEquals((Object)"1.0", (Object)versions.getJSONObject(1).get("version"));
        WikiRestApiTest.assertEquals((Object)USER_ONE, (Object)versions.getJSONObject(1).get("author"));
        content = this.getPageAtVersion(name, "1.1", 200);
        WikiRestApiTest.assertEquals((String)PAGE_CONTENTS_CHANGED, (String)content);
        content = this.getPageAtVersion(name, "1.0", 200);
        WikiRestApiTest.assertEquals((String)PAGE_CONTENTS_ONE, (String)content);
        String PAGE_CONTENTS_CHANGED3 = "Changed Contents 3";
        page = this.createOrUpdatePage(PAGE_TITLE_TWO, PAGE_CONTENTS_CHANGED3, "force", 200);
        page = this.getPage(name, 200);
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + page.toString()), (boolean)true, (boolean)page.has("versionhistory"));
        versions = page.getJSONArray("versionhistory");
        WikiRestApiTest.assertEquals((int)3, (int)versions.length());
        WikiRestApiTest.assertEquals((Object)"1.2", (Object)versions.getJSONObject(0).get("version"));
        WikiRestApiTest.assertEquals((Object)USER_ONE, (Object)versions.getJSONObject(0).get("author"));
        WikiRestApiTest.assertEquals((Object)"1.1", (Object)versions.getJSONObject(1).get("version"));
        WikiRestApiTest.assertEquals((Object)USER_ONE, (Object)versions.getJSONObject(1).get("author"));
        WikiRestApiTest.assertEquals((Object)"1.0", (Object)versions.getJSONObject(2).get("version"));
        WikiRestApiTest.assertEquals((Object)USER_ONE, (Object)versions.getJSONObject(2).get("author"));
        content = this.getPageAtVersion(name, "1.2", 200);
        WikiRestApiTest.assertEquals((String)PAGE_CONTENTS_CHANGED3, (String)content);
        content = this.getPageAtVersion(name, "1.1", 200);
        WikiRestApiTest.assertEquals((String)PAGE_CONTENTS_CHANGED, (String)content);
        content = this.getPageAtVersion(name, "1.0", 200);
        WikiRestApiTest.assertEquals((String)PAGE_CONTENTS_ONE, (String)content);
        content = this.getPageAtVersion(name, "1.4", 200);
        WikiRestApiTest.assertEquals((String)"", (String)content);
    }

    public void testLinks() throws Exception {
        JSONObject page = this.createOrUpdatePage(PAGE_TITLE_TWO, PAGE_CONTENTS_TWO, null, 200);
        String name = PAGE_TITLE_TWO.replace(' ', '_');
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + page.toString()), (boolean)true, (boolean)page.has("title"));
        page = this.getPage(name, 200);
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + page.toString()), (boolean)true, (boolean)page.has("links"));
        JSONArray links = page.getJSONArray("links");
        WikiRestApiTest.assertEquals((int)0, (int)links.length());
        page = this.createOrUpdatePage(PAGE_TITLE_THREE, PAGE_CONTENTS_LINK, null, 200);
        String name2 = PAGE_TITLE_THREE.replace(' ', '_');
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + page.toString()), (boolean)true, (boolean)page.has("title"));
        page = this.getPage(name2, 200);
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + page.toString()), (boolean)true, (boolean)page.has("links"));
        links = page.getJSONArray("links");
        WikiRestApiTest.assertEquals((int)3, (int)links.length());
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)links.getString(0));
        WikiRestApiTest.assertEquals((String)name, (String)links.getString(1));
        WikiRestApiTest.assertEquals((String)"Invalid", (String)links.getString(2));
        page = this.createOrUpdatePage(PAGE_TITLE_ONE, PAGE_CONTENTS_ONE, null, 200);
        page = this.getPage(name2, 200);
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + page.toString()), (boolean)true, (boolean)page.has("links"));
        links = page.getJSONArray("links");
        WikiRestApiTest.assertEquals((int)3, (int)links.length());
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)links.getString(0));
        WikiRestApiTest.assertEquals((String)name, (String)links.getString(1));
        WikiRestApiTest.assertEquals((String)"Invalid", (String)links.getString(2));
    }

    public void testOverallListing() throws Exception {
        JSONObject pages = this.getPages(null, null);
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + pages.toString()), (boolean)true, (boolean)pages.has("totalPages"));
        WikiRestApiTest.assertEquals((int)0, (int)pages.getInt("totalPages"));
        this.createOrUpdatePage(PAGE_TITLE_ONE, PAGE_CONTENTS_ONE, null, 200);
        this.createOrUpdatePage(PAGE_TITLE_TWO, PAGE_CONTENTS_TWO, null, 200);
        pages = this.getPages(null, null);
        WikiRestApiTest.assertEquals((String)("Incorrect JSON: " + pages.toString()), (boolean)true, (boolean)pages.has("totalPages"));
        WikiRestApiTest.assertEquals((int)2, (int)pages.getInt("totalPages"));
        JSONArray entries = pages.getJSONArray("pages");
        WikiRestApiTest.assertEquals((int)2, (int)entries.length());
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_TWO, (String)entries.getJSONObject(0).getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)entries.getJSONObject(1).getString("title"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        JSONObject page3 = this.createOrUpdatePage(PAGE_TITLE_THREE, PAGE_CONTENTS_THREE, null, 200);
        String name3 = PAGE_TITLE_THREE.replace(' ', '_');
        this.createOrUpdatePage(PAGE_TITLE_THREE, "UDhttp://share.alfresco.com/", null, 200);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        pages = this.getPages(null, null);
        WikiRestApiTest.assertEquals((int)3, (int)pages.getInt("totalPages"));
        entries = pages.getJSONArray("pages");
        WikiRestApiTest.assertEquals((int)3, (int)entries.length());
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_THREE, (String)entries.getJSONObject(0).getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_TWO, (String)entries.getJSONObject(1).getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)entries.getJSONObject(2).getString("title"));
        pages = this.getPages(null, USER_ONE);
        WikiRestApiTest.assertEquals((int)2, (int)pages.getInt("totalPages"));
        entries = pages.getJSONArray("pages");
        WikiRestApiTest.assertEquals((int)2, (int)entries.length());
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_TWO, (String)entries.getJSONObject(0).getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)entries.getJSONObject(1).getString("title"));
        pages = this.getPages(null, USER_TWO);
        WikiRestApiTest.assertEquals((int)1, (int)pages.getInt("totalPages"));
        entries = pages.getJSONArray("pages");
        WikiRestApiTest.assertEquals((int)1, (int)entries.length());
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_THREE, (String)entries.getJSONObject(0).getString("title"));
        pages = this.getPages("recentlyAdded", null);
        WikiRestApiTest.assertEquals((int)3, (int)pages.getInt("totalPages"));
        entries = pages.getJSONArray("pages");
        WikiRestApiTest.assertEquals((int)3, (int)entries.length());
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_THREE, (String)entries.getJSONObject(0).getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_TWO, (String)entries.getJSONObject(1).getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)entries.getJSONObject(2).getString("title"));
        this.pushPageCreatedDateBack(name3, 10);
        pages = this.getPages("recentlyAdded", null);
        WikiRestApiTest.assertEquals((int)2, (int)pages.getInt("totalPages"));
        entries = pages.getJSONArray("pages");
        WikiRestApiTest.assertEquals((int)2, (int)entries.length());
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_TWO, (String)entries.getJSONObject(0).getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)entries.getJSONObject(1).getString("title"));
        pages = this.getPages("recentlyModified", null);
        WikiRestApiTest.assertEquals((int)3, (int)pages.getInt("totalPages"));
        entries = pages.getJSONArray("pages");
        WikiRestApiTest.assertEquals((int)3, (int)entries.length());
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_THREE, (String)entries.getJSONObject(0).getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_TWO, (String)entries.getJSONObject(1).getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)entries.getJSONObject(2).getString("title"));
        String pageTwoName = entries.getJSONObject(1).getString("name");
        WikiPageInfo pageTwo = this.wikiService.getWikiPage(SITE_SHORT_NAME_WIKI, pageTwoName);
        this.nodeService.setProperty(pageTwo.getNodeRef(), ContentModel.PROP_OWNER, (Serializable)((Object)"System"));
        this.nodeService.setProperty(pageTwo.getNodeRef(), ContentModel.PROP_CREATOR, (Serializable)((Object)"System"));
        this.nodeService.setProperty(pageTwo.getNodeRef(), ContentModel.PROP_MODIFIER, (Serializable)((Object)"System"));
        pages = this.getPages("recentlyModified", null);
        WikiRestApiTest.assertEquals((int)3, (int)pages.getInt("totalPages"));
        entries = pages.getJSONArray("pages");
        WikiRestApiTest.assertEquals((int)3, (int)entries.length());
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_TWO, (String)entries.getJSONObject(0).getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_THREE, (String)entries.getJSONObject(1).getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)entries.getJSONObject(2).getString("title"));
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.personService.deletePerson(USER_TWO);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        pages = this.getPages("recentlyModified", null);
        WikiRestApiTest.assertEquals((int)3, (int)pages.getInt("totalPages"));
        entries = pages.getJSONArray("pages");
        WikiRestApiTest.assertEquals((int)3, (int)entries.length());
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_TWO, (String)entries.getJSONObject(0).getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_THREE, (String)entries.getJSONObject(1).getString("title"));
        WikiRestApiTest.assertEquals((String)PAGE_TITLE_ONE, (String)entries.getJSONObject(2).getString("title"));
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SiteInfo site = this.siteService.getSite(SITE_SHORT_NAME_WIKI);
        site.setVisibility(SiteVisibility.PRIVATE);
        this.siteService.updateSite(site);
        this.siteService.removeMembership(SITE_SHORT_NAME_WIKI, USER_ONE);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_WIKI_LIST), 404);
    }
}

