/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import org.alfresco.repo.web.scripts.workflow.AbstractWorkflowRestApiTest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class JBPMWorkflowRestApiTest
extends AbstractWorkflowRestApiTest {
    private static final String ADHOC_WORKFLOW_DEFINITION_NAME = "jbpm$wf:adhoc";
    private static final String ADHOC_WORKFLOW_DEFINITION_TITLE = "Adhoc Workflow (JBPM)";
    private static final String ADHOC_WORKFLOW_DEFINITION_DESCRIPTION = "Assign arbitrary task to colleague using JBPM workflow engine";
    private static final String REVIEW_WORKFLOW_DEFINITION_NAME = "jbpm$wf:review";
    private static final String REVIEW_POOLED_WORKFLOW_DEFINITION_NAME = "jbpm$wf:reviewpooled";

    @Override
    protected String getAdhocWorkflowDefinitionName() {
        return ADHOC_WORKFLOW_DEFINITION_NAME;
    }

    @Override
    protected String getAdhocWorkflowDefinitionTitle() {
        return ADHOC_WORKFLOW_DEFINITION_TITLE;
    }

    @Override
    protected String getAdhocWorkflowDefinitionDescription() {
        return ADHOC_WORKFLOW_DEFINITION_DESCRIPTION;
    }

    @Override
    protected String getReviewWorkflowDefinitionName() {
        return REVIEW_WORKFLOW_DEFINITION_NAME;
    }

    @Override
    protected String getReviewPooledWorkflowDefinitionName() {
        return REVIEW_POOLED_WORKFLOW_DEFINITION_NAME;
    }

    @Override
    protected void approveTask(String taskId) throws Exception {
        String transition = "approve";
        this.checkTransitionExists(transition, taskId);
        this.workflowService.endTask(taskId, transition);
    }

    @Override
    protected void rejectTask(String taskId) throws Exception {
        String transition = "reject";
        this.checkTransitionExists(transition, taskId);
        this.workflowService.endTask(taskId, transition);
    }

    private void checkTransitionExists(String transitionName, String taskId) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/task-instances/" + taskId), 200);
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONObject result = json.getJSONObject("data");
        JBPMWorkflowRestApiTest.assertNotNull((Object)result);
        JSONObject definition = result.getJSONObject("definition");
        JBPMWorkflowRestApiTest.assertNotNull((Object)definition);
        JSONObject node = definition.getJSONObject("node");
        JBPMWorkflowRestApiTest.assertNotNull((Object)node);
        JSONArray transitions = node.getJSONArray("transitions");
        JBPMWorkflowRestApiTest.assertNotNull((Object)transitions);
        boolean found = false;
        for (int i = 0; i < transitions.length(); ++i) {
            String name = transitions.getJSONObject(i).getString("id");
            if (!name.equals("approve")) continue;
            found = true;
            break;
        }
        JBPMWorkflowRestApiTest.assertTrue((String)"Transition 'Approve' not found", (boolean)found);
    }

    @Override
    protected String getEngine() {
        return "jbpm";
    }
}

