/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.workflow.WorkflowModelBuilder;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.NamespaceServiceMemoryImpl;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO8601DateFormat;
import org.mockito.Mockito;

public class WorkflowModelBuilderTest
extends TestCase {
    private static final String URI = "http://test";
    private static final String userName = "joeBloggs";
    private static final String firstName = "Joe";
    private static final String lastName = "Bloggs";
    private static final NodeRef person = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "joeBloggs");
    private static final NodeRef workflowPackage = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "workflowPackage");
    private NamespaceService namespaceService;
    private PersonService personService;
    private NodeService nodeService;
    private WorkflowService workflowService;
    private AuthenticationService authenticationService;
    private WorkflowModelBuilder builder;

    public void testBuildWorkflowTask() throws Exception {
        Date date = new Date();
        WorkflowTask task = this.makeTask(date);
        Map<String, Object> model = this.builder.buildSimple(task, null);
        Object id = model.get("id");
        WorkflowModelBuilderTest.assertEquals((Object)task.getId(), (Object)id);
        Object url = model.get("url");
        WorkflowModelBuilderTest.assertEquals((Object)("api/task-instances/" + task.getId()), (Object)url);
        WorkflowModelBuilderTest.assertEquals((Object)task.getName(), (Object)model.get("name"));
        WorkflowModelBuilderTest.assertEquals((Object)task.getTitle(), (Object)model.get("title"));
        WorkflowModelBuilderTest.assertEquals((Object)task.getDescription(), (Object)model.get("description"));
        WorkflowModelBuilderTest.assertEquals((Object)task.getState().name(), (Object)model.get("state"));
        WorkflowModelBuilderTest.assertNull((Object)model.get("outcome"));
        WorkflowModelBuilderTest.assertEquals((Object)false, (Object)model.get("isPooled"));
        WorkflowModelBuilderTest.assertEquals((Object)false, (Object)model.get("isEditable"));
        WorkflowModelBuilderTest.assertEquals((Object)false, (Object)model.get("isReassignable"));
        WorkflowModelBuilderTest.assertEquals((Object)false, (Object)model.get("isClaimable"));
        WorkflowModelBuilderTest.assertEquals((Object)false, (Object)model.get("isReleasable"));
        Map owner = (Map)model.get("owner");
        WorkflowModelBuilderTest.assertEquals((Object)userName, owner.get("userName"));
        WorkflowModelBuilderTest.assertEquals((Object)firstName, owner.get("firstName"));
        WorkflowModelBuilderTest.assertEquals((Object)lastName, owner.get("lastName"));
        Map props = (Map)model.get("properties");
        WorkflowModelBuilderTest.assertEquals((int)task.getProperties().size(), (int)props.size());
        WorkflowModelBuilderTest.assertEquals((Object)5, props.get("test_int"));
        WorkflowModelBuilderTest.assertEquals((Object)false, props.get("test_boolean"));
        WorkflowModelBuilderTest.assertEquals((Object)"foo bar", props.get("test_string"));
        String dateStr = (String)props.get("test_date");
        WorkflowModelBuilderTest.assertEquals((Object)date, (Object)ISO8601DateFormat.parse((String)dateStr));
        Map workflowInstance = (Map)model.get("workflowInstance");
        WorkflowModelBuilderTest.assertNotNull((Object)workflowInstance);
        WorkflowInstance instance = task.getPath().getInstance();
        WorkflowModelBuilderTest.assertEquals((Object)instance.getId(), workflowInstance.get("id"));
        WorkflowModelBuilderTest.assertEquals((Object)instance.isActive(), workflowInstance.get("isActive"));
        String startDateStr = ISO8601DateFormat.format((Date)instance.getStartDate());
        WorkflowModelBuilderTest.assertEquals((Object)startDateStr, workflowInstance.get("startDate"));
        task.getProperties().put(WorkflowModel.ASSOC_POOLED_ACTORS, new ArrayList(0));
        model = this.builder.buildSimple(task, null);
        WorkflowModelBuilderTest.assertEquals((Object)false, (Object)model.get("isPooled"));
        ArrayList<NodeRef> actors = new ArrayList<NodeRef>(1);
        actors.add(person);
        task.getProperties().put(WorkflowModel.ASSOC_POOLED_ACTORS, actors);
        model = this.builder.buildSimple(task, null);
        WorkflowModelBuilderTest.assertEquals((Object)true, (Object)model.get("isPooled"));
        model = this.builder.buildSimple(task, Arrays.asList("test_int", "test_string"));
        owner = (Map)model.get("owner");
        WorkflowModelBuilderTest.assertEquals((Object)userName, owner.get("userName"));
        props = (Map)model.get("properties");
        WorkflowModelBuilderTest.assertEquals((int)2, (int)props.size());
        WorkflowModelBuilderTest.assertEquals((Object)5, props.get("test_int"));
        WorkflowModelBuilderTest.assertEquals((Object)"foo bar", props.get("test_string"));
    }

    public void testBuildWorkflowTaskDetailed() throws Exception {
        Date date = new Date();
        WorkflowTask workflowTask = this.makeTask(date);
        Map<String, Object> model = this.builder.buildDetailed(workflowTask);
        Object id = model.get("id");
        WorkflowModelBuilderTest.assertEquals((Object)workflowTask.getId(), (Object)id);
        Object url = model.get("url");
        WorkflowModelBuilderTest.assertEquals((Object)("api/task-instances/" + workflowTask.getId()), (Object)url);
        WorkflowModelBuilderTest.assertEquals((Object)workflowTask.getName(), (Object)model.get("name"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowTask.getTitle(), (Object)model.get("title"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowTask.getDescription(), (Object)model.get("description"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowTask.getState().name(), (Object)model.get("state"));
        WorkflowModelBuilderTest.assertEquals((Object)false, (Object)model.get("isPooled"));
        Map owner = (Map)model.get("owner");
        WorkflowModelBuilderTest.assertEquals((Object)userName, owner.get("userName"));
        WorkflowModelBuilderTest.assertEquals((Object)firstName, owner.get("firstName"));
        WorkflowModelBuilderTest.assertEquals((Object)lastName, owner.get("lastName"));
        Map props = (Map)model.get("properties");
        WorkflowModelBuilderTest.assertEquals((int)workflowTask.getProperties().size(), (int)props.size());
        Map workflowInstance = (Map)model.get("workflowInstance");
        WorkflowInstance instance = workflowTask.getPath().getInstance();
        WorkflowModelBuilderTest.assertEquals((Object)instance.getId(), workflowInstance.get("id"));
        WorkflowModelBuilderTest.assertEquals((Object)instance.isActive(), workflowInstance.get("isActive"));
        String startDateStr = ISO8601DateFormat.format((Date)instance.getStartDate());
        WorkflowModelBuilderTest.assertEquals((Object)startDateStr, workflowInstance.get("startDate"));
        WorkflowDefinition workflowDef = instance.getDefinition();
        WorkflowModelBuilderTest.assertEquals((Object)workflowDef.getName(), workflowInstance.get("name"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowDef.getTitle(), workflowInstance.get("title"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowDef.getDescription(), workflowInstance.get("description"));
        Map actualDefinition = (Map)model.get("definition");
        WorkflowTaskDefinition taskDef = workflowTask.getDefinition();
        WorkflowModelBuilderTest.assertEquals((Object)taskDef.getId(), actualDefinition.get("id"));
        Map actualType = (Map)actualDefinition.get("type");
        TypeDefinition taskType = taskDef.getMetadata();
        WorkflowModelBuilderTest.assertEquals((Object)taskType.getName(), actualType.get("name"));
        WorkflowModelBuilderTest.assertEquals((Object)taskType.getTitle(), actualType.get("title"));
        WorkflowModelBuilderTest.assertEquals((Object)taskType.getDescription(), actualType.get("description"));
        Map actualNode = (Map)actualDefinition.get("node");
        WorkflowNode taskNode = taskDef.getNode();
        WorkflowModelBuilderTest.assertEquals((Object)taskNode.getName(), actualNode.get("name"));
        WorkflowModelBuilderTest.assertEquals((Object)taskNode.getTitle(), actualNode.get("title"));
        WorkflowModelBuilderTest.assertEquals((Object)taskNode.getDescription(), actualNode.get("description"));
        WorkflowModelBuilderTest.assertEquals((Object)taskNode.isTaskNode(), actualNode.get("isTaskNode"));
        List transitions = (List)actualNode.get("transitions");
        WorkflowTransition[] taskTransitions = taskNode.getTransitions();
        int i = 0;
        for (Map transition : transitions) {
            WorkflowTransition workflowTransition = taskTransitions[i];
            WorkflowModelBuilderTest.assertEquals((Object)workflowTransition.getId(), transition.get("id"));
            WorkflowModelBuilderTest.assertEquals((Object)workflowTransition.getTitle(), transition.get("title"));
            WorkflowModelBuilderTest.assertEquals((Object)workflowTransition.getDescription(), transition.get("description"));
            WorkflowModelBuilderTest.assertEquals((Object)workflowTransition.isDefault(), transition.get("isDefault"));
            WorkflowModelBuilderTest.assertEquals((Object)false, transition.get("isHidden"));
            ++i;
        }
    }

    public void testBuildWorkflowDefinition() throws Exception {
        WorkflowTaskDefinition workflowTaskDefinition = this.makeTaskDefinition();
        WorkflowDefinition workflowDefinition = new WorkflowDefinition("The Id", "The Name", "The Version", "The Title", "The Description", workflowTaskDefinition);
        Map<String, Object> model = this.builder.buildSimple(workflowDefinition);
        WorkflowModelBuilderTest.assertEquals((Object)workflowDefinition.getId(), (Object)model.get("id"));
        WorkflowModelBuilderTest.assertEquals((Object)("api/workflow-definitions/" + workflowDefinition.getId()), (Object)model.get("url"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowDefinition.getName(), (Object)model.get("name"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowDefinition.getTitle(), (Object)model.get("title"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowDefinition.getDescription(), (Object)model.get("description"));
    }

    public void testBuildWorkflowInstance() throws Exception {
        WorkflowInstance workflowInstance = this.makeWorkflowInstance(null);
        Map<String, Object> model = this.builder.buildSimple(workflowInstance);
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.getId(), (Object)model.get("id"));
        WorkflowModelBuilderTest.assertTrue((boolean)model.containsKey("url"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.getDefinition().getName(), (Object)model.get("name"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.getDefinition().getTitle(), (Object)model.get("title"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.getDefinition().getDescription(), (Object)model.get("description"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.getDescription(), (Object)model.get("message"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.isActive(), (Object)model.get("isActive"));
        WorkflowModelBuilderTest.assertEquals((Object)ISO8601DateFormat.format((Date)workflowInstance.getStartDate()), (Object)model.get("startDate"));
        WorkflowModelBuilderTest.assertEquals((Object)ISO8601DateFormat.format((Date)workflowInstance.getEndDate()), (Object)model.get("endDate"));
        Map initiator = (Map)model.get("initiator");
        if (initiator != null) {
            WorkflowModelBuilderTest.assertEquals((Object)userName, initiator.get("userName"));
            WorkflowModelBuilderTest.assertEquals((Object)firstName, initiator.get("firstName"));
            WorkflowModelBuilderTest.assertEquals((Object)lastName, initiator.get("lastName"));
        }
        WorkflowModelBuilderTest.assertTrue((boolean)model.containsKey("definitionUrl"));
    }

    public void testBuildWorkflowInstanceDetailed() throws Exception {
        WorkflowTaskDefinition workflowTaskDefinition = this.makeTaskDefinition();
        QName taskTypeName = WorkflowModel.TYPE_WORKFLOW_TASK;
        Mockito.when((Object)workflowTaskDefinition.getMetadata().getName()).thenReturn((Object)taskTypeName);
        Mockito.when((Object)workflowTaskDefinition.getMetadata().getTitle()).thenReturn((Object)"The Type Title");
        Mockito.when((Object)workflowTaskDefinition.getMetadata().getDescription()).thenReturn((Object)"The Type Description");
        WorkflowInstance workflowInstance = this.makeWorkflowInstance(workflowTaskDefinition);
        Map<String, Object> model = this.builder.buildDetailed(workflowInstance, true);
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.getId(), (Object)model.get("id"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.getDefinition().getName(), (Object)model.get("name"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.getDefinition().getTitle(), (Object)model.get("title"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.getDefinition().getDescription(), (Object)model.get("description"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.isActive(), (Object)model.get("isActive"));
        WorkflowModelBuilderTest.assertEquals((Object)ISO8601DateFormat.format((Date)workflowInstance.getStartDate()), (Object)model.get("startDate"));
        WorkflowModelBuilderTest.assertEquals((Object)ISO8601DateFormat.format((Date)workflowInstance.getEndDate()), (Object)model.get("endDate"));
        Map initiator = (Map)model.get("initiator");
        if (initiator != null) {
            WorkflowModelBuilderTest.assertEquals((Object)userName, initiator.get("userName"));
            WorkflowModelBuilderTest.assertEquals((Object)firstName, initiator.get("firstName"));
            WorkflowModelBuilderTest.assertEquals((Object)lastName, initiator.get("lastName"));
        }
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.getContext().toString(), (Object)model.get("context"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.getWorkflowPackage().toString(), (Object)model.get("package"));
        Map taskInstanceModel = (Map)model.get("definition");
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.getDefinition().getVersion(), taskInstanceModel.get("version"));
        WorkflowModelBuilderTest.assertEquals((Object)workflowInstance.getDefinition().getStartTaskDefinition().getMetadata().getName(), taskInstanceModel.get("startTaskDefinitionType"));
    }

    private WorkflowNode makeNode() {
        String name = "The Node Name";
        String title = "The Node Title";
        String description = "The Node Description";
        String type = "The Node Type";
        boolean isTaskNode = true;
        WorkflowTransition workflowTransition = this.makeTransition();
        return new WorkflowNode(name, title, description, type, isTaskNode, new WorkflowTransition[]{workflowTransition});
    }

    private WorkflowTransition makeTransition() {
        String id = "The Transition Id";
        String title = "The Transition Title";
        String description = "The Transition Description";
        boolean isDefault = true;
        return new WorkflowTransition(id, title, description, isDefault);
    }

    private WorkflowTaskDefinition makeTaskDefinition() {
        String id = "The Definition Id";
        TypeDefinition metadata = this.makeTypeDefinition();
        WorkflowNode node = this.makeNode();
        return new WorkflowTaskDefinition(id, node, metadata);
    }

    private TypeDefinition makeTypeDefinition() {
        TypeDefinition typeDef = (TypeDefinition)Mockito.mock(TypeDefinition.class);
        Mockito.when((Object)typeDef.getName()).thenReturn((Object)QName.createQName((String)URI, (String)"The Type Name"));
        Mockito.when((Object)typeDef.getTitle()).thenReturn((Object)"The Type Title");
        Mockito.when((Object)typeDef.getDescription()).thenReturn((Object)"The Type Description");
        return typeDef;
    }

    private WorkflowPath makePath() {
        String id = "pathId$1";
        Date startDate = new Date();
        WorkflowDefinition definition = new WorkflowDefinition("The Id", "The Name", "1", "The Title", "The Description", null);
        WorkflowInstance instance = new WorkflowInstance("", definition, null, null, null, workflowPackage, true, startDate, null);
        return new WorkflowPath(id, instance, null, true);
    }

    private WorkflowTask makeTask(Date date) {
        String description = "Task Desc";
        String id = "testId$1";
        String name = "Task Name";
        WorkflowTaskState state = WorkflowTaskState.IN_PROGRESS;
        String title = "Task Title";
        WorkflowPath path = this.makePath();
        WorkflowTaskDefinition definition = this.makeTaskDefinition();
        HashMap<QName, Serializable> properties = this.makeTaskProperties(date);
        return new WorkflowTask(id, definition, name, title, description, state, path, properties);
    }

    private WorkflowInstance makeWorkflowInstance(WorkflowTaskDefinition taskDefinition) {
        String id = "The id";
        boolean active = true;
        Date startDate = new Date();
        Date endDate = new Date();
        NodeRef initiator = person;
        WorkflowDefinition definition = new WorkflowDefinition("The Id", "The Name", "The Version", "The Title", "The Description", taskDefinition);
        return new WorkflowInstance(id, definition, "", initiator, workflowPackage, workflowPackage, active, startDate, endDate);
    }

    private HashMap<QName, Serializable> makeTaskProperties(Date date) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_OWNER, (Serializable)((Object)userName));
        QName testInt = QName.createQName((String)URI, (String)"int");
        properties.put(testInt, Integer.valueOf(5));
        QName testBoolean = QName.createQName((String)URI, (String)"boolean");
        properties.put(testBoolean, Boolean.valueOf(false));
        QName testString = QName.createQName((String)URI, (String)"string");
        properties.put(testString, (Serializable)((Object)"foo bar"));
        QName testDate = QName.createQName((String)URI, (String)"date");
        properties.put(testDate, date);
        return properties;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.namespaceService = new NamespaceServiceMemoryImpl();
        this.namespaceService.registerNamespace("test", URI);
        this.namespaceService.registerNamespace("cm", "http://www.alfresco.org/model/content/1.0");
        this.namespaceService.registerNamespace("bpm", "http://www.alfresco.org/model/bpm/1.0");
        this.personService = (PersonService)Mockito.mock(PersonService.class);
        Mockito.when((Object)this.personService.getPerson(userName)).thenReturn((Object)person);
        Mockito.when((Object)this.personService.personExists(userName)).thenReturn((Object)true);
        this.nodeService = (NodeService)Mockito.mock(NodeService.class);
        HashMap<QName, String> personProps = new HashMap<QName, String>();
        personProps.put(ContentModel.PROP_USERNAME, userName);
        personProps.put(ContentModel.PROP_FIRSTNAME, firstName);
        personProps.put(ContentModel.PROP_LASTNAME, lastName);
        Mockito.when((Object)this.nodeService.getProperties(person)).thenReturn(personProps);
        Mockito.when((Object)this.nodeService.getProperty(person, ContentModel.PROP_USERNAME)).thenReturn((Object)userName);
        Mockito.when((Object)this.nodeService.getProperty(person, ContentModel.PROP_FIRSTNAME)).thenReturn((Object)firstName);
        Mockito.when((Object)this.nodeService.getProperty(person, ContentModel.PROP_LASTNAME)).thenReturn((Object)lastName);
        this.workflowService = (WorkflowService)Mockito.mock(WorkflowService.class);
        this.authenticationService = (AuthenticationService)Mockito.mock(AuthenticationService.class);
        this.builder = new WorkflowModelBuilder(this.namespaceService, this.nodeService, this.authenticationService, this.personService, this.workflowService);
    }
}

