/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.util;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpRangeProcessor {
    private static final Log logger = LogFactory.getLog(HttpRangeProcessor.class);
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_CONTENT_RANGE = "Content-Range";
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final String MULTIPART_BYTERANGES_BOUNDRY = "<ALF4558907921887235966L>";
    private static final String MULTIPART_BYTERANGES_HEADER = "multipart/byteranges; boundary=<ALF4558907921887235966L>";
    private static final String MULTIPART_BYTERANGES_BOUNDRY_SEP = "--<ALF4558907921887235966L>";
    private static final String MULTIPART_BYTERANGES_BOUNDRY_END = "--<ALF4558907921887235966L>--";
    private static final int CHUNKSIZE = 65536;
    private ContentService contentService;

    public HttpRangeProcessor(ContentService contentService) {
        this.contentService = contentService;
    }

    public boolean processRange(HttpServletResponse res, ContentReader reader, String range, NodeRef ref, QName property, String mimetype, String userAgent) throws IOException {
        if (range.indexOf(44) == -1) {
            return this.processSingleRange(res, reader, range, mimetype);
        }
        return this.processMultiRange(res, range, ref, property, mimetype, userAgent);
    }

    private boolean processSingleRange(HttpServletResponse res, ContentReader reader, String range, String mimetype) throws IOException {
        boolean processedRange = false;
        Range r = null;
        try {
            r = Range.constructRange(range, mimetype, reader.getSize());
        }
        catch (IllegalArgumentException err) {
            if (HttpRangeProcessor.getLogger().isDebugEnabled()) {
                HttpRangeProcessor.getLogger().debug((Object)("Failed to parse range header - returning 416 status code: " + err.getMessage()));
            }
            res.setStatus(416);
            res.setHeader(HEADER_CONTENT_RANGE, "\"*\"");
            res.getOutputStream().close();
            return true;
        }
        res.setStatus(206);
        res.setContentType(mimetype);
        String contentRange = "bytes " + Long.toString(r.start) + "-" + Long.toString(r.end) + "/" + Long.toString(reader.getSize());
        res.setHeader(HEADER_CONTENT_RANGE, contentRange);
        res.setHeader(HEADER_CONTENT_LENGTH, Long.toString(r.end - r.start + 1L));
        if (HttpRangeProcessor.getLogger().isDebugEnabled()) {
            HttpRangeProcessor.getLogger().debug((Object)("Processing: Content-Range: " + contentRange));
        }
        InputStream is = null;
        try {
            ServletOutputStream os = res.getOutputStream();
            is = reader.getContentInputStream();
            this.streamRangeBytes(r, is, os, 0L);
            os.close();
            processedRange = true;
        }
        catch (IOException err) {
            if (HttpRangeProcessor.getLogger().isDebugEnabled()) {
                HttpRangeProcessor.getLogger().debug((Object)("Unable to process single range due to IO Exception: " + err.getMessage()));
            }
            throw err;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return processedRange;
    }

    /*
     * Exception decompiling
     */
    private boolean processMultiRange(HttpServletResponse res, String range, NodeRef ref, QName property, String mimetype, String userAgent) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void streamRangeBytes(Range r, InputStream is, ServletOutputStream os, long offset) throws IOException {
        long span;
        long skipped;
        Log logger = HttpRangeProcessor.getLogger();
        boolean trace = logger.isTraceEnabled();
        if (r.start != 0L && r.start > offset && (skipped = offset + is.skip(r.start - offset)) < r.start) {
            return;
        }
        long bytesLeft = span = r.end - r.start + 1L;
        int read = 0;
        byte[] buf = new byte[(int)bytesLeft < 65536 ? (int)bytesLeft : 65536];
        while ((read = is.read(buf)) > 0 && bytesLeft != 0L) {
            os.write(buf, 0, read);
            if ((bytesLeft -= (long)read) != 0L) {
                int resize;
                int n = resize = (int)bytesLeft < 65536 ? (int)bytesLeft : 65536;
                if (resize != buf.length) {
                    buf = new byte[resize];
                }
            }
            if (!trace) continue;
            logger.trace((Object)("...wrote " + read + " bytes, with " + bytesLeft + " to go..."));
        }
    }

    private static Log getLogger() {
        return logger;
    }

    private static class Range
    implements Comparable<Range> {
        private long start;
        private long end;
        private long entityLength;
        private String contentType;
        private String contentRange;

        Range(String contentType, long start, long end, long entityLength) {
            this.contentType = "Content-Type: " + contentType;
            this.start = start;
            this.end = end;
            this.entityLength = entityLength;
        }

        static Range constructRange(String range, String contentType, long entityLength) {
            int separator;
            if (range == null) {
                throw new IllegalArgumentException("Range argument is mandatory");
            }
            if (range.indexOf(47) != -1) {
                range = range.substring(0, range.indexOf(47));
            }
            if ((separator = range.indexOf(45)) == -1) {
                throw new IllegalArgumentException("Invalid range: " + range);
            }
            try {
                long start = 0L;
                if (separator != 0) {
                    start = Long.parseLong(range.substring(0, separator));
                }
                long end = entityLength - 1L;
                if (separator != range.length() - 1) {
                    end = Long.parseLong(range.substring(separator + 1));
                }
                return new Range(contentType, start, end, entityLength);
            }
            catch (NumberFormatException err) {
                throw new IllegalArgumentException("Unable to parse range value: " + range);
            }
        }

        void outputHeader(ServletOutputStream os) throws IOException {
            os.println(HttpRangeProcessor.MULTIPART_BYTERANGES_BOUNDRY_SEP);
            os.println(this.contentType);
            os.println(this.getContentRange());
            os.println();
        }

        int getLength() {
            return HttpRangeProcessor.MULTIPART_BYTERANGES_BOUNDRY_SEP.length() + 2 + this.contentType.length() + 2 + this.getContentRange().length() + 4 + (int)(this.end - this.start + 1L) + 2;
        }

        private String getContentRange() {
            if (this.contentRange == null) {
                this.contentRange = "Content-Range: bytes " + Long.toString(this.start) + "-" + Long.toString(this.end) + "/" + Long.toString(this.entityLength);
            }
            return this.contentRange;
        }

        public String toString() {
            return this.start + "-" + this.end;
        }

        @Override
        public int compareTo(Range o) {
            return this.start > o.start ? 1 : -1;
        }

        static /* synthetic */ long access$102(Range x0, long x1) {
            x0.end = x1;
            return x0.end;
        }

        static /* synthetic */ String access$200(Range x0) {
            return x0.getContentRange();
        }
    }
}

