/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.webdav.ActivityPoster;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.Pair;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityPosterImpl
implements ActivityPoster {
    private static final String FILE_ADDED = "org.alfresco.documentlibrary.file-added";
    private static final String FILE_UPDATED = "org.alfresco.documentlibrary.file-updated";
    private static final String FILE_DELETED = "org.alfresco.documentlibrary.file-deleted";
    private String appTool;
    private ActivityService activityService;
    private NodeService nodeService;
    private PersonService personService;

    public ActivityPosterImpl() {
    }

    public ActivityPosterImpl(String appTool, ActivityService activityService, NodeService nodeService, PersonService personService) {
        this.appTool = appTool;
        this.activityService = activityService;
        this.nodeService = nodeService;
        this.personService = personService;
    }

    @Override
    public void postFileAdded(String siteId, String tenantDomain, FileInfo contentNodeInfo) throws WebDAVServerException {
        this.postFileActivity(FILE_ADDED, siteId, tenantDomain, null, contentNodeInfo);
    }

    @Override
    public void postFileUpdated(String siteId, String tenantDomain, FileInfo contentNodeInfo) throws WebDAVServerException {
        this.postFileActivity(FILE_UPDATED, siteId, tenantDomain, null, contentNodeInfo);
    }

    @Override
    public void postFileDeleted(String siteId, String tenantDomain, String parentPath, FileInfo contentNodeInfo) throws WebDAVServerException {
        this.postFileActivity(FILE_DELETED, siteId, tenantDomain, parentPath, contentNodeInfo);
    }

    private void postFileActivity(String activityType, String siteId, String tenantDomain, String parentPath, FileInfo contentNodeInfo) throws WebDAVServerException {
        Pair<String, String> personName = this.getPersonName();
        String firstName = (String)personName.getFirst();
        String lastName = (String)personName.getSecond();
        String fileName = contentNodeInfo.getName();
        NodeRef nodeRef = contentNodeInfo.getNodeRef();
        JSONObject json = this.createActivityJSON(tenantDomain, parentPath, nodeRef, firstName, lastName, fileName);
        this.activityService.postActivity(activityType, siteId, this.appTool, json.toString());
    }

    private JSONObject createActivityJSON(String tenantDomain, String parentPath, NodeRef nodeRef, String firstName, String lastName, String fileName) throws WebDAVServerException {
        JSONObject json = new JSONObject();
        try {
            json.put("nodeRef", (Object)nodeRef);
            if (parentPath != null) {
                json.put("page", (Object)("documentlibrary?path=" + parentPath));
            } else {
                json.put("page", (Object)("document-details?nodeRef=" + nodeRef));
            }
            json.put("title", (Object)fileName);
            json.put("firstName", (Object)firstName);
            json.put("lastName", (Object)lastName);
            if (!tenantDomain.equals("")) {
                json.put("tenantDomain", (Object)tenantDomain);
            }
        }
        catch (JSONException error) {
            throw new WebDAVServerException(500);
        }
        return json;
    }

    private Pair<String, String> getPersonName() {
        String firstName = "";
        String lastName = "";
        String userName = AuthenticationUtil.getFullyAuthenticatedUser();
        NodeRef person = this.personService.getPerson(userName);
        if (person != null) {
            firstName = (String)((Object)this.nodeService.getProperty(person, ContentModel.PROP_FIRSTNAME));
            lastName = (String)((Object)this.nodeService.getProperty(person, ContentModel.PROP_LASTNAME));
        }
        return new Pair((Object)firstName, (Object)lastName);
    }

    public void setAppTool(String appTool) {
        this.appTool = appTool;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

