/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.webdav.ActivityPostProducer;
import org.alfresco.repo.webdav.ActivityPoster;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.webdav.WebDavService;

public class DeleteMethod
extends WebDAVMethod
implements ActivityPostProducer {
    private ActivityPoster activityPoster;

    @Override
    protected void parseRequestHeaders() throws WebDAVServerException {
        this.parseIfHeader();
    }

    @Override
    protected void parseRequestBody() throws WebDAVServerException {
    }

    @Override
    protected void executeImpl() throws WebDAVServerException, Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WebDAV DELETE: " + this.getPath()));
        }
        FileFolderService fileFolderService = this.getFileFolderService();
        NodeRef rootNodeRef = this.getRootNodeRef();
        String path = this.getPath();
        List<String> pathElements = this.getDAVHelper().splitAllPaths(path);
        FileInfo fileInfo = null;
        try {
            fileInfo = fileFolderService.resolveNamePath(rootNodeRef, pathElements);
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Node not found: " + this.getPath()));
            }
            throw new WebDAVServerException(404);
        }
        this.checkNode(fileInfo);
        if (!this.getNodeService().hasAspect(fileInfo.getNodeRef(), ContentModel.ASPECT_WORKING_COPY)) {
            String siteId = this.getSiteId();
            NodeRef deletedNodeRef = fileInfo.getNodeRef();
            FileInfo parentFile = this.getDAVHelper().getParentNodeForPath(this.getRootNodeRef(), this.getPath(), this.getServletPath());
            boolean hidden = this.getNodeService().hasAspect(deletedNodeRef, ContentModel.ASPECT_HIDDEN);
            fileFolderService.delete(deletedNodeRef);
            if (!hidden) {
                this.postActivity(parentFile, fileInfo, siteId);
            }
        }
    }

    protected void postActivity(FileInfo parent, FileInfo deletedFile, String siteId) throws WebDAVServerException {
        WebDavService davService = this.getDAVHelper().getServiceRegistry().getWebDavService();
        if (!davService.activitiesEnabled()) {
            return;
        }
        String tenantDomain = this.getTenantDomain();
        if (!siteId.equals("")) {
            String parentPath;
            block4: {
                SiteService siteService = this.getServiceRegistry().getSiteService();
                NodeRef documentLibrary = siteService.getContainer(siteId, "documentLibrary");
                parentPath = "/";
                try {
                    parentPath = this.getDAVHelper().getPathFromNode(documentLibrary, parent.getNodeRef());
                }
                catch (FileNotFoundException error) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"No documentLibrary container found.");
                }
            }
            this.activityPoster.postFileDeleted(siteId, tenantDomain, parentPath, deletedFile);
        }
    }

    @Override
    public void setActivityPoster(ActivityPoster activityPoster) {
        this.activityPoster = activityPoster;
    }
}

