/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.web.util.HttpRangeProcessor;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConverter;
import org.springframework.extensions.surf.util.I18NUtil;

public class GetMethod
extends WebDAVMethod {
    private static final String RANGE_HEADER_UNIT_SPECIFIER = "bytes=";
    private ArrayList<String> ifMatchTags = null;
    private ArrayList<String> ifNoneMatchTags = null;
    private Date m_ifModifiedSince = null;
    private Date m_ifUnModifiedSince = null;
    protected boolean m_returnContent = true;
    private String byteRanges;

    @Override
    protected void parseRequestHeaders() throws WebDAVServerException {
        String strIfUnModifiedSince;
        String strIfNoneMatch;
        String strIfMatch;
        String strRange = this.m_request.getHeader("Range");
        if (strRange != null && strRange.length() > 0) {
            this.byteRanges = strRange;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Range header supplied: " + this.byteRanges));
            }
        }
        if ((strIfMatch = this.m_request.getHeader("If-Match")) != null && strIfMatch.length() > 0) {
            this.ifMatchTags = this.parseETags(strIfMatch);
        }
        if ((strIfNoneMatch = this.m_request.getHeader("If-None-Match")) != null && strIfNoneMatch.length() > 0) {
            this.ifNoneMatchTags = this.parseETags(strIfNoneMatch);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        String strIfModifiedSince = this.m_request.getHeader("If-Modified-Since");
        if (strIfModifiedSince != null && strIfModifiedSince.length() > 0) {
            try {
                this.m_ifModifiedSince = dateFormat.parse(strIfModifiedSince);
            }
            catch (ParseException e) {
                logger.warn((Object)("Failed to parse If-Modified-Since date of " + strIfModifiedSince));
            }
        }
        if ((strIfUnModifiedSince = this.m_request.getHeader("If-Unmodified-Since")) != null && strIfUnModifiedSince.length() > 0) {
            try {
                this.m_ifUnModifiedSince = dateFormat.parse(strIfUnModifiedSince);
            }
            catch (ParseException e) {
                logger.warn((Object)("Failed to parse If-Unmodified-Since date of " + strIfUnModifiedSince));
            }
        }
    }

    @Override
    protected void parseRequestBody() throws WebDAVServerException {
    }

    @Override
    protected boolean isReadOnly() {
        return true;
    }

    @Override
    protected void executeImpl() throws WebDAVServerException, Exception {
        FileFolderService fileFolderService = this.getFileFolderService();
        NodeRef rootNodeRef = this.getRootNodeRef();
        String path = this.getPath();
        String servletPath = this.getServletPath();
        FileInfo nodeInfo = null;
        try {
            nodeInfo = this.getDAVHelper().getNodeForPath(rootNodeRef, path, servletPath);
        }
        catch (FileNotFoundException e) {
            throw new WebDAVServerException(404);
        }
        FileInfo realNodeInfo = nodeInfo;
        if (realNodeInfo.isLink()) {
            String rootURL;
            Path pathToNode = this.getNodeService().getPath(nodeInfo.getLinkNodeRef());
            if (pathToNode.size() > 2) {
                pathToNode = pathToNode.subPath(2, pathToNode.size() - 1);
            }
            if (!(rootURL = this.getDAVHelper().getURLForPath(this.m_request, pathToNode.toDisplayPath(this.getNodeService(), this.getPermissionService()), true)).endsWith("/")) {
                rootURL = rootURL + "/";
            }
            String fname = (String)((Object)this.getNodeService().getProperty(nodeInfo.getLinkNodeRef(), ContentModel.PROP_NAME));
            StringBuilder urlStr = new StringBuilder(200);
            urlStr.append("[InternetShortcut]\r\n");
            urlStr.append("URL=file://");
            urlStr.append(this.m_request.getServerName());
            int port = this.m_request.getServerPort();
            if (port != 80) {
                urlStr.append(":").append(port);
            }
            urlStr.append(rootURL).append(WebDAVHelper.encodeURL(fname, this.m_userAgent));
            urlStr.append("\r\n");
            this.m_response.setHeader("Content-Type", "text/plain; charset=ISO-8859-1");
            this.m_response.setHeader("Content-Length", String.valueOf(urlStr.length()));
            this.m_response.getWriter().write(urlStr.toString());
        } else if (realNodeInfo.isFolder()) {
            if (!this.m_returnContent) {
                return;
            }
            this.m_response.setContentType("text/html;charset=UTF-8");
            this.generateDirectoryListing(nodeInfo);
        } else {
            this.checkPreConditions(realNodeInfo);
            this.m_response.setHeader("ETag", this.getDAVHelper().makeQuotedETag(nodeInfo));
            Date modifiedDate = realNodeInfo.getModifiedDate();
            if (modifiedDate != null) {
                long modDate = DefaultTypeConverter.INSTANCE.longValue((Object)modifiedDate);
                this.m_response.setHeader("Last-Modified", WebDAV.formatHeaderDate(modDate));
            }
            ContentReader reader = fileFolderService.getReader(realNodeInfo.getNodeRef());
            reader = FileContentReader.getSafeContentReader((ContentReader)reader, (String)I18NUtil.getMessage((String)"content.content_missing"), (Object[])new Object[]{realNodeInfo.getNodeRef(), reader});
            if (this.byteRanges != null && this.byteRanges.startsWith(RANGE_HEADER_UNIT_SPECIFIER)) {
                HttpRangeProcessor rangeProcessor = new HttpRangeProcessor(this.getContentService());
                String userAgent = this.m_request.getHeader("User-Agent");
                if (this.m_returnContent) {
                    rangeProcessor.processRange(this.m_response, reader, this.byteRanges.substring(6), realNodeInfo.getNodeRef(), ContentModel.PROP_CONTENT, reader.getMimetype(), userAgent);
                }
            } else {
                this.m_response.setHeader("Content-Length", Long.toString(reader.getSize()));
                this.m_response.setHeader("Content-Type", reader.getMimetype());
                if (this.m_returnContent) {
                    reader.getContent((OutputStream)this.m_response.getOutputStream());
                }
            }
        }
    }

    private void checkPreConditions(FileInfo nodeInfo) throws WebDAVServerException {
        long unModifiedSince;
        long fileLastModified;
        Date lastModifiedDate;
        String strETag = this.getDAVHelper().makeQuotedETag(nodeInfo);
        TypeConverter typeConv = DefaultTypeConverter.INSTANCE;
        if (this.ifMatchTags != null && !this.ifMatchTags.contains("*") && !this.ifMatchTags.contains(strETag)) {
            throw new WebDAVServerException(412);
        }
        if (this.ifNoneMatchTags != null && (this.ifNoneMatchTags.contains("*") || this.ifNoneMatchTags.contains(strETag))) {
            throw new WebDAVServerException(304);
        }
        if (this.m_ifModifiedSince != null && this.ifNoneMatchTags == null) {
            lastModifiedDate = nodeInfo.getModifiedDate();
            fileLastModified = lastModifiedDate != null ? typeConv.longValue((Object)lastModifiedDate) : 0L;
            long modifiedSince = this.m_ifModifiedSince.getTime();
            if (fileLastModified != 0L && fileLastModified <= modifiedSince) {
                throw new WebDAVServerException(304);
            }
        }
        if (this.m_ifUnModifiedSince != null && (fileLastModified = (lastModifiedDate = nodeInfo.getModifiedDate()) != null ? typeConv.longValue((Object)lastModifiedDate) : 0L) >= (unModifiedSince = this.m_ifUnModifiedSince.getTime())) {
            throw new WebDAVServerException(412);
        }
    }

    private ArrayList<String> parseETags(String strETagHeader) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(strETagHeader, ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken().trim());
        }
        return list;
    }

    private void generateDirectoryListing(FileInfo fileInfo) {
        block23: {
            FileFolderService fileFolderService = this.getFileFolderService();
            MimetypeService mimeTypeService = this.getMimetypeService();
            PrintWriter writer = null;
            try {
                writer = this.m_response.getWriter();
                boolean wasLink = false;
                if (fileInfo.isLink()) {
                    fileInfo = this.getFileFolderService().getFileInfo(fileInfo.getLinkNodeRef());
                    wasLink = true;
                }
                List childNodeInfos = fileFolderService.list(fileInfo.getNodeRef());
                ((Writer)writer).write("<html><head><title>");
                ((Writer)writer).write(WebDAVHelper.encodeHTML(I18NUtil.getMessage((String)"webdav.repository_title")));
                ((Writer)writer).write("</title>");
                ((Writer)writer).write("<style>");
                ((Writer)writer).write("body { font-family: Arial, Helvetica; font-size: 12pt; background-color: white; }\n");
                ((Writer)writer).write("table { font-family: Arial, Helvetica; font-size: 12pt; background-color: white; }\n");
                ((Writer)writer).write(".listingTable { border: solid black 1px; }\n");
                ((Writer)writer).write(".textCommand { font-family: verdana; font-size: 10pt; }\n");
                ((Writer)writer).write(".textLocation { font-family: verdana; font-size: 11pt; font-weight: bold; color: #2a568f; }\n");
                ((Writer)writer).write(".textData { font-family: verdana; font-size: 10pt; }\n");
                ((Writer)writer).write(".tableHeading { font-family: verdana; font-size: 10pt; font-weight: bold; color: white; background-color: #2a568f; }\n");
                ((Writer)writer).write(".rowOdd { background-color: #eeeeee; }\n");
                ((Writer)writer).write(".rowEven { background-color: #dddddd; }\n");
                ((Writer)writer).write("</style></head>\n");
                ((Writer)writer).flush();
                ((Writer)writer).write("<body>\n");
                ((Writer)writer).write("<table cellspacing='2' cellpadding='3' border='0' width='100%'>\n");
                ((Writer)writer).write("<tr><td colspan='4' class='textLocation'>");
                ((Writer)writer).write(WebDAVHelper.encodeHTML(I18NUtil.getMessage((String)"webdav.directory_listing")));
                ((Writer)writer).write(32);
                ((Writer)writer).write(WebDAVHelper.encodeHTML(this.getPath()));
                ((Writer)writer).write("</td></tr>\n");
                ((Writer)writer).write("<tr><td height='10' colspan='4'></td></tr></table>");
                ((Writer)writer).write("<table cellspacing='2' cellpadding='3' border='0' width='100%' class='listingTable'>\n");
                ((Writer)writer).write("<tr><td class='tableHeading' width='*'>");
                ((Writer)writer).write(WebDAVHelper.encodeHTML(I18NUtil.getMessage((String)"webdav.column.name")));
                ((Writer)writer).write("</td>");
                ((Writer)writer).write("<td class='tableHeading' width='10%'>");
                ((Writer)writer).write(WebDAVHelper.encodeHTML(I18NUtil.getMessage((String)"webdav.column.size")));
                ((Writer)writer).write("</td>");
                ((Writer)writer).write("<td class='tableHeading' width='20%'>");
                ((Writer)writer).write(WebDAVHelper.encodeHTML(I18NUtil.getMessage((String)"webdav.column.type")));
                ((Writer)writer).write("</td>");
                ((Writer)writer).write("<td class='tableHeading' width='25%'>");
                ((Writer)writer).write(WebDAVHelper.encodeHTML(I18NUtil.getMessage((String)"webdav.column.modifieddate")));
                ((Writer)writer).write("</td>");
                ((Writer)writer).write("</tr>\n");
                String rootURL = this.getURLForPath(this.m_request, this.getPath(), true);
                if (!rootURL.endsWith("/")) {
                    rootURL = rootURL + "/";
                }
                if (wasLink) {
                    Path pathToNode = this.getNodeService().getPath(fileInfo.getNodeRef());
                    if (pathToNode.size() > 2) {
                        pathToNode = pathToNode.subPath(2, pathToNode.size() - 1);
                    }
                    if (!(rootURL = this.getURLForPath(this.m_request, pathToNode.toDisplayPath(this.getNodeService(), this.getPermissionService()), true)).endsWith("/")) {
                        rootURL = rootURL + "/";
                    }
                    rootURL = rootURL + WebDAVHelper.encodeURL(fileInfo.getName(), this.m_userAgent) + "/";
                }
                if (!fileInfo.getNodeRef().equals((Object)this.getRootNodeRef())) {
                    ((Writer)writer).write("<tr class='rowOdd'>");
                    ((Writer)writer).write("<td colspan='4' class='textData'><a href=\"");
                    String parentFolderUrl = this.parentFolder(rootURL);
                    ((Writer)writer).write(parentFolderUrl);
                    ((Writer)writer).write("\">");
                    ((Writer)writer).write("[");
                    ((Writer)writer).write(WebDAVHelper.encodeHTML(I18NUtil.getMessage((String)"webdav.column.navigate_up")));
                    ((Writer)writer).write("]</a>");
                    ((Writer)writer).write("</tr>\n");
                }
                ((Writer)writer).flush();
                int rowId = 0;
                for (FileInfo childNodeInfo : childNodeInfos) {
                    ContentReader reader;
                    ((Writer)writer).write("<tr class='");
                    if ((rowId++ & 1) == 1) {
                        ((Writer)writer).write("rowOdd");
                    } else {
                        ((Writer)writer).write("rowEven");
                    }
                    ((Writer)writer).write("'><td class='textData'><a href=\"");
                    ((Writer)writer).write(rootURL);
                    String fname = childNodeInfo.getName();
                    ((Writer)writer).write(WebDAVHelper.encodeURL(fname, this.m_userAgent));
                    ((Writer)writer).write("\">");
                    ((Writer)writer).write(WebDAVHelper.encodeHTML(fname));
                    ((Writer)writer).write("</a>");
                    ((Writer)writer).write("</td><td class='textData'>");
                    if (childNodeInfo.isFolder()) {
                        ((Writer)writer).write("&nbsp;");
                    } else {
                        reader = fileFolderService.getReader(childNodeInfo.getNodeRef());
                        long fsize = 0L;
                        if (reader != null) {
                            fsize = reader.getSize();
                        }
                        ((Writer)writer).write(this.formatSize(Long.toString(fsize)));
                    }
                    ((Writer)writer).write("</td><td class='textData'>");
                    if (childNodeInfo.isFolder()) {
                        ((Writer)writer).write("&nbsp;");
                    } else {
                        reader = fileFolderService.getReader(childNodeInfo.getNodeRef());
                        String mimetype = "&nbsp;";
                        if (reader != null) {
                            mimetype = reader.getMimetype();
                            String displayType = (String)mimeTypeService.getDisplaysByMimetype().get(reader.getMimetype());
                            if (displayType != null) {
                                mimetype = displayType;
                            }
                            if (mimetype == null) {
                                mimetype = reader.getMimetype();
                            }
                        }
                        ((Writer)writer).write(mimetype);
                    }
                    ((Writer)writer).write("</td><td class='textData'>");
                    Date modifiedDate = childNodeInfo.getModifiedDate();
                    if (modifiedDate != null) {
                        ((Writer)writer).write(WebDAV.formatHeaderDate(DefaultTypeConverter.INSTANCE.longValue((Object)modifiedDate)));
                    } else {
                        ((Writer)writer).write("&nbsp;");
                    }
                    ((Writer)writer).write("</td></tr>\n");
                    if ((rowId & 0xF) != 0) continue;
                    ((Writer)writer).flush();
                }
                ((Writer)writer).write("</table></body></html>");
            }
            catch (Throwable e) {
                logger.error((Object)e);
                if (writer == null) break block23;
                try {
                    ((Writer)writer).write("</table><table><tr><td style='color:red'>");
                    ((Writer)writer).write(WebDAVHelper.encodeHTML(I18NUtil.getMessage((String)"webdav.err.dir")));
                    ((Writer)writer).write("</td></tr></table></body></html>");
                    ((Writer)writer).flush();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    private String parentFolder(String path) {
        String[] paths;
        String parent;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((parent = (paths = this.getDAVHelper().splitPath(path))[0]).equals("")) {
            parent = "/";
        }
        return parent;
    }

    private String formatSize(String strSize) {
        String strFormattedSize = strSize;
        int length = strSize.length();
        if (length < 4) {
            strFormattedSize = strSize + ' ' + WebDAVHelper.encodeHTML(I18NUtil.getMessage((String)"webdav.size.bytes"));
        } else if (length >= 4 && length < 7) {
            String strLeft = strSize.substring(0, length - 3);
            String strRight = strSize.substring(length - 3, length - 2);
            StringBuilder buffer = new StringBuilder(strLeft);
            if (!strRight.equals("0")) {
                buffer.append('.');
                buffer.append(strRight);
            }
            buffer.append(' ').append(WebDAVHelper.encodeHTML(I18NUtil.getMessage((String)"webdav.size.kilobytes")));
            strFormattedSize = buffer.toString();
        } else {
            String strLeft = strSize.substring(0, length - 6);
            String strRight = strSize.substring(length - 6, length - 5);
            StringBuilder buffer = new StringBuilder(strLeft);
            if (!strRight.equals("0")) {
                buffer.append('.');
                buffer.append(strRight);
            }
            buffer.append(' ').append(WebDAVHelper.encodeHTML(I18NUtil.getMessage((String)"webdav.size.megabytes")));
            strFormattedSize = buffer.toString();
        }
        return strFormattedSize;
    }
}

