/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.webdav.LockInfo;

public class LockInfoImpl
implements Serializable,
LockInfo {
    private static final long serialVersionUID = 1L;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private String exclusiveLockToken = null;
    private String scope = null;
    private String depth = null;
    private final Set<String> sharedLockTokens = new HashSet<String>(3);
    private String owner;
    private Date expires;

    public LockInfoImpl() {
    }

    public LockInfoImpl(String token, String scope, String depth) {
        this.exclusiveLockToken = token;
        this.scope = scope;
        this.depth = depth;
    }

    public ReentrantReadWriteLock getRWLock() {
        return this.rwLock;
    }

    public boolean isLocked() {
        return this.isExclusive() || this.isShared();
    }

    public void setExclusiveLockToken(String token) {
        this.exclusiveLockToken = token;
    }

    public String getExclusiveLockToken() {
        this.checkLockState();
        return this.exclusiveLockToken;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope == null ? "exclusive" : this.scope;
    }

    public void setDepth(String depth) {
        this.depth = depth;
    }

    public String getDepth() {
        return this.depth;
    }

    public Set<String> getSharedLockTokens() {
        this.checkLockState();
        return this.sharedLockTokens;
    }

    public void setSharedLockTokens(Set<String> sharedLockTokens) {
        this.sharedLockTokens.clear();
        this.sharedLockTokens.addAll(sharedLockTokens);
    }

    public void addSharedLockToken(String token) {
        this.sharedLockTokens.add(token);
    }

    public boolean isShared() {
        return !this.sharedLockTokens.isEmpty();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("LockInfo[");
        str.append("exclusiveLockToken=");
        str.append(this.getExclusiveLockToken());
        str.append(", scope=");
        str.append(this.getScope());
        str.append(", depth=");
        str.append(this.getDepth());
        str.append(", sharedLockTokens=");
        str.append(this.getSharedLockTokens());
        str.append(", owner=");
        str.append(this.owner);
        str.append(", expires=");
        str.append(this.expires);
        str.append("]");
        return str.toString();
    }

    public boolean isExpired() {
        if (this.expires == null) {
            return false;
        }
        Date now = this.dateNow();
        return now.after(this.expires);
    }

    public boolean isExclusive() {
        return this.exclusiveLockToken != null && this.exclusiveLockToken.length() > 0;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public Date getExpires() {
        return this.expires;
    }

    public long getRemainingTimeoutSeconds() {
        Date expires = this.getExpires();
        if (expires == null) {
            return -1L;
        }
        Date now = this.dateNow();
        long timeout = (expires.getTime() - now.getTime()) / 1000L;
        return timeout;
    }

    private void checkLockState() {
        if (this.isShared() && this.isExclusive()) {
            throw new IllegalStateException("Lock cannot be both shared and exclusive: " + this.toString());
        }
    }

    public void setTimeoutSeconds(int lockTimeoutSecs) {
        if (lockTimeoutSecs == -1) {
            this.setExpires(null);
        } else {
            int timeoutMillis = lockTimeoutSecs * 1000;
            Date now = this.dateNow();
            Date nextExpiry = new Date(now.getTime() + (long)timeoutMillis);
            this.setExpires(nextExpiry);
        }
    }

    public void setTimeoutMinutes(int lockTimeoutMins) {
        if (lockTimeoutMins != -1) {
            this.setTimeoutSeconds(lockTimeoutMins * 60);
        } else {
            this.setTimeoutSeconds(-1);
        }
    }

    protected Date dateNow() {
        return new Date();
    }
}

