/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.Date;
import org.alfresco.repo.webdav.LockInfoImpl;
import org.junit.Assert;
import org.junit.Test;

public class LockInfoImplTest {
    @Test
    public void canSetTimeoutSeconds() {
        LockInfoImplEx lockInfo = new LockInfoImplEx();
        lockInfo.setTimeoutSeconds(7);
        Assert.assertEquals((long)86407000L, (long)lockInfo.getExpires().getTime());
    }

    @Test
    public void canSetTimeoutSecondsToInfinity() {
        LockInfoImplEx lockInfo = new LockInfoImplEx();
        lockInfo.setTimeoutSeconds(-1);
        Assert.assertNull((Object)lockInfo.getExpires());
    }

    @Test
    public void canSetTimeoutMinutes() {
        LockInfoImplEx lockInfo = new LockInfoImplEx();
        lockInfo.setTimeoutMinutes(5);
        Assert.assertEquals((long)86700000L, (long)lockInfo.getExpires().getTime());
    }

    @Test
    public void canSetTimeoutMinutesToInfinity() {
        LockInfoImplEx lockInfo = new LockInfoImplEx();
        lockInfo.setTimeoutMinutes(-1);
        Assert.assertNull((Object)lockInfo.getExpires());
    }

    @Test
    public void canGetRemainingTimeoutSeconds() {
        LockInfoImplEx lockInfo = new LockInfoImplEx();
        lockInfo.setTimeoutSeconds(7);
        Assert.assertEquals((long)7L, (long)lockInfo.getRemainingTimeoutSeconds());
    }

    public static class LockInfoImplEx
    extends LockInfoImpl {
        public static final Date DATE_NOW = new Date(86400000L);
        private static final long serialVersionUID = 1669378516554195322L;

        @Override
        protected Date dateNow() {
            return DATE_NOW;
        }
    }
}

