/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.webdav.AbstractMoveOrCopyMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public class MoveMethod
extends AbstractMoveOrCopyMethod {
    @Override
    protected void moveOrCopy(FileFolderService fileFolderService, NodeRef sourceNodeRef, NodeRef sourceParentNodeRef, NodeRef destParentNodeRef, String name) throws Exception {
        NodeService nodeService;
        FileInfo destFileInfo;
        FileInfo sourceFileInfo;
        block11: {
            NodeRef rootNodeRef = this.getRootNodeRef();
            String sourcePath = this.getPath();
            List<String> sourcePathElements = this.getDAVHelper().splitAllPaths(sourcePath);
            sourceFileInfo = null;
            String destPath = this.getDestinationPath();
            List<String> destPathElements = this.getDAVHelper().splitAllPaths(destPath);
            destFileInfo = null;
            nodeService = this.getNodeService();
            try {
                sourceFileInfo = fileFolderService.resolveNamePath(rootNodeRef, sourcePathElements);
                destFileInfo = fileFolderService.resolveNamePath(rootNodeRef, destPathElements);
            }
            catch (FileNotFoundException e) {
                if (sourceFileInfo != null) break block11;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Source node not found: " + sourcePath));
                }
                throw new WebDAVServerException(404);
            }
        }
        this.checkNode(sourceFileInfo);
        if (destFileInfo != null && (this.isShuffleOperation(sourceFileInfo) || this.isVersioned(destFileInfo))) {
            this.copyOnlyContent(sourceNodeRef, destFileInfo, fileFolderService);
        } else if (nodeService.hasAspect(sourceNodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            fileFolderService.copy(sourceNodeRef, destParentNodeRef, name);
        } else if (destFileInfo != null && nodeService.hasAspect(destFileInfo.getNodeRef(), ContentModel.ASPECT_WORKING_COPY)) {
            this.copyOnlyContent(sourceNodeRef, destFileInfo, fileFolderService);
        } else if (sourceParentNodeRef.equals((Object)destParentNodeRef)) {
            fileFolderService.rename(sourceNodeRef, name);
        } else {
            fileFolderService.moveFrom(sourceNodeRef, sourceParentNodeRef, destParentNodeRef, name);
        }
    }

    private void copyOnlyContent(NodeRef sourceNodeRef, FileInfo destFileInfo, FileFolderService fileFolderService) {
        ContentService contentService = this.getContentService();
        ContentReader reader = contentService.getReader(sourceNodeRef, ContentModel.PROP_CONTENT);
        ContentWriter contentWriter = contentService.getWriter(destFileInfo.getNodeRef(), ContentModel.PROP_CONTENT, true);
        contentWriter.putContent(reader);
        fileFolderService.delete(sourceNodeRef);
    }
}

