/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;

public class UnlockMethod
extends WebDAVMethod {
    private String m_strLockToken = null;

    protected final String getLockToken() {
        return this.m_strLockToken;
    }

    @Override
    protected void parseRequestHeaders() throws WebDAVServerException {
        String strLockTokenHeader = this.m_request.getHeader("Lock-Token");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Parsing Lock-Token header: " + strLockTokenHeader));
        }
        if (strLockTokenHeader != null) {
            if (!strLockTokenHeader.startsWith("<") || !strLockTokenHeader.endsWith(">")) {
                strLockTokenHeader = "<" + strLockTokenHeader + ">";
            }
            if (strLockTokenHeader.startsWith("<opaquelocktoken:") && strLockTokenHeader.endsWith(">")) {
                try {
                    this.m_strLockToken = strLockTokenHeader.substring("opaquelocktoken:".length() + 1, strLockTokenHeader.length() - 1);
                }
                catch (IndexOutOfBoundsException e) {
                    logger.warn((Object)("Failed to parse If header: " + strLockTokenHeader));
                }
            }
        }
        if (this.m_strLockToken == null) {
            throw new WebDAVServerException(400);
        }
    }

    @Override
    protected void parseRequestBody() throws WebDAVServerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeImpl() throws WebDAVServerException {
        block20: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unlock node; path=" + this.getPath() + ", token=" + this.getLockToken()));
            }
            FileInfo lockNodeInfo = null;
            try {
                lockNodeInfo = this.getNodeForPath(this.getRootNodeRef(), this.getPath(), this.getServletPath());
            }
            catch (FileNotFoundException e) {
                throw new WebDAVServerException(404);
            }
            String[] lockInfoFromRequest = WebDAV.parseLockToken(this.getLockToken());
            if (lockInfoFromRequest == null) {
                throw new WebDAVServerException(412);
            }
            NodeRef nodeRef = lockNodeInfo.getNodeRef();
            LockInfo lockInfo = this.getDAVLockService().getLockInfo(nodeRef);
            if (lockInfo == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Unlock token=" + this.getLockToken() + " Not locked - no info in lock store."));
                }
                throw new WebDAVServerException(412);
            }
            lockInfo.getRWLock().writeLock().lock();
            try {
                if (!lockInfo.isLocked()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Unlock token=" + this.getLockToken() + " Not locked"));
                    }
                    throw new WebDAVServerException(412);
                }
                if (lockInfo.isExpired()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Unlock token=" + this.getLockToken() + " Lock expired"));
                    }
                    this.m_response.setStatus(204);
                    this.removeNoContentAspect(nodeRef);
                    break block20;
                }
                if (lockInfo.isExclusive()) {
                    String currentUser = this.getAuthenticationService().getCurrentUserName();
                    if (currentUser.equals(lockInfo.getOwner())) {
                        this.getDAVLockService().unlock(nodeRef);
                        this.m_response.setStatus(204);
                        this.removeNoContentAspect(nodeRef);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Unlock token=" + this.getLockToken() + " Successful"));
                        }
                        break block20;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Unlock token=" + this.getLockToken() + " Not lock owner"));
                    }
                    throw new WebDAVServerException(412);
                }
                if (lockInfo.isShared()) {
                    Set sharedLocks = lockInfo.getSharedLockTokens();
                    if (sharedLocks.contains(this.m_strLockToken)) {
                        sharedLocks.remove(this.m_strLockToken);
                        this.m_response.setStatus(204);
                        this.removeNoContentAspect(nodeRef);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Unlock token=" + this.getLockToken() + " Successful"));
                        }
                    }
                    break block20;
                }
                throw new IllegalStateException("Invalid LockInfo state: " + lockInfo);
            }
            finally {
                lockInfo.getRWLock().writeLock().unlock();
            }
        }
    }

    private void removeNoContentAspect(NodeRef nodeRef) {
        if (this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_WEBDAV_NO_CONTENT)) {
            this.getNodeService().removeAspect(nodeRef, ContentModel.ASPECT_WEBDAV_NO_CONTENT);
            this.getNodeService().deleteNode(nodeRef);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unlock Timer DISABLE and DELETE " + this.getPath()));
            }
        }
    }
}

