/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.webdav.UnlockMethod;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class UnlockMethodTest {
    private UnlockMethod unlockMethod;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    @Mock
    private WebDAVHelper davHelper;

    @Before
    public void setUp() throws Exception {
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
        this.unlockMethod = new UnlockMethod();
        this.unlockMethod.setDetails((HttpServletRequest)this.request, (HttpServletResponse)this.response, this.davHelper, null);
    }

    @Test
    public void parseValidLockTokenHeader() throws WebDAVServerException {
        String lockToken = "976e2f82-40ab-4852-a867-986e9ce11f82:admin";
        String lockHeaderValue = "<opaquelocktoken:" + lockToken + ">";
        this.request.addHeader("Lock-Token", (Object)lockHeaderValue);
        this.unlockMethod.parseRequestHeaders();
        Assert.assertEquals((Object)lockToken, (Object)this.unlockMethod.getLockToken());
    }

    @Test
    public void parseInvalidLockTokenHeader() {
        String lockToken = "976e2f82-40ab-4852-a867-986e9ce11f82:admin";
        String lockHeaderValue = "<wrongprefix:" + lockToken + ">";
        this.request.addHeader("Lock-Token", (Object)lockHeaderValue);
        try {
            this.unlockMethod.parseRequestHeaders();
            Assert.fail((String)"Exception should have been thrown, but wasn't.");
        }
        catch (WebDAVServerException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpStatusCode());
        }
    }

    @Test
    public void parseMissingLockTokenHeader() {
        try {
            this.unlockMethod.parseRequestHeaders();
            Assert.fail((String)"Exception should have been thrown, but wasn't.");
        }
        catch (WebDAVServerException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpStatusCode());
        }
    }

    @Test
    public void parseLockTokenHeaderFromOOoOnWindows7() throws WebDAVServerException {
        String lockToken = "976e2f82-40ab-4852-a867-986e9ce11f82:admin";
        String lockHeaderValue = "opaquelocktoken:" + lockToken;
        this.request.addHeader("Lock-Token", (Object)lockHeaderValue);
        this.unlockMethod.parseRequestHeaders();
        Assert.assertEquals((Object)lockToken, (Object)this.unlockMethod.getLockToken());
    }
}

