/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebDAV {
    private static Log logger = LogFactory.getLog((String)"org.alfresco.webdav.protocol");
    public static final String DAV_NS = "D";
    public static final String DAV_NS_PREFIX = "D:";
    public static final int DEPTH_0 = 0;
    public static final int DEPTH_1 = 1;
    public static final int DEPTH_INFINITY = -1;
    public static final short TIMEOUT_INFINITY = -1;
    public static final int TIMEOUT_24_HOURS = 86400;
    public static final int WEBDAV_SC_MULTI_STATUS = 207;
    public static final int WEBDAV_SC_LOCKED = 423;
    public static final int WEBDAV_SC_FAILED_DEPENDENCY = 424;
    public static final String WEBDAV_SC_FAILED_DEPENDENCY_DESC = "Failed Dependency";
    public static final String SC_OK_DESC = "OK";
    public static final String SC_NOT_FOUND_DESC = "Not Found";
    public static final String SC_FORBIDDEN_DESC = "Forbidden";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_PROPFIND = "PROPFIND";
    public static final String METHOD_PROPPATCH = "PROPPATCH";
    public static final String METHOD_MKCOL = "MKCOL";
    public static final String METHOD_MOVE = "MOVE";
    public static final String METHOD_COPY = "COPY";
    public static final String METHOD_LOCK = "LOCK";
    public static final String METHOD_UNLOCK = "UNLOCK";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_DEPTH = "Depth";
    public static final String HEADER_DESTINATION = "Destination";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_EXPECT = "Expect";
    public static final String HEADER_EXPECT_CONTENT = "100-continue";
    public static final String HEADER_IF = "If";
    public static final String HEADER_IF_MATCH = "If-Match";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_IF_RANGE = "If-Range";
    public static final String HEADER_IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_LOCK_TOKEN = "Lock-Token";
    public static final String HEADER_OVERWRITE = "Overwrite";
    public static final String HEADER_RANGE = "Range";
    public static final String HEADER_TIMEOUT = "Timeout";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_IF_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HEADER_KEY_NOT = "Not";
    public static final String AGENT_MICROSOFT_DATA_ACCESS_INTERNET_PUBLISHING_PROVIDER_DAV = "Microsoft Data Access Internet Publishing Provider DAV";
    public static final String AGENT_INTERNET_EXPLORER = "MSIE";
    public static final String ASTERISK = "*";
    public static final String DEFAULT_NAMESPACE_URI = "DAV:";
    public static final String FAKE_TOKEN = "faketoken";
    public static final String HTTP1_1 = "HTTP/1.1";
    public static final String INFINITE = "Infinite";
    public static final String INFINITY = "infinity";
    public static final String OPAQUE_LOCK_TOKEN = "opaquelocktoken:";
    public static final String NAMESPACE_SEPARATOR = ":";
    public static final String SECOND = "Second-";
    public static final String HEADER_VALUE_SEPARATOR = ",";
    public static final String ZERO = "0";
    public static final String ONE = "1";
    public static final String F = "F";
    public static final String XML_NS = "xmlns";
    public static final String XML_ACTIVE_LOCK = "activelock";
    public static final String XML_ALLPROP = "allprop";
    public static final String XML_COLLECTION = "collection";
    public static final String XML_CREATION_DATE = "creationdate";
    public static final String XML_DEPTH = "depth";
    public static final String XML_DISPLAYNAME = "displayname";
    public static final String XML_EXCLUSIVE = "exclusive";
    public static final String XML_GET_CONTENT_LANGUAGE = "getcontentlanguage";
    public static final String XML_GET_CONTENT_LENGTH = "getcontentlength";
    public static final String XML_GET_CONTENT_TYPE = "getcontenttype";
    public static final String XML_GET_ETAG = "getetag";
    public static final String XML_GET_LAST_MODIFIED = "getlastmodified";
    public static final String XML_HREF = "href";
    public static final String XML_LOCK_DISCOVERY = "lockdiscovery";
    public static final String XML_LOCK_ENTRY = "lockentry";
    public static final String XML_LOCK_SCOPE = "lockscope";
    public static final String XML_LOCK_TOKEN = "locktoken";
    public static final String XML_LOCK_TYPE = "locktype";
    public static final String XML_MULTI_STATUS = "multistatus";
    public static final String XML_OWNER = "owner";
    public static final String XML_PROP = "prop";
    public static final String XML_PROPNAME = "propname";
    public static final String XML_PROPSTAT = "propstat";
    public static final String XML_RESOURCE_TYPE = "resourcetype";
    public static final String XML_RESPONSE = "response";
    public static final String XML_SHARED = "shared";
    public static final String XML_SOURCE = "source";
    public static final String XML_STATUS = "status";
    public static final String XML_SUPPORTED_LOCK = "supportedlock";
    public static final String XML_TIMEOUT = "timeout";
    public static final String XML_WRITE = "write";
    public static final String XML_SET = "set";
    public static final String XML_REMOVE = "remove";
    public static final String XML_ERROR = "error";
    public static final String XML_NS_ACTIVE_LOCK = "D:activelock";
    public static final String XML_NS_ALLPROP = "D:allprop";
    public static final String XML_NS_COLLECTION = "D:collection";
    public static final String XML_NS_CREATION_DATE = "D:creationdate";
    public static final String XML_NS_DEPTH = "D:depth";
    public static final String XML_NS_DISPLAYNAME = "D:displayname";
    public static final String XML_NS_EXCLUSIVE = "D:exclusive";
    public static final String XML_NS_GET_CONTENT_LANGUAGE = "D:getcontentlanguage";
    public static final String XML_NS_GET_CONTENT_LENGTH = "D:getcontentlength";
    public static final String XML_NS_GET_CONTENT_TYPE = "D:getcontenttype";
    public static final String XML_NS_GET_ETAG = "D:getetag";
    public static final String XML_NS_GET_LAST_MODIFIED = "D:getlastmodified";
    public static final String XML_NS_HREF = "D:href";
    public static final String XML_NS_LOCK_DISCOVERY = "D:lockdiscovery";
    public static final String XML_NS_LOCK_ENTRY = "D:lockentry";
    public static final String XML_NS_LOCK_SCOPE = "D:lockscope";
    public static final String XML_NS_LOCK_TOKEN = "D:locktoken";
    public static final String XML_NS_LOCK_TYPE = "D:locktype";
    public static final String XML_NS_MULTI_STATUS = "D:multistatus";
    public static final String XML_NS_OWNER = "D:owner";
    public static final String XML_NS_PROP = "D:prop";
    public static final String XML_NS_PROPNAME = "D:propname";
    public static final String XML_NS_PROPSTAT = "D:propstat";
    public static final String XML_NS_RESOURCE_TYPE = "D:resourcetype";
    public static final String XML_NS_RESPONSE = "D:response";
    public static final String XML_NS_SHARED = "D:shared";
    public static final String XML_NS_SOURCE = "D:source";
    public static final String XML_NS_STATUS = "D:status";
    public static final String XML_NS_SUPPORTED_LOCK = "D:supportedlock";
    public static final String XML_NS_TIMEOUT = "D:timeout";
    public static final String XML_NS_WRITE = "D:write";
    public static final String XML_NS_ERROR = "D:error";
    public static final String XML_NS_CANNOT_MODIFY_PROTECTED_PROPERTY = "D:cannot-modify-protected-property";
    public static final String XML_CONTENT_TYPE = "text/xml; charset=UTF-8";
    public static final String XML_ALF_AUTHTICKET = "authticket";
    public static final String XML_NS_ALF_AUTHTICKET = "D:authticket";
    public static final String PathSeperator = "/";
    public static final char PathSeperatorChar = '/';
    public static final String LOCK_TOKEN_SEPERATOR = ":";
    public static final String RootPath = "/";
    private static Hashtable<String, QName> _propertyNameMap;
    private static String CREATION_DATE_FORMAT;

    public static String formatModifiedDate(Date date) {
        return WebDAV.formatHeaderDate(date);
    }

    public static String formatModifiedDate(long ldate) {
        return WebDAV.formatHeaderDate(ldate);
    }

    public static String formatCreationDate(Date date) {
        return DateFormatUtils.formatUTC((Date)date, (String)CREATION_DATE_FORMAT);
    }

    public static String formatCreationDate(long ldate) {
        return DateFormatUtils.formatUTC((long)ldate, (String)CREATION_DATE_FORMAT);
    }

    public static String formatHeaderDate(Date date) {
        return DateFormatUtils.format((Date)date, (String)HEADER_IF_DATE_FORMAT, (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.ENGLISH);
    }

    public static String formatHeaderDate(long ldate) {
        return DateFormatUtils.format((long)ldate, (String)HEADER_IF_DATE_FORMAT, (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.ENGLISH);
    }

    public static Object getDAVPropertyValue(Map<QName, Serializable> props, String davPropName) {
        QName propName = _propertyNameMap.get(davPropName);
        if (propName == null) {
            throw new AlfrescoRuntimeException("No mapping for WebDAV property " + davPropName);
        }
        Object value = props.get(propName);
        if (value instanceof ContentData) {
            ContentData contentData = (ContentData)value;
            if (davPropName.equals(XML_GET_CONTENT_TYPE)) {
                value = contentData.getMimetype();
            } else if (davPropName.equals(XML_GET_CONTENT_LENGTH)) {
                value = new Long(contentData.getSize());
            }
        }
        return value;
    }

    public static String decodeURL(String strPath) {
        int index;
        if (strPath == null) {
            return null;
        }
        String strNormalized = null;
        try {
            strNormalized = WebDAVHelper.decodeURL(strPath);
        }
        catch (Exception ex) {
            logger.error((Object)("Error in decodeURL, URL = " + strPath), (Throwable)ex);
        }
        if (strNormalized == null) {
            return null;
        }
        if (strNormalized.indexOf(92) >= 0) {
            strNormalized = strNormalized.replace('\\', '/');
        }
        if (!strNormalized.startsWith("/")) {
            strNormalized = "/" + strNormalized;
        }
        while ((index = strNormalized.indexOf("//")) >= 0) {
            strNormalized = strNormalized.substring(0, index) + strNormalized.substring(index + 1);
        }
        while ((index = strNormalized.indexOf("/./")) >= 0) {
            strNormalized = strNormalized.substring(0, index) + strNormalized.substring(index + 2);
        }
        while ((index = strNormalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = strNormalized.lastIndexOf(47, index - 1);
            strNormalized = strNormalized.substring(0, index2) + strNormalized.substring(index + 3);
        }
        return strNormalized;
    }

    public static final String makeLockToken(NodeRef lockNode, String owner) {
        StringBuilder str = new StringBuilder();
        str.append(OPAQUE_LOCK_TOKEN);
        str.append(lockNode.getId());
        str.append(":");
        str.append(ISO9075.encode((String)owner));
        return str.toString();
    }

    public static final String[] parseLockToken(String lockToken) {
        int pos;
        if (lockToken == null) {
            return null;
        }
        if (lockToken.startsWith(OPAQUE_LOCK_TOKEN)) {
            lockToken = lockToken.substring(OPAQUE_LOCK_TOKEN.length());
        }
        if ((pos = lockToken.indexOf(":")) == -1) {
            return null;
        }
        String[] tokens = new String[]{lockToken.substring(0, pos), lockToken.substring(pos + 1)};
        return tokens;
    }

    public static final String getDepthName(int depth) {
        switch (depth) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case -1: {
                return INFINITY;
            }
        }
        throw new IllegalArgumentException("Unknown depth:" + depth);
    }

    static {
        CREATION_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        _propertyNameMap = new Hashtable();
        _propertyNameMap.put(XML_DISPLAYNAME, ContentModel.PROP_NAME);
        _propertyNameMap.put(XML_CREATION_DATE, ContentModel.PROP_CREATED);
        _propertyNameMap.put(XML_GET_LAST_MODIFIED, ContentModel.PROP_MODIFIED);
        _propertyNameMap.put(XML_GET_CONTENT_TYPE, ContentModel.PROP_CONTENT);
    }
}

