/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.jlan.util.IPAddress;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.lock.LockUtils;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.repo.webdav.WebDAVLockService;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.util.StringUtils;
import org.xml.sax.helpers.AttributesImpl;

public class WebDAVHelper {
    private static final String HTTPS_SCHEME = "https://";
    private static final String HTTP_SCHEME = "http://";
    public static final String PathSeperator = "/";
    public static final char PathSeperatorChar = '/';
    public static final String EMPTY_SITE_ID = "";
    private static Log logger = LogFactory.getLog((String)"org.alfresco.webdav.protocol");
    private ServiceRegistry m_serviceRegistry;
    private NodeService m_nodeService;
    private FileFolderService m_fileFolderService;
    private SearchService m_searchService;
    private NamespaceService m_namespaceService;
    private DictionaryService m_dictionaryService;
    private MimetypeService m_mimetypeService;
    private WebDAVLockService m_lockService;
    private ActionService m_actionService;
    private AuthenticationService m_authService;
    private PermissionService m_permissionService;
    private TenantService m_tenantService;
    private AttributesImpl m_nullAttribs = new AttributesImpl();
    private String m_urlPathPrefix;

    protected WebDAVHelper(String urlPathPrefix, ServiceRegistry serviceRegistry, AuthenticationService authService, TenantService tenantService) {
        this.m_serviceRegistry = serviceRegistry;
        this.m_nodeService = this.m_serviceRegistry.getNodeService();
        this.m_fileFolderService = this.m_serviceRegistry.getFileFolderService();
        this.m_searchService = this.m_serviceRegistry.getSearchService();
        this.m_namespaceService = this.m_serviceRegistry.getNamespaceService();
        this.m_dictionaryService = this.m_serviceRegistry.getDictionaryService();
        this.m_mimetypeService = this.m_serviceRegistry.getMimetypeService();
        this.m_lockService = (WebDAVLockService)this.m_serviceRegistry.getService(QName.createQName((String)"http://www.alfresco.org", (String)"webDAVLockService"));
        this.m_actionService = this.m_serviceRegistry.getActionService();
        this.m_permissionService = this.m_serviceRegistry.getPermissionService();
        this.m_tenantService = tenantService;
        this.m_authService = authService;
        this.m_urlPathPrefix = urlPathPrefix;
    }

    public final AuthenticationService getAuthenticationService() {
        return this.m_authService;
    }

    public final ServiceRegistry getServiceRegistry() {
        return this.m_serviceRegistry;
    }

    public final NodeService getNodeService() {
        return this.m_nodeService;
    }

    public FileFolderService getFileFolderService() {
        return this.m_fileFolderService;
    }

    public final SearchService getSearchService() {
        return this.m_searchService;
    }

    public final NamespaceService getNamespaceService() {
        return this.m_namespaceService;
    }

    public final DictionaryService getDictionaryService() {
        return this.m_dictionaryService;
    }

    public final MimetypeService getMimetypeService() {
        return this.m_mimetypeService;
    }

    public final WebDAVLockService getLockService() {
        return this.m_lockService;
    }

    public final ActionService getActionService() {
        return this.m_actionService;
    }

    public final PermissionService getPermissionService() {
        return this.m_permissionService;
    }

    public TenantService getTenantService() {
        return this.m_tenantService;
    }

    public final CopyService getCopyService() {
        return this.getServiceRegistry().getCopyService();
    }

    public final String[] splitPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path may not be null");
        }
        String[] pathStr = new String[]{EMPTY_SITE_ID, EMPTY_SITE_ID};
        int pos = path.lastIndexOf(47);
        if (pos == -1 || pos == path.length() - 1) {
            pathStr[1] = path;
        } else {
            pathStr[0] = path.substring(0, pos);
            pathStr[1] = path.substring(pos + 1);
        }
        return pathStr;
    }

    public final List<String> splitAllPaths(String path) {
        if (path == null || path.length() == 0) {
            return Collections.emptyList();
        }
        StringTokenizer token = new StringTokenizer(path, PathSeperator);
        ArrayList<String> results = new ArrayList<String>(10);
        while (token.hasMoreTokens()) {
            results.add(token.nextToken());
        }
        return results;
    }

    public String getURLForPath(HttpServletRequest request, String path, boolean isCollection) {
        return this.getURLForPath(request, path, isCollection, null);
    }

    public String getURLForPath(HttpServletRequest request, String path, boolean isCollection, String userAgent) {
        String urlPathPrefix = this.getUrlPathPrefix(request);
        StringBuilder urlStr = new StringBuilder(urlPathPrefix);
        if (!path.equals(PathSeperator)) {
            StringTokenizer t = new StringTokenizer(path, PathSeperator);
            while (t.hasMoreTokens()) {
                urlStr.append(WebDAVHelper.encodeURL(t.nextToken(), userAgent));
                if (!t.hasMoreTokens()) continue;
                urlStr.append(PathSeperator);
            }
        }
        if (isCollection && urlStr.charAt(urlStr.length() - 1) != '/') {
            urlStr.append(PathSeperator);
        }
        logger.debug((Object)("getURLForPath() path:" + path + " => url:" + urlStr));
        return urlStr.toString();
    }

    public final FileInfo getNodeForPath(NodeRef rootNodeRef, String path, String servletPath) throws FileNotFoundException {
        String comparePath;
        if (rootNodeRef == null) {
            throw new IllegalArgumentException("Root node may not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path may not be null");
        }
        FileFolderService fileFolderService = this.getFileFolderService();
        if (path.length() == 0 || path.equals(PathSeperator) || EqualsHelper.nullSafeEquals((Object)path, (Object)servletPath)) {
            return fileFolderService.getFileInfo(rootNodeRef);
        }
        if (servletPath != null && servletPath.length() > 0 && path.startsWith(comparePath = servletPath + PathSeperator)) {
            path = path.substring(servletPath.length());
        }
        List<String> splitPath = this.splitAllPaths(path);
        FileInfo fileInfo = this.m_fileFolderService.resolveNamePath(rootNodeRef, splitPath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetched node for path: \n   root: " + rootNodeRef + "\n" + "   path: " + path + "\n" + "   servlet path: " + servletPath + "\n" + "   result: " + fileInfo));
        }
        return fileInfo;
    }

    public final FileInfo getParentNodeForPath(NodeRef rootNodeRef, String path, String servletPath) throws FileNotFoundException {
        if (rootNodeRef == null) {
            throw new IllegalArgumentException("Root node may not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path may not be null");
        }
        String[] paths = this.splitPath(path);
        return this.getNodeForPath(rootNodeRef, paths[0], servletPath);
    }

    public final String getPathFromNode(NodeRef rootNodeRef, NodeRef nodeRef) throws FileNotFoundException {
        if (rootNodeRef == null || nodeRef == null) {
            throw new IllegalArgumentException("Invalid node(s) in getPathFromNode call");
        }
        if (rootNodeRef.equals((Object)nodeRef)) {
            return EMPTY_SITE_ID;
        }
        FileFolderService fileFolderService = this.getFileFolderService();
        List pathInfos = fileFolderService.getNamePath(rootNodeRef, nodeRef);
        StringBuilder sb = new StringBuilder(pathInfos.size() * 20);
        for (FileInfo fileInfo : pathInfos) {
            sb.append('/');
            sb.append(fileInfo.getName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Build name path for node: \n   root: " + rootNodeRef + "\n" + "   target: " + nodeRef + "\n" + "   path: " + sb));
        }
        return sb.toString();
    }

    public List<FileInfo> getChildren(FileInfo fileInfo) throws WebDAVServerException {
        return this.m_fileFolderService.list(fileInfo.getNodeRef());
    }

    public final String makeETag(FileInfo nodeInfo) {
        StringBuilder etag = new StringBuilder();
        this.makeETagString(nodeInfo, etag);
        return etag.toString();
    }

    public final String makeQuotedETag(FileInfo nodeInfo) {
        StringBuilder etag = new StringBuilder();
        etag.append("\"");
        this.makeETagString(nodeInfo, etag);
        etag.append("\"");
        return etag.toString();
    }

    protected final void makeETagString(FileInfo nodeInfo, StringBuilder etag) {
        Object modVal = nodeInfo.getProperties().get(ContentModel.PROP_MODIFIED);
        etag.append(nodeInfo.getNodeRef().getId());
        if (modVal != null) {
            etag.append("_");
            etag.append(DefaultTypeConverter.INSTANCE.longValue(modVal));
        }
    }

    public final AttributesImpl getNullAttributes() {
        return this.m_nullAttribs;
    }

    public static final String encodeURL(String s) {
        return WebDAVHelper.encodeURL(s, null);
    }

    public static final String encodeURL(String s, String userAgent) {
        try {
            if (userAgent != null && (userAgent.startsWith("Microsoft Data Access Internet Publishing Provider DAV") || userAgent.contains("MSIE"))) {
                return WebDAVHelper.encodeUrlReservedSymbols(s);
            }
            return URLEncoder.encode((String)s);
        }
        catch (UnsupportedEncodingException err) {
            throw new RuntimeException(err);
        }
    }

    public static final String decodeURL(String s) {
        return URLDecoder.decode((String)s);
    }

    public static final String encodeHTML(String string) {
        if (string == null) {
            return EMPTY_SITE_ID;
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            String enc = null;
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    enc = "&quot;";
                    break;
                }
                case '&': {
                    enc = "&amp;";
                    break;
                }
                case '<': {
                    enc = "&lt;";
                    break;
                }
                case '>': {
                    enc = "&gt;";
                    break;
                }
                case '\u20ac': {
                    enc = "&euro;";
                    break;
                }
                case '\u00ab': {
                    enc = "&laquo;";
                    break;
                }
                case '\u00bb': {
                    enc = "&raquo;";
                    break;
                }
                case '\u00a0': {
                    enc = "&nbsp;";
                    break;
                }
                default: {
                    if (c < '\u0080') break;
                    enc = "&#" + c + ";";
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = string.substring(0, i);
                    sb = new StringBuilder(i + 8);
                    sb.append(soFar);
                }
                sb.append(enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static final String encodeUrlReservedSymbols(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return EMPTY_SITE_ID;
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            String enc = null;
            char c = string.charAt(i);
            switch (c) {
                case ';': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '/': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '?': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case ':': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '@': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '&': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '=': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '+': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '\"': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '#': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '%': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '>': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
                case '<': {
                    enc = URLEncoder.encode((String)String.valueOf(c));
                    break;
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = string.substring(0, i);
                    sb = new StringBuilder(i + 8);
                    sb.append(soFar);
                }
                sb.append(enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public String determineSiteId(WebDAVMethod method) {
        String siteId;
        SiteService siteService = this.getServiceRegistry().getSiteService();
        try {
            FileInfo fileInfo = this.getNodeForPath(method.getRootNodeRef(), method.getPath(), method.getServletPath());
            SiteInfo siteInfo = siteService.getSite(fileInfo.getNodeRef());
            if (siteInfo == null) {
                throw new RuntimeException("Node is not contained by a site: " + method.getPath());
            }
            siteId = siteInfo.getShortName();
        }
        catch (Exception error) {
            siteId = EMPTY_SITE_ID;
        }
        return siteId;
    }

    public String determineTenantDomain(WebDAVMethod method) {
        TenantService tenantService = this.getTenantService();
        String tenantDomain = tenantService.getCurrentUserDomain();
        if (tenantDomain == null) {
            return EMPTY_SITE_ID;
        }
        return tenantDomain;
    }

    public String getDestinationPath(String contextPath, String servletPath, String destURL) {
        if (destURL != null && destURL.length() > 0) {
            int offset = -1;
            if (destURL.startsWith(HTTP_SCHEME)) {
                offset = HTTP_SCHEME.length();
            } else if (destURL.startsWith(HTTPS_SCHEME)) {
                offset = HTTPS_SCHEME.length();
            }
            if (offset != -1 && (offset = destURL.indexOf(PathSeperator, offset)) != -1) {
                String pathPrefix;
                String strPath = destURL.substring(offset);
                if (strPath.startsWith(pathPrefix = contextPath + servletPath + PathSeperator)) {
                    strPath = strPath.substring(pathPrefix.length());
                }
                return WebDAV.decodeURL(strPath);
            }
        }
        return null;
    }

    public void checkDestinationURL(HttpServletRequest request, String urlStr) throws WebDAVServerException {
        try {
            URL url = new URL(urlStr);
            boolean localPath = true;
            if (url.getPort() != -1 && url.getPort() != request.getServerPort()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Destination path, different server port");
                }
                localPath = false;
            } else if (!url.getHost().equalsIgnoreCase(request.getServerName()) && !url.getHost().equals(request.getLocalAddr())) {
                String targetHost = url.getHost();
                if (!IPAddress.isNumericAddress((String)targetHost)) {
                    String localHost = request.getServerName();
                    int pos = targetHost.indexOf(".");
                    if (pos != -1) {
                        targetHost = targetHost.substring(0, pos);
                    }
                    if ((pos = localHost.indexOf(".")) != -1) {
                        localHost = localHost.substring(0, pos);
                    }
                    if (!targetHost.equalsIgnoreCase(localHost)) {
                        localPath = false;
                    }
                } else {
                    try {
                        InetAddress targetAddr = InetAddress.getByName(targetHost);
                        if (NetworkInterface.getByInetAddress(targetAddr) == null) {
                            localPath = false;
                        }
                    }
                    catch (Exception ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Failed to check target IP address, " + targetHost));
                        }
                        localPath = false;
                    }
                }
                if (!localPath && logger.isDebugEnabled()) {
                    logger.debug((Object)"Destination path, different server name/address");
                    logger.debug((Object)("  URL host=" + url.getHost() + ", ServerName=" + request.getServerName() + ", localAddr=" + request.getLocalAddr()));
                }
            } else if (!url.getPath().startsWith(this.getUrlPathPrefix(request))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Destination path, different serlet path");
                }
                localPath = false;
            }
            if (!localPath) {
                throw new WebDAVServerException(502);
            }
        }
        catch (MalformedURLException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Bad destination path, " + urlStr));
            }
            throw new WebDAVServerException(502);
        }
    }

    public void setUrlPathPrefix(String urlPathPrefix) {
        this.m_urlPathPrefix = urlPathPrefix;
    }

    public String getUrlPathPrefix(HttpServletRequest request) {
        StringBuilder urlStr = null;
        if (StringUtils.hasText((String)this.m_urlPathPrefix)) {
            urlStr = new StringBuilder(this.m_urlPathPrefix);
        } else {
            String servletPath;
            urlStr = new StringBuilder(request.getRequestURI());
            int rootPos = urlStr.indexOf(servletPath = request.getServletPath());
            if (rootPos != -1) {
                urlStr.setLength(rootPos + servletPath.length());
            }
        }
        if (urlStr.charAt(urlStr.length() - 1) != '/') {
            urlStr.append(PathSeperator);
        }
        return urlStr.toString();
    }

    public String getRepositoryPath(HttpServletRequest request) {
        String strPath = null;
        try {
            strPath = WebDAVHelper.decodeURL(request.getRequestURI());
        }
        catch (Exception ex) {
            // empty catch block
        }
        String servletPath = request.getServletPath();
        int rootPos = strPath.indexOf(servletPath);
        if (rootPos != -1) {
            strPath = strPath.substring(rootPos);
        }
        if (strPath == null) {
            strPath = request.getServletPath();
        }
        if (strPath == null || strPath.length() == 0) {
            strPath = PathSeperator;
        } else if (strPath.startsWith(request.getServletPath())) {
            int len = request.getServletPath().length();
            strPath = strPath.length() > len ? strPath.substring(len) : PathSeperator;
        }
        if (strPath.length() > 1 && strPath.endsWith(PathSeperator)) {
            strPath = strPath.substring(0, strPath.length() - 1);
        }
        return strPath;
    }

    public boolean isLockedOrReadOnly(NodeRef nodeRef) {
        return LockUtils.isLockedOrReadOnly((NodeRef)nodeRef, (LockService)this.m_serviceRegistry.getLockService());
    }
}

