/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import javax.servlet.http.HttpServletRequest;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.mock.web.MockHttpServletRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class WebDAVHelperTest {
    private WebDAVHelper davHelper;
    @Mock
    private ServiceRegistry serviceRegistry;
    @Mock
    private AuthenticationService authService;
    @Mock
    private TenantService tenantService;

    @Before
    public void setUp() throws Exception {
        this.davHelper = new WebDAVHelper("", this.serviceRegistry, this.authService, this.tenantService);
    }

    @Test
    public void canGetUrlPathPrefixWhenExplicitlySet() {
        this.davHelper = new WebDAVHelper("/my/prefix", this.serviceRegistry, this.authService, this.tenantService);
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "/my/prefix/folder/filename.txt");
        String prefix = this.davHelper.getUrlPathPrefix((HttpServletRequest)request);
        Assert.assertEquals((Object)"/my/prefix/", (Object)prefix);
    }

    @Test
    public void canGetUrlPathPrefixFromServletPath() {
        this.davHelper = new WebDAVHelper("", this.serviceRegistry, this.authService, this.tenantService);
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "/before/the-servlet/folder/filename.txt");
        request.setServletPath("/the-servlet");
        String prefix = this.davHelper.getUrlPathPrefix((HttpServletRequest)request);
        Assert.assertEquals((Object)"/before/the-servlet/", (Object)prefix);
    }

    @Test
    public void canGetDestinationPathWhenNoServletName() {
        this.assertPathForURL("/the-tenant.com/the-site/path/to/file", "http://webdav.alfresco.com/the-tenant.com/the-site/path/to/file");
    }

    @Test
    public void canGetDestinationPathWhenPathElementStartsWithServletPath() {
        this.assertPathForURL("/t/webdav-test/path/to/file", "http://webdav.alfresco.com/t/webdav-test/path/to/file");
        this.assertPathForURL("/alfresco/webdav-test/path/to/file", "http://webdav.alfresco.com/alfresco/webdav-test/path/to/file");
    }

    @Test
    public void canGetDestinationPathWhenPrefixedWithContextPathAndServletName() {
        this.assertPathForURL("/path/to/file", "http://webdav.alfresco.com/alfresco/webdav/path/to/file");
        this.assertPathForURL("/alfresco/webdav/path/to/file", "http://webdav.alfresco.com/alfresco/webdav/alfresco/webdav/path/to/file");
        this.assertPathForURL("/my/folder/alfresco/webdav/path/to/file", "http://webdav.alfresco.com/alfresco/webdav/my/folder/alfresco/webdav/path/to/file");
    }

    private void assertPathForURL(String path, String url) {
        Assert.assertEquals((Object)path, (Object)this.davHelper.getDestinationPath("/alfresco", "/webdav", url));
    }
}

