/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class WebDAVMethodTest {
    private WebDAVMethod method;
    private MockHttpServletRequest req;
    private MockHttpServletResponse resp;
    @Mock
    private WebDAVHelper davHelper;

    @Test
    public void canGetStatusForAccessDeniedException() {
        this.assertStatusCode(500, "WebDAVLib/1.3");
        this.assertStatusCode(500, "WebDAVFS/1.9.0 (01908000) Darwin/11.4.0 (x86_64)");
        this.assertStatusCode(500, "WebDAVFS/100.10.5 (01908000) Darwin/11.4.0 (x86_64)");
        this.assertStatusCode(500, "WebDAVFS/100.10.5 (01908000) Darwin/109.6.3 (some_other_processor_arch)");
        this.assertStatusCode(403, "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_6; en-us)");
        this.assertStatusCode(403, "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.2.12)");
        this.assertStatusCode(403, "SomeBrowser/1.0 (Macintosh; U; Intel Mac OS X 10_6; en-us)");
        this.assertStatusCode(403, "SomeBrowser/1.9.0 (01908000) Darwin/11.4.0 (x86_64)");
        this.assertStatusCode(403, "Cyberduck/4.2.1 (Mac OS X/10.7.4) (i386)");
        this.assertStatusCode(403, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_4) AppleWebKit/536.5 (KHTML, like Gecko) Chrome/19.0.1084.54 Safari/536.5");
        this.assertStatusCode(403, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_4) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2");
    }

    private void assertStatusCode(int expectedStatusCode, String userAgent) {
        this.createRequestObjects();
        this.req.addHeader("User-Agent", (Object)userAgent);
        this.method.setDetails((HttpServletRequest)this.req, (HttpServletResponse)this.resp, this.davHelper, null);
        int statusCode = this.method.getStatusForAccessDeniedException();
        Assert.assertEquals((String)("Incorrect status code for user-agent string \"" + userAgent + "\""), (long)expectedStatusCode, (long)statusCode);
    }

    private void createRequestObjects() {
        this.method = new TestWebDAVMethod();
        this.req = new MockHttpServletRequest();
        this.resp = new MockHttpServletResponse();
    }

    private static class TestWebDAVMethod
    extends WebDAVMethod {
        private TestWebDAVMethod() {
        }

        @Override
        protected void executeImpl() throws WebDAVServerException, Exception {
        }

        @Override
        protected void parseRequestBody() throws WebDAVServerException {
        }

        @Override
        protected void parseRequestHeaders() throws WebDAVServerException {
        }
    }
}

