/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav.auth;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.web.filter.beans.DependencyInjectedFilter;
import org.alfresco.repo.webdav.auth.BaseAuthenticationFilter;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationFilter
extends BaseAuthenticationFilter
implements DependencyInjectedFilter {
    private static Log logger = LogFactory.getLog(AuthenticationFilter.class);
    private static final String PPT_EXTN = ".ppt";
    private static final String[] ENCODINGS = new String[]{"UTF-8", System.getProperty("file.encoding"), "ISO-8859-1"};
    private static final CharsetDecoder[] DECODERS;

    @Override
    public void doFilter(ServletContext context, ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpResp = (HttpServletResponse)resp;
        SessionUser user = this.getSessionUser(context, httpReq, httpResp, false);
        if (user == null) {
            String authHdr = httpReq.getHeader("Authorization");
            if (authHdr != null && authHdr.length() > 5 && authHdr.substring(0, 5).equalsIgnoreCase("BASIC")) {
                byte[] encodedString = Base64.decodeBase64((byte[])authHdr.substring(5).getBytes());
                HashSet<String> attemptedAuths = new HashSet<String>(DECODERS.length * 2);
                for (CharsetDecoder decoder : DECODERS) {
                    try {
                        String password;
                        String username;
                        String basicAuth = decoder.decode(ByteBuffer.wrap(encodedString)).toString();
                        if (!attemptedAuths.add(basicAuth)) continue;
                        int pos = basicAuth.indexOf(":");
                        if (pos != -1) {
                            username = basicAuth.substring(0, pos);
                            password = basicAuth.substring(pos + 1);
                        } else {
                            username = basicAuth;
                            password = "";
                        }
                        this.authenticationService.authenticate(username, password.toCharArray());
                        user = this.createUserEnvironment(httpReq.getSession(), this.authenticationService.getCurrentUserName(), this.authenticationService.getCurrentTicket(), false);
                        break;
                    }
                    catch (CharacterCodingException e) {
                    }
                    catch (AuthenticationException ex) {
                    }
                    catch (NoSuchPersonException e) {
                        // empty catch block
                    }
                }
            } else {
                String ticket = req.getParameter("ticket");
                if (ticket != null && ticket.length() > 0) {
                    if (ticket.endsWith(PPT_EXTN)) {
                        ticket = ticket.substring(0, ticket.length() - PPT_EXTN.length());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Logon via ticket from " + req.getRemoteHost() + " (" + req.getRemoteAddr() + ":" + req.getRemotePort() + ")" + " ticket=" + ticket));
                    }
                    this.authenticationService.validate(ticket);
                    String currentUsername = this.authenticationService.getCurrentUserName();
                    user = this.createUserEnvironment(httpReq.getSession(), currentUsername, ticket, false);
                }
            }
            if (user == null) {
                httpResp.setHeader("WWW-Authenticate", "BASIC realm=\"Alfresco DAV Server\"");
                httpResp.setStatus(401);
                httpResp.flushBuffer();
                return;
            }
        }
        chain.doFilter(req, resp);
    }

    public void destroy() {
    }

    @Override
    protected Log getLogger() {
        return logger;
    }

    static {
        LinkedHashMap<String, CharsetDecoder> decoders = new LinkedHashMap<String, CharsetDecoder>(ENCODINGS.length * 2);
        for (String encoding : ENCODINGS) {
            if (decoders.containsKey(encoding)) continue;
            decoders.put(encoding, Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT));
        }
        DECODERS = new CharsetDecoder[decoders.size()];
        decoders.values().toArray(DECODERS);
    }
}

