/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav.auth;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.ExtendedServerConfigurationAccessor;
import org.alfresco.jlan.server.auth.ntlm.NTLM;
import org.alfresco.jlan.server.auth.passthru.DomainMapping;
import org.alfresco.jlan.server.config.SecurityConfigSection;
import org.alfresco.jlan.util.IPAddress;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.web.filter.beans.DependencyInjectedFilter;
import org.alfresco.repo.webdav.auth.AuthenticationDriver;
import org.alfresco.repo.webdav.auth.BaseAuthenticationFilter;
import org.springframework.beans.factory.InitializingBean;

public abstract class BaseSSOAuthenticationFilter
extends BaseAuthenticationFilter
implements DependencyInjectedFilter,
AuthenticationDriver,
ActivateableBean,
InitializingBean {
    private ExtendedServerConfigurationAccessor serverConfiguration;
    private String m_loginPage;
    private boolean m_ticketLogons;
    private String m_lastConfiguredServerName;
    private String m_lastResolvedServerName;
    private boolean m_isActive = true;
    protected static final String MIME_HTML_TEXT = "text/html";

    public void setServerConfiguration(ExtendedServerConfigurationAccessor serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    public final void setActive(boolean active) {
        this.m_isActive = active;
    }

    public final boolean isActive() {
        return this.m_isActive;
    }

    public final void afterPropertiesSet() throws ServletException {
        if (this.isActive()) {
            this.init();
        }
    }

    @Override
    public void doFilter(ServletContext context, ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute("alfNoAuthRequired") != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Authentication not required (filter), chaining ...");
            }
            chain.doFilter(request, response);
        } else if (this.authenticateRequest(context, (HttpServletRequest)request, (HttpServletResponse)response)) {
            chain.doFilter(request, response);
        }
    }

    protected void init() throws ServletException {
    }

    protected void onValidate(ServletContext sc, HttpServletRequest req, HttpServletResponse res) {
    }

    protected void onValidateFailed(ServletContext sc, HttpServletRequest req, HttpServletResponse res, HttpSession session) throws IOException {
        this.restartLoginChallenge(sc, req, res);
    }

    protected boolean onLoginComplete(ServletContext sc, HttpServletRequest req, HttpServletResponse res, boolean userInit) throws IOException {
        return true;
    }

    protected final String mapClientAddressToDomain(String clientIP) {
        SecurityConfigSection securityConfigSection = this.getSecurityConfigSection();
        if (securityConfigSection != null && !securityConfigSection.hasDomainMappings()) {
            return null;
        }
        if (securityConfigSection != null) {
            int clientAddr = IPAddress.parseNumericAddress((String)clientIP);
            for (DomainMapping domainMap : securityConfigSection.getDomainMappings()) {
                if (!domainMap.isMemberOfDomain(clientAddr)) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Mapped client IP " + clientIP + " to domain " + domainMap.getDomain()));
                }
                return domainMap.getDomain();
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Failed to map client IP " + clientIP + " to a domain"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkForTicketParameter(ServletContext servletContext, HttpServletRequest req, HttpServletResponse resp) {
        boolean ticketValid = false;
        String ticket = req.getParameter("ticket");
        if (ticket != null && ticket.length() != 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Logon via ticket from " + req.getRemoteHost() + " (" + req.getRemoteAddr() + ":" + req.getRemotePort() + ")" + " ticket=" + ticket));
            }
            Object tx = null;
            try {
                SessionUser user = this.getSessionUser(servletContext, req, resp, true);
                if (user != null && !ticket.equals(user.getTicket())) {
                    this.invalidateSession(req);
                    user = null;
                }
                if (user == null) {
                    this.authenticationService.validate(ticket);
                    user = this.createUserEnvironment(req.getSession(), this.authenticationService.getCurrentUserName(), this.authenticationService.getCurrentTicket(), true);
                }
                ticketValid = true;
            }
            catch (AuthenticationException authErr) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Failed to authenticate user ticket: " + authErr.getMessage()), (Throwable)authErr);
                }
            }
            catch (Throwable e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Error during ticket validation and user creation: " + e.getMessage()), e);
                }
            }
            finally {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {}
            }
        }
        return ticketValid;
    }

    protected void redirectToLoginPage(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"redirectToLoginPage...");
        }
        if (this.hasLoginPage()) {
            res.sendRedirect(req.getContextPath() + "/faces" + this.getLoginPage());
        }
    }

    protected final boolean hasLoginPage() {
        return this.m_loginPage != null;
    }

    protected final String getLoginPage() {
        return this.m_loginPage;
    }

    protected final void setLoginPage(String loginPage) {
        this.m_loginPage = loginPage;
    }

    protected final boolean allowsTicketLogons() {
        return this.m_ticketLogons;
    }

    public final void setTicketLogons(boolean ticketsAllowed) {
        this.m_ticketLogons = ticketsAllowed;
    }

    protected final boolean isNTLMSSPBlob(byte[] byts, int offset) {
        boolean isNTLMSSP = false;
        if (byts.length - offset >= NTLM.Signature.length) {
            int idx;
            for (idx = 0; idx < NTLM.Signature.length && byts[offset + idx] == NTLM.Signature[idx]; ++idx) {
            }
            if (idx == NTLM.Signature.length) {
                isNTLMSSP = true;
            }
        }
        return isNTLMSSP;
    }

    protected synchronized String getServerName() {
        block14: {
            String srvName = null;
            if (this.serverConfiguration != null && (srvName = this.serverConfiguration.getServerName()) != null && srvName.length() == 0) {
                srvName = null;
            }
            if (this.m_lastResolvedServerName != null && (this.m_lastConfiguredServerName == null && srvName == null || this.m_lastConfiguredServerName.equals(srvName))) {
                return this.m_lastResolvedServerName;
            }
            this.m_lastResolvedServerName = null;
            this.m_lastConfiguredServerName = srvName;
            if (this.serverConfiguration != null) {
                block13: {
                    if (this.m_lastConfiguredServerName != null) {
                        try {
                            InetAddress resolved = InetAddress.getByName(this.m_lastConfiguredServerName);
                            this.m_lastResolvedServerName = resolved == null ? this.serverConfiguration.getLocalServerName(true) : this.m_lastConfiguredServerName;
                        }
                        catch (UnknownHostException ex) {
                            if (!this.getLogger().isWarnEnabled()) break block13;
                            this.getLogger().warn((Object)("NTLM filter, error resolving CIFS host name" + this.m_lastConfiguredServerName));
                        }
                    }
                }
                if (this.m_lastResolvedServerName == null) {
                    this.m_lastResolvedServerName = this.serverConfiguration.getLocalServerName(true);
                    if (this.getLogger().isInfoEnabled()) {
                        this.getLogger().info((Object)("NTLM filter using server name " + this.m_lastResolvedServerName));
                    }
                }
            } else {
                try {
                    this.m_lastResolvedServerName = InetAddress.getLocalHost().getHostName();
                    int pos = this.m_lastResolvedServerName.indexOf(".");
                    if (pos != -1) {
                        this.m_lastResolvedServerName = this.m_lastResolvedServerName.substring(0, pos);
                    }
                }
                catch (UnknownHostException ex) {
                    if (!this.getLogger().isErrorEnabled()) break block14;
                    this.getLogger().error((Object)"NTLM filter, error getting local host name", (Throwable)ex);
                }
            }
        }
        if (this.m_lastResolvedServerName == null || this.m_lastResolvedServerName.length() == 0) {
            throw new AlfrescoRuntimeException("Failed to get local server name");
        }
        return this.m_lastResolvedServerName;
    }

    protected SecurityConfigSection getSecurityConfigSection() {
        return this.serverConfiguration == null ? null : (SecurityConfigSection)this.serverConfiguration.getConfigSection("Security");
    }

    protected void writeLoginPageLink(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.hasLoginPage()) {
            resp.setContentType(MIME_HTML_TEXT);
            PrintWriter out = resp.getWriter();
            out.println("<html><head>");
            out.println("<meta http-equiv=\"Refresh\" content=\"0; url=" + req.getContextPath() + "/faces" + this.getLoginPage() + "\">");
            out.println("</head><body><p>Please <a href=\"" + req.getContextPath() + "/faces" + this.getLoginPage() + "\">log in</a>.</p>");
            out.println("</body></html>");
            out.close();
        }
    }
}

