/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice;

import org.alfresco.repo.webservice.QuerySession;
import org.alfresco.repo.webservice.ServerQuery;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractQuerySession<RESULTSET, RESULTSETROW>
implements QuerySession<RESULTSET> {
    private static Log logger = LogFactory.getLog(AbstractQuerySession.class);
    private String id = GUID.generate();
    private long maxResults;
    private long batchSize;
    private ServerQuery<RESULTSET> query;
    private transient RESULTSET cachedResults;
    private long position;
    private boolean expectMoreResults;

    public AbstractQuerySession(long maxResults, long batchSize, ServerQuery<RESULTSET> query) {
        this.batchSize = batchSize;
        this.maxResults = maxResults;
        this.query = query;
        this.position = 0L;
        this.expectMoreResults = true;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ServerQuery<RESULTSET> getQuery() {
        return this.query;
    }

    protected RESULTSET getQueryResults(ServiceRegistry serviceRegistry) {
        if (this.cachedResults != null) {
            return this.cachedResults;
        }
        this.cachedResults = this.query.execute(serviceRegistry, this.maxResults);
        return this.cachedResults;
    }

    @Override
    public boolean haveMoreResults() {
        return this.expectMoreResults;
    }

    protected abstract RESULTSETROW[] makeArray(int var1);

    protected final RESULTSETROW[] getNextResults(RESULTSETROW[] allResults) {
        long allResultsSize = allResults.length;
        RESULTSETROW[] batchedResults = null;
        if (this.position >= allResultsSize) {
            batchedResults = this.makeArray(0);
            this.position = allResultsSize;
        } else if (this.position == 0L && this.batchSize >= allResultsSize) {
            batchedResults = allResults;
            this.position = allResultsSize;
        } else if (this.position + this.batchSize >= allResultsSize) {
            long rowCopyCount = allResultsSize - this.position;
            batchedResults = this.makeArray((int)rowCopyCount);
            System.arraycopy(allResults, (int)this.position, batchedResults, 0, (int)rowCopyCount);
            this.position = allResultsSize;
        } else {
            batchedResults = this.makeArray((int)this.batchSize);
            System.arraycopy(allResults, (int)this.position, batchedResults, 0, (int)this.batchSize);
            this.position += this.batchSize;
        }
        if (this.position >= allResultsSize) {
            this.expectMoreResults = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\nFetched next set of results: \n   Total results count: " + allResultsSize + "\n" + "   Batch size:          " + batchedResults.length + "\n" + "   New Position:        " + this.position));
        }
        return batchedResults;
    }
}

