/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.transaction.UserTransaction;
import javax.xml.rpc.server.ServletEndpointContext;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webservice.types.AssociationDefinition;
import org.alfresco.repo.webservice.types.Cardinality;
import org.alfresco.repo.webservice.types.ClassDefinition;
import org.alfresco.repo.webservice.types.NamedValue;
import org.alfresco.repo.webservice.types.ParentReference;
import org.alfresco.repo.webservice.types.Predicate;
import org.alfresco.repo.webservice.types.PropertyDefinition;
import org.alfresco.repo.webservice.types.Query;
import org.alfresco.repo.webservice.types.Reference;
import org.alfresco.repo.webservice.types.RoleDefinition;
import org.alfresco.repo.webservice.types.Store;
import org.alfresco.repo.webservice.types.Version;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class Utils {
    public static final int DEFAULT_BATCH_SIZE = 1000;
    public static final String REPOSITORY_SERVICE_NAMESPACE = "http://www.alfresco.org/ws/service/repository/1.0";
    private static Log logger = LogFactory.getLog(Utils.class);
    public static final String QUERY_LANG_LUCENE = "lucene";
    public static final String QUERY_LANG_XPATH = "xpath";
    public static final String QUERY_LANG_CQL = "cql";

    private Utils() {
    }

    public static Serializable getValueFromNamedValue(DictionaryService dictionaryService, QName propertyName, NamedValue namedValue) {
        Object result = null;
        if (namedValue != null) {
            org.alfresco.service.cmr.dictionary.PropertyDefinition propDef = dictionaryService.getProperty(propertyName);
            if (propDef == null) {
                if (!namedValue.getIsMultiValue().booleanValue()) {
                    result = namedValue.getValue();
                } else {
                    String[] values = namedValue.getValues();
                    if (values != null) {
                        ArrayList<String> collection = new ArrayList<String>(values.length);
                        for (String value : values) {
                            collection.add(value);
                        }
                        result = collection;
                    }
                }
            } else {
                DataTypeDefinition propertyType = propDef.getDataType();
                if (propertyType != null) {
                    if (!namedValue.getIsMultiValue().booleanValue()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Converting single-valued property '" + propertyName.toString() + "' with value " + namedValue.getValue()));
                        }
                        result = (Serializable)DefaultTypeConverter.INSTANCE.convert(propertyType, (Object)namedValue.getValue());
                    } else {
                        Object[] values = namedValue.getValues();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Converting multi-valued property '" + propertyName.toString() + "' with values " + Arrays.toString(values)));
                        }
                        if (values != null) {
                            ArrayList<Serializable> collection = new ArrayList<Serializable>(values.length);
                            for (Object value : values) {
                                collection.add((Serializable)DefaultTypeConverter.INSTANCE.convert(propertyType, value));
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("The collection for the multi-value property has been generated '" + ((Object)collection).toString()));
                            }
                            result = collection;
                        }
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No property definition was found for property '" + propertyName.toString() + "'"));
                }
            }
        }
        return result;
    }

    public static NamedValue createNamedValue(DictionaryService dictionaryService, QName propertyName, Serializable propertyValue) {
        NamedValue namedValue = new NamedValue();
        namedValue.setName(propertyName.toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating named value for property '" + propertyName + "' with value '" + propertyValue + "'"));
        }
        if (propertyValue != null) {
            org.alfresco.service.cmr.dictionary.PropertyDefinition propDef = dictionaryService.getProperty(propertyName);
            if (propDef != null) {
                if (propDef.isMultiValued()) {
                    namedValue.setIsMultiValue(true);
                    if (propertyValue instanceof Collection) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Converting multivalue for property '" + propertyName + "'"));
                        }
                        Collection collection = (Collection)((Object)propertyValue);
                        String[] values = new String[collection.size()];
                        int count = 0;
                        for (Serializable value : collection) {
                            values[count] = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
                            ++count;
                        }
                        namedValue.setValues(values);
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Converting single value for property '" + propertyName + "'"));
                    }
                    namedValue.setIsMultiValue(false);
                    namedValue.setValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)propertyValue));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No property definition found for property '" + propertyName + "'"));
                }
                namedValue.setIsMultiValue(false);
                namedValue.setValue(propertyValue.toString());
            }
        }
        return namedValue;
    }

    public static StoreRef convertToStoreRef(Store store) {
        return new StoreRef(store.getScheme(), store.getAddress());
    }

    public static Store convertToStore(StoreRef ref) {
        return new Store(ref.getProtocol(), ref.getIdentifier());
    }

    public static NodeRef convertToNodeRef(Reference ref, NodeService nodeService, SearchService searchService, NamespaceService namespaceService) {
        return Utils.resolveToNodeRef(ref.getStore(), ref.getUuid(), ref.getPath(), nodeService, searchService, namespaceService);
    }

    public static NodeRef convertToNodeRef(ParentReference parentRef, NodeService nodeService, SearchService searchService, NamespaceService namespaceService) {
        return Utils.resolveToNodeRef(parentRef.getStore(), parentRef.getUuid(), parentRef.getPath(), nodeService, searchService, namespaceService);
    }

    public static Reference convertToReference(NodeService nodeService, NamespaceService namespaceService, NodeRef node) {
        Reference ref = new Reference();
        Store store = new Store(node.getStoreRef().getProtocol(), node.getStoreRef().getIdentifier());
        ref.setStore(store);
        ref.setUuid(node.getId());
        if (nodeService.exists(node)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("setting path for reference to: " + nodeService.getPath(node).toPrefixString((NamespacePrefixResolver)namespaceService)));
            }
            ref.setPath(nodeService.getPath(node).toPrefixString((NamespacePrefixResolver)namespaceService));
        }
        return ref;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NodeRef resolveToNodeRef(Store store, String uuid, String path, NodeService nodeService, SearchService searchService, NamespaceService namespaceService) {
        NodeRef rootNodeRef;
        List nodes;
        if (store == null) {
            throw new IllegalArgumentException("A Store must be supplied to resolve to a NodeRef");
        }
        NodeRef nodeRef = null;
        if (uuid != null) {
            if (uuid.length() != 0) return new NodeRef(Utils.convertToStoreRef(store), uuid);
        }
        if (path == null) throw new IllegalArgumentException("A uuid or a path must be supplied to resolve to a NodeRef");
        if (path.length() == 0) throw new IllegalArgumentException("A uuid or a path must be supplied to resolve to a NodeRef");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolving path: " + path));
        }
        if ((nodes = searchService.selectNodes(rootNodeRef = nodeService.getRootNode(Utils.convertToStoreRef(store)), path, null, (NamespacePrefixResolver)namespaceService, false)).size() == 1) return (NodeRef)nodes.get(0);
        StringBuilder builder = new StringBuilder("Failed to resolve to a single NodeRef with parameters (store=");
        builder.append(store.getScheme()).append(":").append(store.getAddress());
        builder.append(" uuid=").append(uuid);
        builder.append(" path=").append(path).append("), found ");
        builder.append(nodes.size()).append(" nodes.");
        throw new IllegalStateException(builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NodeRef> resolvePredicate(Predicate predicate, NodeService nodeService, SearchService searchService, NamespaceService namespaceService) {
        List<Object> nodeRefs = null;
        if (predicate.getNodes() != null) {
            Reference[] nodes = predicate.getNodes();
            nodeRefs = new ArrayList<NodeRef>(nodes.length);
            for (int x = 0; x < nodes.length; ++x) {
                nodeRefs.add(Utils.convertToNodeRef(nodes[x], nodeService, searchService, namespaceService));
            }
        } else if (predicate.getQuery() != null) {
            Query query = predicate.getQuery();
            if (query == null) {
                throw new IllegalStateException("Either a set of nodes or a query must be supplied in a Predicate.");
            }
            if (predicate.getStore() == null) {
                throw new IllegalStateException("A Store has to be supplied to in order to execute a query.");
            }
            String language = query.getLanguage();
            if (!language.equals(QUERY_LANG_LUCENE)) {
                throw new IllegalArgumentException("Only 'lucene' queries are currently supported!");
            }
            ResultSet searchResults = null;
            try {
                searchResults = searchService.query(Utils.convertToStoreRef(predicate.getStore()), language, query.getStatement());
                nodeRefs = searchResults.getNodeRefs();
            }
            finally {
                if (searchResults != null) {
                    searchResults.close();
                }
            }
        } else if (predicate.getStore() != null) {
            Store store = predicate.getStore();
            NodeRef rootNode = nodeService.getRootNode(Utils.convertToStoreRef(store));
            nodeRefs = new ArrayList();
            nodeRefs.add(rootNode);
        }
        return nodeRefs;
    }

    public static WebApplicationContext getSpringContext(MessageContext msgContext) {
        HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        ServletContext servletCtx = req.getSession().getServletContext();
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletCtx);
    }

    public static UserTransaction getUserTransaction(MessageContext msgContext) {
        ServiceRegistry svcReg = (ServiceRegistry)Utils.getSpringContext(msgContext).getBean("ServiceRegistry");
        TransactionService transactionService = svcReg.getTransactionService();
        return transactionService.getUserTransaction();
    }

    public static RetryingTransactionHelper getRetryingTransactionHelper(MessageContext msgContext) {
        ServiceRegistry svcReg = (ServiceRegistry)Utils.getSpringContext(msgContext).getBean("ServiceRegistry");
        TransactionService transactionService = svcReg.getTransactionService();
        return transactionService.getRetryingTransactionHelper();
    }

    public static String getSessionId() {
        HttpSession session;
        String result = null;
        ServletEndpointContext endpointContext = (ServletEndpointContext)MessageContext.getCurrentContext().getProperty("servletEndpointContext");
        if (endpointContext != null && (session = endpointContext.getHttpSession()) != null) {
            result = session.getId();
        }
        return result;
    }

    public static int getBatchSize(MessageContext msgContext) {
        int batchSize = 1000;
        Integer batchConfigSize = (Integer)MessageContext.getCurrentContext().getProperty("ALF_FETCH_SIZE");
        if (batchConfigSize != null) {
            batchSize = batchConfigSize;
        }
        return batchSize;
    }

    public static Version convertToVersion(NodeService nodeService, NamespaceService namespaceService, org.alfresco.service.cmr.version.Version version) {
        Version webServiceVersion = new Version();
        webServiceVersion.setId(Utils.convertToReference(nodeService, namespaceService, version.getFrozenStateNodeRef()));
        webServiceVersion.setCreator(version.getCreator());
        webServiceVersion.setLabel(version.getVersionLabel());
        Date createdDate = version.getCreatedDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createdDate);
        webServiceVersion.setCreated(calendar);
        boolean isMajor = false;
        VersionType versionType = version.getVersionType();
        if (versionType != null && versionType.equals((Object)VersionType.MAJOR)) {
            isMajor = true;
        }
        webServiceVersion.setMajor(isMajor);
        Map versionProps = version.getVersionProperties();
        NamedValue[] namedValues = new NamedValue[versionProps.size()];
        int iIndex = 0;
        for (Map.Entry entry : versionProps.entrySet()) {
            String value = null;
            try {
                value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, entry.getValue());
            }
            catch (Throwable exception) {
                value = ((Serializable)entry.getValue()).toString();
            }
            namedValues[iIndex] = new NamedValue((String)entry.getKey(), false, value, null);
            ++iIndex;
        }
        webServiceVersion.setCommentaries(namedValues);
        return webServiceVersion;
    }

    public static ClassDefinition setupClassDefObject(org.alfresco.service.cmr.dictionary.ClassDefinition ddClassDef) {
        Map assocs;
        Map props;
        ClassDefinition classDef = new ClassDefinition();
        classDef.setName(ddClassDef.getName().toString());
        classDef.setIsAspect(ddClassDef.isAspect());
        if (ddClassDef.getTitle() != null) {
            classDef.setTitle(ddClassDef.getTitle());
        }
        if (ddClassDef.getDescription() != null) {
            classDef.setDescription(ddClassDef.getDescription());
        }
        if (ddClassDef.getParentName() != null) {
            classDef.setSuperClass(ddClassDef.getParentName().toString());
        }
        if ((props = ddClassDef.getProperties()) != null) {
            PropertyDefinition[] propDefs = new PropertyDefinition[props.size()];
            int pos = 0;
            for (org.alfresco.service.cmr.dictionary.PropertyDefinition ddPropDef : props.values()) {
                PropertyDefinition propDef;
                propDefs[pos] = propDef = Utils.setupPropertyDefObject(ddPropDef);
                ++pos;
            }
            classDef.setProperties(propDefs);
        }
        if ((assocs = ddClassDef.getAssociations()) != null) {
            AssociationDefinition[] assocDefs = new AssociationDefinition[assocs.size()];
            int pos = 0;
            for (org.alfresco.service.cmr.dictionary.AssociationDefinition ddAssocDef : assocs.values()) {
                AssociationDefinition assocDef;
                assocDefs[pos] = assocDef = Utils.setupAssociationDefObject(ddAssocDef);
                ++pos;
            }
            classDef.setAssociations(assocDefs);
        }
        return classDef;
    }

    public static PropertyDefinition setupPropertyDefObject(org.alfresco.service.cmr.dictionary.PropertyDefinition ddPropDef) {
        PropertyDefinition propDef = new PropertyDefinition();
        propDef.setName(ddPropDef.getName().toString());
        propDef.setDataType(ddPropDef.getDataType().getName().toString());
        propDef.setMandatory(ddPropDef.isMandatory());
        propDef.setReadOnly(ddPropDef.isProtected());
        if (ddPropDef.getDefaultValue() != null) {
            propDef.setDefaultValue(ddPropDef.getDefaultValue());
        }
        if (ddPropDef.getTitle() != null) {
            propDef.setTitle(ddPropDef.getTitle());
        }
        if (ddPropDef.getDescription() != null) {
            propDef.setDescription(ddPropDef.getDescription());
        }
        return propDef;
    }

    public static AssociationDefinition setupAssociationDefObject(org.alfresco.service.cmr.dictionary.AssociationDefinition ddAssocDef) {
        AssociationDefinition assocDef = new AssociationDefinition();
        assocDef.setName(ddAssocDef.getName().toString());
        assocDef.setIsChild(ddAssocDef.isChild());
        if (ddAssocDef.getTitle() != null) {
            assocDef.setTitle(ddAssocDef.getTitle());
        }
        if (ddAssocDef.getDescription() != null) {
            assocDef.setDescription(ddAssocDef.getDescription());
        }
        RoleDefinition sourceRole = new RoleDefinition();
        if (ddAssocDef.getSourceRoleName() != null) {
            sourceRole.setName(ddAssocDef.getSourceRoleName().toString());
        }
        sourceRole.setCardinality(Utils.setupSourceCardinalityObject(ddAssocDef));
        assocDef.setSourceRole(sourceRole);
        RoleDefinition targetRole = new RoleDefinition();
        if (ddAssocDef.getTargetRoleName() != null) {
            targetRole.setName(ddAssocDef.getTargetRoleName().toString());
        }
        targetRole.setCardinality(Utils.setupTargetCardinalityObject(ddAssocDef));
        assocDef.setTargetRole(targetRole);
        assocDef.setTargetClass(ddAssocDef.getTargetClass().getName().toString());
        return assocDef;
    }

    private static Cardinality setupSourceCardinalityObject(org.alfresco.service.cmr.dictionary.AssociationDefinition ddAssocDef) {
        if (!ddAssocDef.isSourceMandatory() && !ddAssocDef.isSourceMany()) {
            return Cardinality.value1;
        }
        if (ddAssocDef.isSourceMandatory() && !ddAssocDef.isSourceMany()) {
            return Cardinality.value2;
        }
        if (ddAssocDef.isSourceMandatory() && ddAssocDef.isSourceMany()) {
            return Cardinality.value4;
        }
        return Cardinality.value3;
    }

    private static Cardinality setupTargetCardinalityObject(org.alfresco.service.cmr.dictionary.AssociationDefinition ddAssocDef) {
        if (!ddAssocDef.isTargetMandatory() && !ddAssocDef.isTargetMany()) {
            return Cardinality.value1;
        }
        if (ddAssocDef.isTargetMandatory() && !ddAssocDef.isTargetMany()) {
            return Cardinality.value2;
        }
        if (ddAssocDef.isTargetMandatory() && ddAssocDef.isTargetMany()) {
            return Cardinality.value4;
        }
        return Cardinality.value3;
    }
}

