/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.administration;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webservice.AbstractWebService;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.action.ActionFault;
import org.alfresco.repo.webservice.administration.AdministrationFault;
import org.alfresco.repo.webservice.administration.AdministrationServiceSoapPort;
import org.alfresco.repo.webservice.administration.NewUserDetails;
import org.alfresco.repo.webservice.administration.UserDetails;
import org.alfresco.repo.webservice.administration.UserFilter;
import org.alfresco.repo.webservice.administration.UserQuery;
import org.alfresco.repo.webservice.administration.UserQueryResults;
import org.alfresco.repo.webservice.administration.UserQuerySession;
import org.alfresco.repo.webservice.repository.RepositoryFault;
import org.alfresco.repo.webservice.types.NamedValue;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdministrationWebService
extends AbstractWebService
implements AdministrationServiceSoapPort {
    private static Log logger = LogFactory.getLog(AdministrationWebService.class);
    private PersonService personService = null;
    private boolean manageAuthenticationDetails = true;
    private MutableAuthenticationService authenticationService = null;
    private AuthorityService authorityService;
    private TransactionService transactionService = null;
    private static Set<QName> ignoredProperties = new HashSet<QName>(3);

    public AdministrationWebService() {
        ignoredProperties.add(ContentModel.PROP_STORE_PROTOCOL);
        ignoredProperties.add(ContentModel.PROP_STORE_IDENTIFIER);
        ignoredProperties.add(ContentModel.PROP_NODE_UUID);
    }

    public void setManageAuthenticationDetails(boolean manageAuthenticationDetails) {
        this.manageAuthenticationDetails = manageAuthenticationDetails;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    @Override
    public UserQueryResults queryUsers(final UserFilter filter) throws RemoteException, AdministrationFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<UserQueryResults> callback = new RetryingTransactionHelper.RetryingTransactionCallback<UserQueryResults>(){

                public UserQueryResults execute() throws Exception {
                    return AdministrationWebService.this.queryUsersImpl(filter);
                }
            };
            return (UserQueryResults)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private UserQueryResults queryUsersImpl(UserFilter filter) {
        MessageContext msgContext = MessageContext.getCurrentContext();
        UserQuery query = new UserQuery(filter);
        UserQuerySession userQuerySession = new UserQuerySession(Long.MAX_VALUE, (long)Utils.getBatchSize(msgContext), query);
        UserQueryResults userQueryResults = userQuerySession.getNextResults(this.serviceRegistry);
        String querySessionId = userQuerySession.getId();
        boolean haveMoreResults = userQuerySession.haveMoreResults();
        if (haveMoreResults) {
            this.querySessionCache.put((Serializable)((Object)querySessionId), (Object)userQuerySession);
        }
        UserQueryResults result = new UserQueryResults(haveMoreResults ? querySessionId : null, userQueryResults.getUserDetails());
        return result;
    }

    @Override
    public UserQueryResults fetchMoreUsers(final String querySession) throws RemoteException, AdministrationFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<UserQueryResults> callback = new RetryingTransactionHelper.RetryingTransactionCallback<UserQueryResults>(){

                public UserQueryResults execute() throws Exception {
                    return AdministrationWebService.this.fetchMoreUsersImpl(querySession);
                }
            };
            return (UserQueryResults)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private UserQueryResults fetchMoreUsersImpl(String querySessionId) throws RepositoryFault {
        UserQuerySession session = null;
        try {
            session = (UserQuerySession)this.querySessionCache.get((Serializable)((Object)querySessionId));
        }
        catch (ClassCastException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Query session was not generated by the AdministrationWebService: " + querySessionId));
            }
            throw new RepositoryFault(4, "querySession with id '" + querySessionId + "' is invalid");
        }
        UserQueryResults queryResult = null;
        if (session != null) {
            queryResult = session.getNextResults(this.serviceRegistry);
            if (!session.haveMoreResults()) {
                this.querySessionCache.remove((Serializable)((Object)querySessionId));
            } else {
                this.querySessionCache.put((Serializable)((Object)querySessionId), (Object)session);
            }
        }
        return queryResult;
    }

    @Override
    public UserDetails getUser(final String userName) throws RemoteException, AdministrationFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<UserDetails> callback = new RetryingTransactionHelper.RetryingTransactionCallback<UserDetails>(){

                public UserDetails execute() throws Exception {
                    return AdministrationWebService.this.getUserImpl(userName);
                }
            };
            return (UserDetails)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private UserDetails getUserImpl(String userName) {
        NodeService nodeService = this.serviceRegistry.getNodeService();
        UserDetails userDetails = null;
        if (!this.personService.personExists(userName)) {
            throw new AlfrescoRuntimeException(MessageFormat.format("The user with name {0} does not exist.", userName));
        }
        NodeRef nodeRef = this.personService.getPerson(userName);
        userDetails = AdministrationWebService.createUserDetails(nodeService, userName, nodeRef);
        return userDetails;
    }

    static UserDetails createUserDetails(NodeService nodeService, String userName, NodeRef nodeRef) {
        UserDetails userDetails = new UserDetails();
        userDetails.setUserName(userName);
        Map properties = nodeService.getProperties(nodeRef);
        ArrayList<NamedValue> namedValues = new ArrayList<NamedValue>(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            if (ignoredProperties.contains(entry.getKey())) continue;
            String value = null;
            try {
                value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, entry.getValue());
            }
            catch (Throwable exception) {
                value = ((Serializable)entry.getValue()).toString();
            }
            NamedValue namedValue = new NamedValue();
            namedValue.setName(((QName)entry.getKey()).toString());
            namedValue.setIsMultiValue(false);
            namedValue.setValue(value);
            namedValues.add(namedValue);
        }
        userDetails.setProperties(namedValues.toArray(new NamedValue[namedValues.size()]));
        return userDetails;
    }

    @Override
    public UserDetails[] createUsers(final NewUserDetails[] newUsers) throws RemoteException, AdministrationFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<UserDetails[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<UserDetails[]>(){

                public UserDetails[] execute() throws Exception {
                    return AdministrationWebService.this.createUsersImpl(newUsers);
                }
            };
            return (UserDetails[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private UserDetails[] createUsersImpl(NewUserDetails[] newUsers) {
        NodeService nodeService = this.serviceRegistry.getNodeService();
        UserDetails[] userDetails = new UserDetails[newUsers.length];
        int index = 0;
        for (NewUserDetails newUser : newUsers) {
            if (this.manageAuthenticationDetails) {
                this.authenticationService.createAuthentication(newUser.getUserName(), newUser.getPassword().toCharArray());
            }
            HashMap<QName, String> properties = new HashMap<QName, String>(7);
            properties.put(ContentModel.PROP_USERNAME, newUser.getUserName());
            for (NamedValue namedValue : newUser.getProperties()) {
                properties.put(QName.createQName((String)namedValue.getName()), namedValue.getValue());
            }
            NodeRef personNodeRef = this.personService.createPerson(properties);
            userDetails[index] = AdministrationWebService.createUserDetails(nodeService, newUser.getUserName(), personNodeRef);
            ++index;
        }
        return userDetails;
    }

    @Override
    public UserDetails[] updateUsers(final UserDetails[] users) throws RemoteException, AdministrationFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<UserDetails[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<UserDetails[]>(){

                public UserDetails[] execute() throws Exception {
                    return AdministrationWebService.this.updateUsersImpl(users);
                }
            };
            return (UserDetails[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private UserDetails[] updateUsersImpl(UserDetails[] users) {
        NodeService nodeService = this.serviceRegistry.getNodeService();
        UserDetails[] userDetails = new UserDetails[users.length];
        int index = 0;
        for (UserDetails user : users) {
            HashMap<QName, String> properties = new HashMap<QName, String>(7);
            properties.put(ContentModel.PROP_USERNAME, user.getUserName());
            for (NamedValue namedValue : user.getProperties()) {
                properties.put(QName.createQName((String)namedValue.getName()), namedValue.getValue());
            }
            this.personService.setPersonProperties(user.getUserName(), properties);
            NodeRef nodeRef = this.personService.getPerson(user.getUserName());
            userDetails[index] = AdministrationWebService.createUserDetails(nodeService, user.getUserName(), nodeRef);
            ++index;
        }
        return userDetails;
    }

    @Override
    public void changePassword(final String userName, final String oldPassword, final String newPassword) throws RemoteException, AdministrationFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Exception {
                    AdministrationWebService.this.changePasswordImpl(userName, oldPassword, newPassword);
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private void changePasswordImpl(String userName, String oldPassword, String newPassword) {
        if (this.manageAuthenticationDetails) {
            if (this.authorityService.hasAdminAuthority()) {
                this.authenticationService.setAuthentication(userName, newPassword.toCharArray());
            } else {
                this.authenticationService.updateAuthentication(userName, oldPassword.toCharArray(), newPassword.toCharArray());
            }
        } else {
            throw new RuntimeException("Web service has been configured so that user authenticaiton details are not managed.");
        }
    }

    @Override
    public void deleteUsers(final String[] userNames) throws RemoteException, AdministrationFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Exception {
                    AdministrationWebService.this.deleteUsersImpl(userNames);
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private void deleteUsersImpl(String[] userNames) {
        for (String userName : userNames) {
            this.personService.deletePerson(userName);
        }
    }
}

