/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.authentication;

import java.rmi.RemoteException;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.authentication.AuthenticationFault;
import org.alfresco.repo.webservice.authentication.AuthenticationResult;
import org.alfresco.repo.webservice.authentication.AuthenticationServiceSoapPort;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationWebService
implements AuthenticationServiceSoapPort {
    private static Log logger = LogFactory.getLog(AuthenticationWebService.class);
    private AuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;

    public void setAuthenticationService(AuthenticationService authenticationSvc) {
        this.authenticationService = authenticationSvc;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    @Override
    public AuthenticationResult startSession(String username, String password) throws RemoteException, AuthenticationFault {
        try {
            this.authenticationService.authenticate(username, password.toCharArray());
            String ticket = this.authenticationService.getCurrentTicket();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Issued ticket '" + ticket + "' for '" + username + "'"));
            }
            return new AuthenticationResult(username, ticket, Utils.getSessionId());
        }
        catch (AuthenticationException ae) {
            ae.printStackTrace();
            throw new AuthenticationFault(100, ae.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new AuthenticationFault(0, e.getMessage());
        }
    }

    @Override
    public void endSession(final String ticket) throws RemoteException, AuthenticationFault {
        try {
            if (ticket != null) {
                RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    public Object execute() throws Throwable {
                        AuthenticationWebService.this.authenticationComponent.setSystemUserAsCurrentUser();
                        AuthenticationWebService.this.authenticationService.invalidateTicket(ticket);
                        AuthenticationWebService.this.authenticationService.clearCurrentSecurityContext();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Session ended for ticket '" + ticket + "'"));
                        }
                        return null;
                    }
                };
                Utils.getRetryingTransactionHelper(MessageContext.getCurrentContext()).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            }
        }
        catch (Throwable e) {
            throw new AuthenticationFault(0, e.getMessage());
        }
    }
}

