/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.axis;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.webservice.authentication.AuthenticationFault;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;

public class TicketCallbackHandler
implements CallbackHandler {
    private static final Log logger = LogFactory.getLog(TicketCallbackHandler.class);
    private AuthenticationService authenticationService;

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            WSPasswordCallback pc;
            if (callbacks[i] instanceof WSPasswordCallback) {
                pc = (WSPasswordCallback)callbacks[i];
                String ticket = pc.getPassword();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Verifying ticket for: " + pc.getIdentifer()));
                    logger.debug((Object)("Ticket: " + ticket));
                }
                try {
                    this.authenticationService.validate(ticket);
                }
                catch (AuthenticationException ae) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Ticket validation failed: " + ae.getMessage()));
                    }
                    throw new AuthenticationFault(701, "Authentication failed due to an invalid ticket");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Ticket validated successfully");
                }
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            pc.setPassword(pc.getPassword());
        }
    }
}

