/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.content;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webservice.AbstractWebService;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.content.Content;
import org.alfresco.repo.webservice.content.ContentFault;
import org.alfresco.repo.webservice.content.ContentServiceSoapPort;
import org.alfresco.repo.webservice.types.ContentFormat;
import org.alfresco.repo.webservice.types.Predicate;
import org.alfresco.repo.webservice.types.Reference;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentWebService
extends AbstractWebService
implements ContentServiceSoapPort {
    private static Log logger = LogFactory.getLog(ContentWebService.class);
    private static final String BROWSER_URL = "{0}://{1}{2}/download/direct/{3}/{4}/{5}/{6}";

    @Override
    public Content[] read(final Predicate items, final String property) throws RemoteException, ContentFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Content[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Content[]>(){

                public Content[] execute() throws Throwable {
                    List<NodeRef> nodes = Utils.resolvePredicate(items, ContentWebService.this.nodeService, ContentWebService.this.searchService, ContentWebService.this.namespaceService);
                    ArrayList<Content> results = new ArrayList<Content>(nodes.size());
                    for (NodeRef nodeRef : nodes) {
                        results.add(ContentWebService.this.createContent(nodeRef, property));
                    }
                    return results.toArray(new Content[results.size()]);
                }
            };
            return (Content[])Utils.getRetryingTransactionHelper(MessageContext.getCurrentContext()).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new ContentFault(0, e.getMessage());
        }
    }

    private Content createContent(NodeRef nodeRef, String property) throws UnsupportedEncodingException {
        Content content = null;
        ContentReader contentReader = this.contentService.getReader(nodeRef, QName.createQName((String)property));
        if (contentReader != null) {
            String filename;
            HttpServletRequest req = (HttpServletRequest)MessageContext.getCurrentContext().getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            String address = req.getServerName();
            if (req.getLocalPort() != 80) {
                address = address + ":" + req.getServerPort();
            }
            if ((filename = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME))) == null) {
                filename = "file.bin";
            }
            String downloadUrl = MessageFormat.format(BROWSER_URL, req.getScheme(), address, req.getContextPath(), nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId(), URLEncoder.encode(filename, "UTF-8"));
            ContentFormat format = new ContentFormat(contentReader.getMimetype(), contentReader.getEncoding());
            content = new Content(Utils.convertToReference(this.nodeService, this.namespaceService, nodeRef), property, contentReader.getSize(), format, downloadUrl);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Content: " + nodeRef.getId() + " name=" + filename + " encoding=" + content.getFormat().getEncoding() + " mimetype=" + content.getFormat().getMimetype() + " size=" + content.getLength() + " downloadURL=" + content.getUrl()));
            }
        } else {
            content = new Content(Utils.convertToReference(this.nodeService, this.namespaceService, nodeRef), property, 0L, null, null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No content found: " + nodeRef.getId()));
            }
        }
        return content;
    }

    @Override
    public Content write(final Reference node, final String property, final byte[] content, final ContentFormat format) throws RemoteException, ContentFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Content> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Content>(){

                public Content execute() throws Throwable {
                    NodeRef nodeRef = Utils.convertToNodeRef(node, ContentWebService.this.nodeService, ContentWebService.this.searchService, ContentWebService.this.namespaceService);
                    ContentWriter writer = ContentWebService.this.contentService.getWriter(nodeRef, QName.createQName((String)property), true);
                    if (format != null) {
                        writer.setEncoding(format.getEncoding());
                        writer.setMimetype(format.getMimetype());
                    }
                    ByteArrayInputStream is = new ByteArrayInputStream(content);
                    writer.putContent((InputStream)is);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Updated content for node with id: " + nodeRef.getId()));
                    }
                    return ContentWebService.this.createContent(nodeRef, property);
                }
            };
            return (Content)Utils.getRetryingTransactionHelper(MessageContext.getCurrentContext()).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new ContentFault(0, e.getMessage());
        }
    }

    @Override
    public Content writeWithAttachment(final Reference node, final String property, final ContentFormat format) throws RemoteException, ContentFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Content> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Content>(){

                public Content execute() throws Throwable {
                    AttachmentPart[] attachments = ContentWebService.this.getMessageAttachments();
                    if (attachments.length != 1) {
                        throw new AlfrescoRuntimeException("Expecting only one attachment");
                    }
                    NodeRef nodeRef = Utils.convertToNodeRef(node, ContentWebService.this.nodeService, ContentWebService.this.searchService, ContentWebService.this.namespaceService);
                    ContentWriter writer = ContentWebService.this.contentService.getWriter(nodeRef, QName.createQName((String)property), true);
                    if (format != null) {
                        writer.setEncoding(format.getEncoding());
                        writer.setMimetype(format.getMimetype());
                    }
                    DataHandler dh = attachments[0].getDataHandler();
                    InputStream is = dh.getInputStream();
                    writer.putContent(is);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Updated content for node with id: " + nodeRef.getId()));
                    }
                    return ContentWebService.this.createContent(nodeRef, property);
                }
            };
            return (Content)Utils.getRetryingTransactionHelper(MessageContext.getCurrentContext()).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new ContentFault(0, e.getMessage());
        }
    }

    private AttachmentPart[] getMessageAttachments() throws AxisFault {
        MessageContext msgContext = MessageContext.getCurrentContext();
        Message reqMsg = msgContext.getRequestMessage();
        Attachments messageAttachments = reqMsg.getAttachmentsImpl();
        if (null == messageAttachments) {
            return new AttachmentPart[0];
        }
        int attachmentCount = messageAttachments.getAttachmentCount();
        AttachmentPart[] attachments = new AttachmentPart[attachmentCount];
        Iterator it = messageAttachments.getAttachments().iterator();
        int count = 0;
        while (it.hasNext()) {
            AttachmentPart part = (AttachmentPart)it.next();
            attachments[count++] = part;
        }
        return attachments;
    }

    @Override
    public Content[] clear(final Predicate items, final String property) throws RemoteException, ContentFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Content[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Content[]>(){

                public Content[] execute() throws Throwable {
                    List<NodeRef> nodes = Utils.resolvePredicate(items, ContentWebService.this.nodeService, ContentWebService.this.searchService, ContentWebService.this.namespaceService);
                    Content[] contents = new Content[nodes.size()];
                    for (int x = 0; x < nodes.size(); ++x) {
                        NodeRef nodeRef = nodes.get(x);
                        ContentWebService.this.nodeService.setProperty(nodeRef, QName.createQName((String)property), null);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Cleared content node with id: " + nodeRef.getId()));
                        }
                        contents[x] = ContentWebService.this.createContent(nodeRef, property);
                    }
                    return contents;
                }
            };
            return (Content[])Utils.getRetryingTransactionHelper(MessageContext.getCurrentContext()).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new ContentFault(0, e.getMessage());
        }
    }

    @Override
    public Content transform(final Reference source, final String property, final Reference destinationReference, final String destinationProperty, final ContentFormat destinationFormat) throws RemoteException, ContentFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Content> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Content>(){

                public Content execute() throws Throwable {
                    NodeRef sourceNodeRef = Utils.convertToNodeRef(source, ContentWebService.this.nodeService, ContentWebService.this.searchService, ContentWebService.this.namespaceService);
                    NodeRef destinationNodeRef = Utils.convertToNodeRef(destinationReference, ContentWebService.this.nodeService, ContentWebService.this.searchService, ContentWebService.this.namespaceService);
                    QName sourceQName = QName.createQName((String)property);
                    QName destinationQName = QName.createQName((String)destinationProperty);
                    ContentReader contentReader = ContentWebService.this.contentService.getReader(sourceNodeRef, sourceQName);
                    if (contentReader == null) {
                        throw new AlfrescoRuntimeException("Source content does not exist.  Transform could not take place.");
                    }
                    ContentWriter contentWriter = ContentWebService.this.contentService.getWriter(destinationNodeRef, destinationQName, true);
                    contentWriter.setEncoding(destinationFormat.getEncoding());
                    contentWriter.setMimetype(destinationFormat.getMimetype());
                    TransformationOptions options = new TransformationOptions();
                    options.setSourceNodeRef(sourceNodeRef);
                    ContentWebService.this.contentService.transform(contentReader, contentWriter, options);
                    return ContentWebService.this.createContent(destinationNodeRef, destinationProperty);
                }
            };
            return (Content)Utils.getRetryingTransactionHelper(MessageContext.getCurrentContext()).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new ContentFault(0, e.getMessage());
        }
    }
}

