/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.dictionary;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.webservice.AbstractWebService;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.dictionary.ClassPredicate;
import org.alfresco.repo.webservice.dictionary.DictionaryFault;
import org.alfresco.repo.webservice.dictionary.DictionaryServiceSoapPort;
import org.alfresco.repo.webservice.types.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidClassException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DictionaryWebService
extends AbstractWebService
implements DictionaryServiceSoapPort {
    private static Log logger = LogFactory.getLog(DictionaryWebService.class);
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;

    @Override
    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    @Override
    public org.alfresco.repo.webservice.types.ClassDefinition[] getClasses(ClassPredicate types, ClassPredicate aspects) throws RemoteException, DictionaryFault {
        try {
            HashSet<ClassDefinition> classDefs = new HashSet<ClassDefinition>();
            classDefs.addAll(this.getClassDefs(types, false));
            classDefs.addAll(this.getClassDefs(aspects, true));
            ArrayList<org.alfresco.repo.webservice.types.ClassDefinition> wsClassDefs = new ArrayList<org.alfresco.repo.webservice.types.ClassDefinition>(classDefs.size());
            for (ClassDefinition classDef : classDefs) {
                wsClassDefs.add(Utils.setupClassDefObject(classDef));
            }
            return wsClassDefs.toArray(new org.alfresco.repo.webservice.types.ClassDefinition[wsClassDefs.size()]);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new DictionaryFault(0, e.getMessage());
        }
    }

    @Override
    public org.alfresco.repo.webservice.types.PropertyDefinition[] getProperties(String[] propertyNames) throws RemoteException, DictionaryFault {
        try {
            org.alfresco.repo.webservice.types.PropertyDefinition[] propDefs = new org.alfresco.repo.webservice.types.PropertyDefinition[propertyNames.length];
            int i = 0;
            for (String propertyName : propertyNames) {
                QName propertyQName = QName.createQName((String)propertyName, (NamespacePrefixResolver)this.namespaceService);
                PropertyDefinition ddPropDef = this.dictionaryService.getProperty(propertyQName);
                if (ddPropDef == null) {
                    throw new AlfrescoRuntimeException("Property propertyName does not exist.");
                }
                propDefs[i++] = Utils.setupPropertyDefObject(ddPropDef);
            }
            return propDefs;
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new DictionaryFault(0, e.getMessage());
        }
    }

    @Override
    public AssociationDefinition[] getAssociations(String[] associationNames) throws RemoteException, DictionaryFault {
        try {
            AssociationDefinition[] assocDefs = new AssociationDefinition[associationNames.length];
            int i = 0;
            for (String associationName : associationNames) {
                QName associationQName = QName.createQName((String)associationName, (NamespacePrefixResolver)this.namespaceService);
                org.alfresco.service.cmr.dictionary.AssociationDefinition ddAssocDef = this.dictionaryService.getAssociation(associationQName);
                if (ddAssocDef == null) {
                    throw new AlfrescoRuntimeException("Property propertyName does not exist.");
                }
                assocDefs[i++] = Utils.setupAssociationDefObject(ddAssocDef);
            }
            return assocDefs;
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new DictionaryFault(0, e.getMessage());
        }
    }

    @Override
    public boolean isSubClass(String className, String isSubClassOfName) throws RemoteException, DictionaryFault {
        try {
            QName classQName = QName.createQName((String)className, (NamespacePrefixResolver)this.namespaceService);
            QName isSubClassOfQName = QName.createQName((String)isSubClassOfName, (NamespacePrefixResolver)this.namespaceService);
            return this.dictionaryService.isSubClass(classQName, isSubClassOfQName);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new DictionaryFault(0, e.getMessage());
        }
    }

    private Set<ClassDefinition> getClassDefs(ClassPredicate predicate, boolean forAspects) {
        HashSet<ClassDefinition> classDefs;
        block6: {
            block5: {
                classDefs = new HashSet<ClassDefinition>();
                if (predicate == null) break block5;
                String[] predicateTypeNames = predicate.getNames();
                if (predicateTypeNames == null) break block6;
                for (String predicateTypeName : predicateTypeNames) {
                    QName classQName = QName.createQName((String)predicateTypeName, (NamespacePrefixResolver)this.namespaceService);
                    ClassDefinition classDef = this.dictionaryService.getClass(classQName);
                    if (classDef == null || classDef.isAspect() != forAspects) {
                        throw new InvalidClassException(classQName);
                    }
                    classDefs.add(classDef);
                }
                if (!predicate.isFollowSuperClass() && !predicate.isFollowSubClass()) break block6;
                HashSet<ClassDefinition> touchedClassDefs = new HashSet<ClassDefinition>();
                for (ClassDefinition classDef : classDefs) {
                    if (predicate.isFollowSuperClass()) {
                        this.getSuperClasses(classDef, touchedClassDefs, true);
                        continue;
                    }
                    if (!predicate.isFollowSubClass()) continue;
                    this.getSubClasses(classDef, touchedClassDefs, true);
                }
                classDefs.addAll(touchedClassDefs);
                break block6;
            }
            Collection classQNames = forAspects ? this.dictionaryService.getAllAspects() : this.dictionaryService.getAllTypes();
            for (QName classQName : classQNames) {
                classDefs.add(this.dictionaryService.getClass(classQName));
            }
        }
        return classDefs;
    }

    private void getSuperClasses(ClassDefinition classDef, Set<ClassDefinition> superClasses, boolean recurse) {
        QName superClass = classDef.getParentName();
        if (superClass != null) {
            ClassDefinition superClassDef = this.dictionaryService.getClass(superClass);
            superClasses.add(superClassDef);
            if (recurse) {
                this.getSuperClasses(superClassDef, superClasses, recurse);
            }
        }
    }

    private void getSubClasses(ClassDefinition classDef, Set<ClassDefinition> subClasses, boolean recurse) {
        QName superClass = classDef.getName();
        Collection subClassNames = classDef.isAspect() ? this.dictionaryService.getSubAspects(superClass, recurse) : this.dictionaryService.getSubTypes(superClass, recurse);
        for (QName subClass : subClassNames) {
            ClassDefinition subClassDef = this.dictionaryService.getClass(subClass);
            subClasses.add(subClassDef);
        }
    }
}

