/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.repository;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.webservice.AbstractQuery;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.types.NamedValue;
import org.alfresco.repo.webservice.types.Reference;
import org.alfresco.repo.webservice.types.ResultSet;
import org.alfresco.repo.webservice.types.ResultSetRow;
import org.alfresco.repo.webservice.types.ResultSetRowNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class ParentAssociationQuery
extends AbstractQuery<ResultSet> {
    private static final long serialVersionUID = -4157476722256947274L;
    private Reference node;

    public ParentAssociationQuery(Reference node) {
        this.node = node;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("ParentAssociationQuery").append("[ node=").append(this.node.getUuid()).append("]");
        return sb.toString();
    }

    @Override
    public ResultSet execute(ServiceRegistry serviceRegistry) {
        SearchService searchService = serviceRegistry.getSearchService();
        NodeService nodeService = serviceRegistry.getNodeService();
        DictionaryService dictionaryService = serviceRegistry.getDictionaryService();
        NamespaceService namespaceService = serviceRegistry.getNamespaceService();
        NodeRef nodeRef = Utils.convertToNodeRef(this.node, nodeService, searchService, namespaceService);
        List assocRefs = nodeService.getParentAssocs(nodeRef);
        int totalRows = assocRefs.size();
        ResultSet results = new ResultSet();
        ResultSetRow[] rows = new ResultSetRow[totalRows];
        int index = 0;
        for (ChildAssociationRef assocRef : assocRefs) {
            NodeRef parentNodeRef = assocRef.getParentRef();
            ResultSetRowNode rowNode = this.createResultSetRowNode(parentNodeRef, nodeService);
            Map props = nodeService.getProperties(parentNodeRef);
            NamedValue[] columns = new NamedValue[props.size() + 5];
            int col = 0;
            for (QName propName : props.keySet()) {
                columns[col] = Utils.createNamedValue(dictionaryService, propName, (Serializable)props.get(propName));
                ++col;
            }
            columns[col] = new NamedValue("associationType", Boolean.FALSE, assocRef.getTypeQName().toString(), null);
            columns[++col] = new NamedValue("associationName", Boolean.FALSE, assocRef.getQName().toString(), null);
            columns[++col] = new NamedValue("isPrimary", Boolean.FALSE, Boolean.toString(assocRef.isPrimary()), null);
            columns[++col] = new NamedValue("nthSibling", Boolean.FALSE, Integer.toString(assocRef.getNthSibling()), null);
            columns[++col] = Utils.createNamedValue(dictionaryService, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"path"), (Serializable)((Object)nodeService.getPath(parentNodeRef).toString()));
            ResultSetRow row = new ResultSetRow();
            row.setRowIndex(index);
            row.setNode(rowNode);
            row.setColumns(columns);
            rows[index] = row;
            ++index;
        }
        results.setRows(rows);
        results.setTotalRowCount(totalRows);
        return results;
    }
}

