/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.repository;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webservice.AbstractWebService;
import org.alfresco.repo.webservice.CMLUtil;
import org.alfresco.repo.webservice.ServerQuery;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.repository.Association;
import org.alfresco.repo.webservice.repository.AssociationQuery;
import org.alfresco.repo.webservice.repository.ChildAssociationQuery;
import org.alfresco.repo.webservice.repository.ParentAssociationQuery;
import org.alfresco.repo.webservice.repository.QueryResult;
import org.alfresco.repo.webservice.repository.RepositoryFault;
import org.alfresco.repo.webservice.repository.RepositoryQuerySession;
import org.alfresco.repo.webservice.repository.RepositoryServiceSoapPort;
import org.alfresco.repo.webservice.repository.SearchQuery;
import org.alfresco.repo.webservice.repository.UpdateResult;
import org.alfresco.repo.webservice.types.CML;
import org.alfresco.repo.webservice.types.NamedValue;
import org.alfresco.repo.webservice.types.Node;
import org.alfresco.repo.webservice.types.NodeDefinition;
import org.alfresco.repo.webservice.types.Predicate;
import org.alfresco.repo.webservice.types.Query;
import org.alfresco.repo.webservice.types.Reference;
import org.alfresco.repo.webservice.types.ResultSet;
import org.alfresco.repo.webservice.types.Store;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryWebService
extends AbstractWebService
implements RepositoryServiceSoapPort {
    private static Log logger = LogFactory.getLog(RepositoryWebService.class);
    private CMLUtil cmlUtil;

    public void setCmlUtil(CMLUtil cmlUtil) {
        this.cmlUtil = cmlUtil;
    }

    @Override
    public Store createStore(String scheme, String address) throws RemoteException, RepositoryFault {
        StoreRef storeRef = this.nodeService.createStore(scheme, address);
        return Utils.convertToStore(storeRef);
    }

    @Override
    public Store[] getStores() throws RemoteException, RepositoryFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Store[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Store[]>(){

                public Store[] execute() throws Throwable {
                    List stores = RepositoryWebService.this.nodeService.getStores();
                    Store[] returnStores = new Store[stores.size()];
                    for (int x = 0; x < stores.size(); ++x) {
                        Store store;
                        StoreRef storeRef = (StoreRef)stores.get(x);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Store protocol :" + storeRef.getProtocol()));
                        }
                        returnStores[x] = store = Utils.convertToStore(storeRef);
                    }
                    return returnStores;
                }
            };
            return (Store[])Utils.getRetryingTransactionHelper(MessageContext.getCurrentContext()).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new RepositoryFault(0, e.toString());
        }
    }

    private QueryResult executeQuery(final MessageContext msgContext, final ServerQuery<ResultSet> query) throws RepositoryFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<QueryResult> callback = new RetryingTransactionHelper.RetryingTransactionCallback<QueryResult>(){

                public QueryResult execute() throws Throwable {
                    long batchSize = Utils.getBatchSize(msgContext);
                    RepositoryQuerySession session = new RepositoryQuerySession(Long.MAX_VALUE, batchSize, query);
                    String sessionId = session.getId();
                    ResultSet batchedResults = session.getNextResults(RepositoryWebService.this.serviceRegistry);
                    boolean haveMoreResults = session.haveMoreResults();
                    QueryResult queryResult = new QueryResult(haveMoreResults ? sessionId : null, batchedResults);
                    if (session.haveMoreResults()) {
                        RepositoryWebService.this.querySessionCache.put((Serializable)((Object)sessionId), (Object)session);
                    }
                    return queryResult;
                }
            };
            return (QueryResult)Utils.getRetryingTransactionHelper(MessageContext.getCurrentContext()).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            e.printStackTrace();
            throw new RepositoryFault(0, e.toString());
        }
    }

    @Override
    public QueryResult query(Store store, Query query, boolean includeMetaData) throws RemoteException, RepositoryFault {
        String language = query.getLanguage();
        if (!language.equals("lucene")) {
            throw new RepositoryFault(110, "Only 'lucene' queries are currently supported!");
        }
        MessageContext msgContext = MessageContext.getCurrentContext();
        SearchQuery serverQuery = new SearchQuery(store, query);
        QueryResult queryResult = this.executeQuery(msgContext, serverQuery);
        return queryResult;
    }

    @Override
    public QueryResult queryChildren(Reference node) throws RemoteException, RepositoryFault {
        MessageContext msgContext = MessageContext.getCurrentContext();
        ChildAssociationQuery query = new ChildAssociationQuery(node);
        QueryResult queryResult = this.executeQuery(msgContext, query);
        return queryResult;
    }

    @Override
    public QueryResult queryParents(Reference node) throws RemoteException, RepositoryFault {
        MessageContext msgContext = MessageContext.getCurrentContext();
        ParentAssociationQuery query = new ParentAssociationQuery(node);
        QueryResult queryResult = this.executeQuery(msgContext, query);
        return queryResult;
    }

    @Override
    public QueryResult queryAssociated(Reference node, Association association) throws RemoteException, RepositoryFault {
        MessageContext msgContext = MessageContext.getCurrentContext();
        AssociationQuery query = new AssociationQuery(node, association);
        QueryResult queryResult = this.executeQuery(msgContext, query);
        return queryResult;
    }

    @Override
    public QueryResult fetchMore(final String querySessionId) throws RemoteException, RepositoryFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<QueryResult> callback = new RetryingTransactionHelper.RetryingTransactionCallback<QueryResult>(){

                public QueryResult execute() throws Throwable {
                    RepositoryQuerySession session = null;
                    try {
                        session = (RepositoryQuerySession)RepositoryWebService.this.querySessionCache.get((Serializable)((Object)querySessionId));
                    }
                    catch (ClassCastException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Query session was not generated by the RepositoryWebService: " + querySessionId));
                        }
                        throw new RepositoryFault(4, "querySession with id '" + querySessionId + "' is invalid");
                    }
                    if (session == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Invalid querySession id requested: " + querySessionId));
                        }
                        throw new RepositoryFault(4, "querySession with id '" + querySessionId + "' is invalid");
                    }
                    ResultSet moreResults = session.getNextResults(RepositoryWebService.this.serviceRegistry);
                    if (!session.haveMoreResults()) {
                        RepositoryWebService.this.querySessionCache.remove((Serializable)((Object)querySessionId));
                    } else {
                        RepositoryWebService.this.querySessionCache.put((Serializable)((Object)querySessionId), (Object)session);
                    }
                    boolean haveMoreResults = session.haveMoreResults();
                    QueryResult queryResult = new QueryResult(haveMoreResults ? querySessionId : null, moreResults);
                    return queryResult;
                }
            };
            return (QueryResult)Utils.getRetryingTransactionHelper(MessageContext.getCurrentContext()).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
        }
        catch (Throwable e) {
            if (e instanceof RepositoryFault) {
                throw (RepositoryFault)((Object)e);
            }
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new RepositoryFault(0, e.toString());
        }
    }

    @Override
    public UpdateResult[] update(final CML statements) throws RemoteException, RepositoryFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<UpdateResult[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<UpdateResult[]>(){

                public UpdateResult[] execute() throws Throwable {
                    return RepositoryWebService.this.cmlUtil.executeCML(statements);
                }
            };
            return (UpdateResult[])Utils.getRetryingTransactionHelper(MessageContext.getCurrentContext()).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new RepositoryFault(0, e.toString());
        }
    }

    @Override
    public NodeDefinition[] describe(final Predicate items) throws RemoteException, RepositoryFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<NodeDefinition[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeDefinition[]>(){

                public NodeDefinition[] execute() throws Throwable {
                    List<NodeRef> nodes = Utils.resolvePredicate(items, RepositoryWebService.this.nodeService, RepositoryWebService.this.searchService, RepositoryWebService.this.namespaceService);
                    NodeDefinition[] nodeDefs = new NodeDefinition[nodes.size()];
                    for (int x = 0; x < nodes.size(); ++x) {
                        nodeDefs[x] = RepositoryWebService.this.setupNodeDefObject(nodes.get(x));
                    }
                    return nodeDefs;
                }
            };
            return (NodeDefinition[])Utils.getRetryingTransactionHelper(MessageContext.getCurrentContext()).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new RepositoryFault(0, e.toString());
        }
    }

    private NodeDefinition setupNodeDefObject(NodeRef nodeRef) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Building NodeDefinition for node: " + nodeRef));
        }
        TypeDefinition ddTypeDef = this.dictionaryService.getType(this.nodeService.getType(nodeRef));
        org.alfresco.repo.webservice.types.ClassDefinition typeDef = Utils.setupClassDefObject((ClassDefinition)ddTypeDef);
        Set aspectsQNames = this.nodeService.getAspects(nodeRef);
        org.alfresco.repo.webservice.types.ClassDefinition[] aspectDefs = new org.alfresco.repo.webservice.types.ClassDefinition[aspectsQNames.size()];
        int pos = 0;
        for (QName aspectQName : aspectsQNames) {
            AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectQName);
            aspectDefs[pos] = Utils.setupClassDefObject((ClassDefinition)aspectDef);
            ++pos;
        }
        return new NodeDefinition(typeDef, aspectDefs);
    }

    @Override
    public Node[] get(final Predicate where) throws RemoteException, RepositoryFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Node[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Node[]>(){

                public Node[] execute() throws Throwable {
                    List<NodeRef> nodeRefs = Utils.resolvePredicate(where, RepositoryWebService.this.nodeService, RepositoryWebService.this.searchService, RepositoryWebService.this.namespaceService);
                    ArrayList<Node> nodeList = new ArrayList<Node>();
                    for (NodeRef nodeRef : nodeRefs) {
                        if (!RepositoryWebService.this.nodeService.exists(nodeRef) && logger.isDebugEnabled()) {
                            logger.warn((Object)("Search returned node that doesn't exist: " + nodeRef));
                        }
                        Reference reference = Utils.convertToReference(RepositoryWebService.this.nodeService, RepositoryWebService.this.namespaceService, nodeRef);
                        String type = RepositoryWebService.this.nodeService.getType(nodeRef).toString();
                        Set aspectQNames = RepositoryWebService.this.nodeService.getAspects(nodeRef);
                        String[] aspects = new String[aspectQNames.size()];
                        int aspectIndex = 0;
                        for (QName aspectQName : aspectQNames) {
                            aspects[aspectIndex] = aspectQName.toString();
                            ++aspectIndex;
                        }
                        Map propertyMap = RepositoryWebService.this.nodeService.getProperties(nodeRef);
                        NamedValue[] properties = new NamedValue[propertyMap.size()];
                        int propertyIndex = 0;
                        for (Map.Entry entry : propertyMap.entrySet()) {
                            properties[propertyIndex] = Utils.createNamedValue(RepositoryWebService.this.dictionaryService, (QName)entry.getKey(), (Serializable)entry.getValue());
                            ++propertyIndex;
                        }
                        Node node = new Node(reference, type, aspects, properties);
                        nodeList.add(node);
                    }
                    Node[] nodes = nodeList.toArray(new Node[nodeList.size()]);
                    return nodes;
                }
            };
            return (Node[])Utils.getRetryingTransactionHelper(MessageContext.getCurrentContext()).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new RepositoryFault(0, e.toString());
        }
    }
}

