/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.alfresco.repo.webservice.AbstractQuery;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.types.NamedValue;
import org.alfresco.repo.webservice.types.Query;
import org.alfresco.repo.webservice.types.ResultSetRowNode;
import org.alfresco.repo.webservice.types.Store;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;

public class SearchQuery
extends AbstractQuery<org.alfresco.repo.webservice.types.ResultSet> {
    private static final long serialVersionUID = 5429510102265380433L;
    private Store store;
    private Query query;

    public SearchQuery(Store store, Query query) {
        this.store = store;
        this.query = query;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("SearchQuery").append("[ store=").append(this.store.getScheme()).append(":").append(this.store.getAddress()).append(" language=").append(this.query.getLanguage()).append(" statement=").append(this.query.getStatement()).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.alfresco.repo.webservice.types.ResultSet execute(ServiceRegistry serviceRegistry) {
        SearchService searchService = serviceRegistry.getSearchService();
        NodeService nodeService = serviceRegistry.getNodeService();
        DictionaryService dictionaryService = serviceRegistry.getDictionaryService();
        String statement = this.query.getStatement();
        if (statement.equals("*")) {
            statement = "ISNODE:*";
        }
        ResultSet searchResults = null;
        try {
            StoreRef storeRef = Utils.convertToStoreRef(this.store);
            searchResults = searchService.query(storeRef, this.query.getLanguage(), statement);
            org.alfresco.repo.webservice.types.ResultSet resultSet = this.convert(nodeService, dictionaryService, searchResults);
            return resultSet;
        }
        finally {
            if (searchResults != null) {
                try {
                    searchResults.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    private org.alfresco.repo.webservice.types.ResultSet convert(NodeService nodeService, DictionaryService dictionaryService, ResultSet searchResults) {
        org.alfresco.repo.webservice.types.ResultSet results = new org.alfresco.repo.webservice.types.ResultSet();
        ArrayList<org.alfresco.repo.webservice.types.ResultSetRow> rowsList = new ArrayList<org.alfresco.repo.webservice.types.ResultSetRow>();
        int index = 0;
        for (ResultSetRow searchRow : searchResults) {
            NodeRef nodeRef = searchRow.getNodeRef();
            if (!nodeService.exists(nodeRef)) continue;
            ResultSetRowNode rowNode = this.createResultSetRowNode(nodeRef, nodeService);
            Map values = searchRow.getValues();
            NamedValue[] columns = new NamedValue[values.size() + 1];
            int col = 1;
            for (String attributeName : values.keySet()) {
                columns[col] = Utils.createNamedValue(dictionaryService, QName.createQName((String)attributeName), (Serializable)values.get(attributeName));
                ++col;
            }
            columns[0] = Utils.createNamedValue(dictionaryService, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"path"), (Serializable)((Object)nodeService.getPath(nodeRef).toString()));
            org.alfresco.repo.webservice.types.ResultSetRow row = new org.alfresco.repo.webservice.types.ResultSetRow();
            row.setColumns(columns);
            row.setScore(Float.valueOf(searchRow.getScore()));
            row.setRowIndex(index);
            row.setNode(rowNode);
            rowsList.add(row);
            ++index;
        }
        int totalRows = rowsList.size();
        org.alfresco.repo.webservice.types.ResultSetRow[] rows = rowsList.toArray(new org.alfresco.repo.webservice.types.ResultSetRow[totalRows]);
        results.setRows(rows);
        results.setTotalRowCount(totalRows);
        return results;
    }
}

