/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.slingshot.web.scripts;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ISO9075;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class NodeBrowserScript
extends DeclarativeWebScript {
    private static List<String> queryLanguages = new ArrayList<String>();
    private transient List<StoreRef> stores = null;
    private transient TransactionService transactionService;
    private transient NodeService nodeService;
    private transient DictionaryService dictionaryService;
    private transient SearchService searchService;
    private transient NamespaceService namespaceService;
    private transient PermissionService permissionService;
    private transient OwnableService ownableService;
    private transient AVMService avmService;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    private TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    private NodeService getNodeService() {
        return this.nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    private SearchService getSearchService() {
        return this.searchService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    private DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    private NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    private PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public OwnableService getOwnableService() {
        return this.ownableService;
    }

    public void setAVMService(AVMService avmService) {
        this.avmService = avmService;
    }

    private AVMService getAVMService() {
        return this.avmService;
    }

    public List<StoreRef> getStores() {
        if (this.stores == null) {
            this.stores = this.getNodeService().getStores();
        }
        return this.stores;
    }

    public QName getNodeType(NodeRef nodeRef) {
        return this.getNodeService().getType(nodeRef);
    }

    public String getPrimaryPath(NodeRef nodeRef) {
        Path primaryPath = this.getNodeService().getPath(nodeRef);
        return ISO9075.decode((String)primaryPath.toString());
    }

    public String getPrimaryPrefixedPath(NodeRef nodeRef) {
        Path primaryPath = this.getNodeService().getPath(nodeRef);
        return ISO9075.decode((String)primaryPath.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
    }

    public NodeRef getPrimaryParent(NodeRef nodeRef) {
        Path primaryPath = this.getNodeService().getPath(nodeRef);
        Path.Element element = primaryPath.last();
        NodeRef parentRef = ((Path.ChildAssocElement)element).getRef().getParentRef();
        return parentRef;
    }

    public List<Aspect> getAspects(NodeRef nodeRef) {
        Set qnames = this.getNodeService().getAspects(nodeRef);
        ArrayList<Aspect> aspects = new ArrayList<Aspect>(qnames.size());
        for (QName qname : qnames) {
            aspects.add(new Aspect(qname));
        }
        return aspects;
    }

    public List<ChildAssociation> getParents(NodeRef nodeRef) {
        List parents = this.getNodeService().getParentAssocs(nodeRef);
        ArrayList<ChildAssociation> assocs = new ArrayList<ChildAssociation>(parents.size());
        for (ChildAssociationRef ref : parents) {
            assocs.add(new ChildAssociation(ref));
        }
        return assocs;
    }

    public List<Property> getProperties(NodeRef nodeRef) {
        Map propertyValues = this.getNodeService().getProperties(nodeRef);
        ArrayList<Property> properties = new ArrayList<Property>(propertyValues.size());
        for (Map.Entry property : propertyValues.entrySet()) {
            properties.add(new Property((QName)property.getKey(), (Serializable)property.getValue()));
        }
        return properties;
    }

    public boolean getInheritPermissions(NodeRef nodeRef) {
        Boolean inheritPermissions = this.getPermissionService().getInheritParentPermissions(nodeRef);
        return inheritPermissions;
    }

    public List<Permission> getPermissions(NodeRef nodeRef) {
        ArrayList<Permission> permissions = null;
        AccessStatus readPermissions = this.getPermissionService().hasPermission(nodeRef, "ReadPermissions");
        if (readPermissions.equals((Object)AccessStatus.ALLOWED)) {
            ArrayList<Permission> nodePermissions = new ArrayList<Permission>();
            for (AccessPermission ap : this.getPermissionService().getAllSetPermissions(nodeRef)) {
                nodePermissions.add(new Permission(ap.getPermission(), ap.getAuthority(), ap.getAccessStatus().toString()));
            }
            permissions = nodePermissions;
        } else {
            ArrayList<Permission> noReadPermissions = new ArrayList<Permission>(1);
            noReadPermissions.add(new NoReadPermissionGranted());
            permissions = noReadPermissions;
        }
        return permissions;
    }

    public List<Permission> getStorePermissionMasks(NodeRef nodeRef) {
        ArrayList<Permission> permissionMasks = null;
        if (nodeRef.getStoreRef().getProtocol().equals("avm")) {
            permissionMasks = new ArrayList<Permission>();
            for (AccessPermission ap : this.getPermissionService().getAllSetPermissions(nodeRef.getStoreRef())) {
                permissionMasks.add(new Permission(ap.getPermission(), ap.getAuthority(), ap.getAccessStatus().toString()));
            }
        } else {
            permissionMasks = new ArrayList(1);
            permissionMasks.add(new NoStoreMask());
        }
        return permissionMasks;
    }

    public List<ChildAssociation> getChildren(NodeRef nodeRef) {
        List refs = this.getNodeService().getChildAssocs(nodeRef);
        ArrayList<ChildAssociation> assocs = new ArrayList<ChildAssociation>(refs.size());
        for (ChildAssociationRef ref : refs) {
            assocs.add(new ChildAssociation(ref));
        }
        return assocs;
    }

    public List<PeerAssociation> getAssocs(NodeRef nodeRef) {
        List refs = null;
        try {
            refs = this.getNodeService().getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
        }
        catch (UnsupportedOperationException err) {
            // empty catch block
        }
        ArrayList<PeerAssociation> assocs = new ArrayList<PeerAssociation>(refs.size());
        for (AssociationRef ref : refs) {
            assocs.add(new PeerAssociation(ref.getTypeQName(), ref.getSourceRef(), ref.getTargetRef()));
        }
        return assocs;
    }

    public List<PeerAssociation> getSourceAssocs(NodeRef nodeRef) {
        List refs = null;
        try {
            refs = this.getNodeService().getSourceAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
        }
        catch (UnsupportedOperationException err) {
            // empty catch block
        }
        ArrayList<PeerAssociation> assocs = new ArrayList<PeerAssociation>(refs.size());
        for (AssociationRef ref : refs) {
            assocs.add(new PeerAssociation(ref.getTypeQName(), ref.getSourceRef(), ref.getTargetRef()));
        }
        return assocs;
    }

    public boolean getInAVMStore(NodeRef nodeRef) {
        return nodeRef.getStoreRef().getProtocol().equals("avm");
    }

    public List<Map<String, String>> getAVMStoreProperties(NodeRef nodeRef) {
        ArrayList<Map<String, String>> avmStoreProps = null;
        String store = nodeRef.getStoreRef().getIdentifier();
        Map props = this.getAVMService().getStoreProperties(store);
        ArrayList<Map<String, String>> storeProperties = new ArrayList<Map<String, String>>();
        for (Map.Entry property : props.entrySet()) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("name", ((QName)property.getKey()).toString());
            map.put("type", ((PropertyValue)property.getValue()).getActualTypeString());
            String val = ((PropertyValue)property.getValue()).getStringValue();
            if (val == null) {
                val = "null";
            }
            map.put("value", val);
            storeProperties.add(map);
        }
        avmStoreProps = storeProperties;
        return avmStoreProps;
    }

    public List<Node> submitSearch(String store, final String query, final String queryLanguage) throws IOException {
        final StoreRef storeRef = new StoreRef(store);
        RetryingTransactionHelper.RetryingTransactionCallback<List<Node>> searchCallback = new RetryingTransactionHelper.RetryingTransactionCallback<List<Node>>(){

            public List<Node> execute() throws Throwable {
                ArrayList<Node> searchResults = null;
                if (queryLanguage.equals("noderef")) {
                    NodeRef nodeRef = new NodeRef(query);
                    boolean exists = NodeBrowserScript.this.getNodeService().exists(nodeRef);
                    if (!exists) {
                        throw new WebScriptException(500, "Node " + nodeRef + " does not exist.");
                    }
                    searchResults = new ArrayList(1);
                    searchResults.add(new Node(nodeRef));
                    return searchResults;
                }
                List nodeRefs = NodeBrowserScript.this.getSearchService().query(storeRef, queryLanguage, query).getNodeRefs();
                searchResults = new ArrayList<Node>(nodeRefs.size());
                for (NodeRef nodeRef : nodeRefs) {
                    searchResults.add(new Node(nodeRef));
                }
                return searchResults;
            }
        };
        try {
            return (List)this.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)searchCallback, true);
        }
        catch (Throwable e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        if (req.getPathInfo().equals("/slingshot/node/search")) {
            HashMap<String, Object> tmplMap = new HashMap<String, Object>(1);
            try {
                if (req.getParameter("store") == null || req.getParameter("store").length() == 0) {
                    status.setCode(400);
                    status.setMessage("Store name not provided");
                    status.setRedirect(true);
                    return null;
                }
                if (req.getParameter("q") == null || req.getParameter("q").length() == 0) {
                    status.setCode(400);
                    status.setMessage("Search query not provided");
                    status.setRedirect(true);
                    return null;
                }
                if (req.getParameter("lang") == null || req.getParameter("lang").length() == 0) {
                    status.setCode(400);
                    status.setMessage("Search language not provided");
                    status.setRedirect(true);
                    return null;
                }
                List<Node> nodes = this.submitSearch(req.getParameter("store"), req.getParameter("q"), req.getParameter("lang"));
                tmplMap.put("results", nodes);
            }
            catch (IOException e) {
                status.setCode(500);
                status.setMessage(e.getMessage());
                status.setException((Throwable)e);
                status.setRedirect(true);
            }
            return tmplMap;
        }
        if (req.getPathInfo().equals("/slingshot/node/stores")) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("stores", this.getStores());
            return model;
        }
        Map templateVars = req.getServiceMatch().getTemplateVars();
        if (templateVars.get("protocol") == null || ((String)templateVars.get("protocol")).length() == 0 || templateVars.get("store") == null || ((String)templateVars.get("store")).length() == 0 || templateVars.get("id") == null || ((String)templateVars.get("id")).length() == 0) {
            status.setCode(400);
            status.setMessage("Node not provided");
            status.setRedirect(true);
            return null;
        }
        NodeRef nodeRef = new NodeRef((String)templateVars.get("protocol"), (String)templateVars.get("store"), (String)templateVars.get("id"));
        HashMap<String, Object> permissionInfo = new HashMap<String, Object>(3);
        permissionInfo.put("entries", this.getPermissions(nodeRef));
        permissionInfo.put("owner", this.getOwnableService().getOwner(nodeRef));
        permissionInfo.put("inherit", this.getInheritPermissions(nodeRef));
        permissionInfo.put("entries", this.getPermissions(nodeRef));
        permissionInfo.put("storePermissions", this.getStorePermissionMasks(nodeRef));
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("node", new Node(nodeRef));
        model.put("properties", this.getProperties(nodeRef));
        model.put("aspects", this.getAspects(nodeRef));
        model.put("children", this.getChildren(nodeRef));
        model.put("parents", this.getParents(nodeRef));
        model.put("assocs", this.getAssocs(nodeRef));
        model.put("sourceAssocs", this.getSourceAssocs(nodeRef));
        model.put("permissions", permissionInfo);
        return model;
    }

    static {
        queryLanguages.add("noderef");
        queryLanguages.add("xpath");
        queryLanguages.add("lucene");
        queryLanguages.add("fts-alfresco");
        queryLanguages.add("cmis-strict");
        queryLanguages.add("cmis-alfresco");
        queryLanguages.add("jcr-xpath");
    }

    public static class NoStoreMask
    extends Permission {
        public NoStoreMask() {
            super("All <No Mask>", "All", "Allowed");
        }
    }

    public static class NoReadPermissionGranted
    extends Permission {
        public NoReadPermissionGranted() {
            super("ReadPermissions", "[Current Authority]", "Not Granted");
        }
    }

    public static class Permission {
        private String permission;
        private String authority;
        private String accessStatus;

        public Permission(String permission, String authority, String accessStatus) {
            this.permission = permission;
            this.authority = authority;
            this.accessStatus = accessStatus;
        }

        public String getPermission() {
            return this.permission;
        }

        public void setPermission(String permission) {
            this.permission = permission;
        }

        public String getAuthority() {
            return this.authority;
        }

        public void setAuthority(String authority) {
            this.authority = authority;
        }

        public String getAccessStatus() {
            return this.accessStatus;
        }

        public void setAccessStatus(String accessStatus) {
            this.accessStatus = accessStatus;
        }
    }

    public class Property {
        private QNameBean name;
        private boolean isCollection = false;
        private List<Value> values;
        private boolean residual;
        private QNameBean typeName;

        public Property(QName qname, Serializable value) {
            List<Object> values;
            this.name = new QNameBean(qname);
            PropertyDefinition propDef = NodeBrowserScript.this.getDictionaryService().getProperty(qname);
            if (propDef != null) {
                QName qn = propDef.getDataType().getName();
                this.typeName = qn != null ? new QNameBean(propDef.getDataType().getName()) : null;
                this.residual = false;
            } else {
                this.residual = true;
            }
            if (value instanceof Collection) {
                Collection oldValues = (Collection)((Object)value);
                values = new ArrayList(oldValues.size());
                this.isCollection = true;
                for (Serializable multiValue : oldValues) {
                    values.add(new Value(multiValue instanceof QName ? new QNameBean((QName)multiValue) : multiValue));
                }
            } else {
                values = Collections.singletonList(new Value(value instanceof QName ? new QNameBean((QName)value) : value));
            }
            this.values = values;
        }

        public QNameBean getName() {
            return this.name;
        }

        public QNameBean getTypeName() {
            return this.typeName;
        }

        public String getPrefixedName() {
            return this.name.getPrefixedName();
        }

        public List<Value> getValues() {
            return this.values;
        }

        public boolean getResidual() {
            return this.residual;
        }

        public boolean isAny() {
            return this.getTypeName() == null ? false : this.getTypeName().getName().equals(DataTypeDefinition.ANY.toString());
        }

        public boolean isCollection() {
            return this.isCollection;
        }

        public class Value {
            private Serializable value;

            public Value(Serializable value) {
                this.value = value;
            }

            public Serializable getValue() {
                return this.value;
            }

            public String getDataType() {
                DataTypeDefinition dataTypeDefinition;
                String datatype = null;
                if (Property.this.getTypeName() != null) {
                    datatype = Property.this.getTypeName().getName();
                }
                if ((datatype == null || datatype.equals(DataTypeDefinition.ANY.toString())) && this.value != null && (dataTypeDefinition = NodeBrowserScript.this.getDictionaryService().getDataType(this.value.getClass())) != null) {
                    datatype = NodeBrowserScript.this.getDictionaryService().getDataType(this.value.getClass()).getName().toString();
                }
                return datatype;
            }

            public boolean isContent() {
                String datatype = this.getDataType();
                return datatype == null ? false : datatype.equals(DataTypeDefinition.CONTENT.toString());
            }

            public boolean isNodeRef() {
                String datatype = this.getDataType();
                return datatype == null ? false : datatype.equals(DataTypeDefinition.NODE_REF.toString()) || datatype.equals(DataTypeDefinition.CATEGORY.toString());
            }

            public boolean isNullValue() {
                return this.value == null;
            }
        }
    }

    public class PeerAssociation
    extends Association {
        protected NodeRef sourceRef;
        protected NodeRef targetRef;
        protected QNameBean sourceType;
        protected QNameBean targetType;
        protected QNameBean name;
        protected QNameBean typeName;

        public PeerAssociation(QName typeName, NodeRef sourceRef, NodeRef targetRef) {
            super(null, typeName);
            this.sourceRef = sourceRef;
            this.targetRef = targetRef;
            if (sourceRef != null) {
                this.sourceType = new QNameBean(NodeBrowserScript.this.getNodeType(sourceRef));
            }
            if (targetRef != null) {
                this.targetType = new QNameBean(NodeBrowserScript.this.getNodeType(targetRef));
            }
        }

        public NodeRef getSourceRef() {
            return this.sourceRef;
        }

        public QNameBean getSourceTypeName() {
            return this.sourceType;
        }

        public NodeRef getTargetRef() {
            return this.targetRef;
        }

        public QNameBean getTargetTypeName() {
            return this.targetType;
        }
    }

    public class ChildAssociation
    extends Association
    implements Serializable {
        private static final long serialVersionUID = -52439282250891063L;
        protected NodeRef childRef;
        protected NodeRef parentRef;
        protected QNameBean childType;
        protected QNameBean parentType;
        protected boolean primary;
        protected QNameBean name;
        protected QNameBean typeName;

        public ChildAssociation(ChildAssociationRef ref) {
            super(ref.getQName() != null ? ref.getQName() : null, ref.getTypeQName() != null ? ref.getTypeQName() : null);
            this.childRef = ref.getChildRef();
            this.parentRef = ref.getParentRef();
            if (this.childRef != null) {
                this.childType = new QNameBean(NodeBrowserScript.this.getNodeType(this.childRef));
            }
            if (this.parentRef != null) {
                this.parentType = new QNameBean(NodeBrowserScript.this.getNodeType(this.parentRef));
            }
            this.primary = ref.isPrimary();
        }

        public NodeRef getChildRef() {
            return this.childRef;
        }

        public QNameBean getChildTypeName() {
            return this.childType;
        }

        public NodeRef getParentRef() {
            return this.parentRef;
        }

        public QNameBean getParentTypeName() {
            return this.parentType;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public boolean getPrimary() {
            return this.isPrimary();
        }
    }

    public class Association {
        protected QNameBean name;
        protected QNameBean typeName;

        public Association(QName name, QName typeName) {
            this.name = name != null ? new QNameBean(name) : null;
            this.typeName = new QNameBean(typeName);
        }

        public QNameBean getName() {
            return this.name;
        }

        public QNameBean getTypeName() {
            return this.typeName;
        }
    }

    public class Aspect
    extends QNameBean {
        private static final long serialVersionUID = -6448182941386934326L;

        public Aspect(QName name) {
            super(name);
        }
    }

    public class QNameBean
    implements Serializable {
        private static final long serialVersionUID = 6982292337846270774L;
        protected QName name;

        public QNameBean(QName name) {
            this.name = name;
        }

        public String getName() {
            return this.name.toString();
        }

        public String getPrefixedName() {
            return this.name.toPrefixString((NamespacePrefixResolver)NodeBrowserScript.this.getNamespaceService());
        }

        public String toString() {
            return this.getName();
        }
    }

    public class Node {
        private String qnamePath;
        private String prefixedQNamePath;
        private NodeRef nodeRef;
        private NodeRef parentNodeRef;
        private QNameBean childAssoc;
        private QNameBean type;

        public Node(NodeRef nodeRef) {
            this.nodeRef = nodeRef;
            Path path = NodeBrowserScript.this.getNodeService().getPath(nodeRef);
            this.qnamePath = path.toString();
            this.prefixedQNamePath = path.toPrefixString((NamespacePrefixResolver)NodeBrowserScript.this.getNamespaceService());
            this.parentNodeRef = NodeBrowserScript.this.getPrimaryParent(nodeRef);
            ChildAssociationRef ref = NodeBrowserScript.this.getNodeService().getPrimaryParent(nodeRef);
            this.childAssoc = ref.getQName() != null ? new QNameBean(ref.getQName()) : null;
            this.type = new QNameBean(NodeBrowserScript.this.getNodeService().getType(nodeRef));
        }

        public String getQnamePath() {
            return this.qnamePath;
        }

        public String getPrefixedQNamePath() {
            return this.prefixedQNamePath;
        }

        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public String getId() {
            return this.nodeRef.getId();
        }

        public String getName() {
            return this.childAssoc != null ? this.childAssoc.getName() : "";
        }

        public String getPrefixedName() {
            return this.childAssoc != null ? this.childAssoc.getPrefixedName() : "";
        }

        public QNameBean getType() {
            return this.type;
        }

        public void setNodeRef(NodeRef nodeRef) {
            this.nodeRef = nodeRef;
        }

        public NodeRef getParentNodeRef() {
            return this.parentNodeRef;
        }

        public void setParentNodeRef(NodeRef parentNodeRef) {
            this.parentNodeRef = parentNodeRef;
        }
    }
}

