/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.method;

import java.util.Collection;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.method.MethodSecurityMetadataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMethodSecurityMetadataSource
implements MethodSecurityMetadataSource {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public final Collection<ConfigAttribute> getAttributes(Object object) {
        if (object instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)object;
            Object target = mi.getThis();
            Class<?> targetClass = null;
            if (target != null) {
                targetClass = target instanceof Class ? (Class<?>)target : target.getClass();
            }
            return this.getAttributes(mi.getMethod(), targetClass);
        }
        throw new IllegalArgumentException("Object must be a non-null MethodInvocation");
    }

    @Override
    public final boolean supports(Class<?> clazz) {
        return MethodInvocation.class.isAssignableFrom(clazz);
    }
}

