/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.token;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.Date;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.token.DefaultToken;
import org.springframework.security.core.token.Sha512DigestUtils;
import org.springframework.security.core.token.Token;
import org.springframework.security.core.token.TokenService;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KeyBasedPersistenceTokenService
implements TokenService,
InitializingBean {
    private int pseudoRandomNumberBits = 256;
    private String serverSecret;
    private Integer serverInteger;
    private SecureRandom secureRandom;

    public Token allocateToken(String extendedInformation) {
        Assert.notNull((Object)extendedInformation, (String)"Must provided non-null extendedInformation (but it can be empty)");
        long creationTime = new Date().getTime();
        String serverSecret = this.computeServerSecretApplicableAt(creationTime);
        String pseudoRandomNumber = this.generatePseudoRandomNumber();
        String content = Long.toString(creationTime) + ":" + pseudoRandomNumber + ":" + extendedInformation;
        String sha512Hex = Sha512DigestUtils.shaHex(content + ":" + serverSecret);
        String keyPayload = content + ":" + sha512Hex;
        String key = this.convertToString(Base64.encode(this.convertToBytes(keyPayload)));
        return new DefaultToken(key, creationTime, extendedInformation);
    }

    public Token verifyToken(String key) {
        long creationTime;
        if (key == null || "".equals(key)) {
            return null;
        }
        String[] tokens = StringUtils.delimitedListToStringArray((String)this.convertToString(Base64.decode(this.convertToBytes(key))), (String)":");
        Assert.isTrue((tokens.length >= 4 ? 1 : 0) != 0, (String)("Expected 4 or more tokens but found " + tokens.length));
        try {
            creationTime = Long.decode(tokens[0]);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Expected number but found " + tokens[0]);
        }
        String serverSecret = this.computeServerSecretApplicableAt(creationTime);
        String pseudoRandomNumber = tokens[1];
        StringBuilder extendedInfo = new StringBuilder();
        for (int i = 2; i < tokens.length - 1; ++i) {
            if (i > 2) {
                extendedInfo.append(":");
            }
            extendedInfo.append(tokens[i]);
        }
        String sha1Hex = tokens[tokens.length - 1];
        String content = Long.toString(creationTime) + ":" + pseudoRandomNumber + ":" + extendedInfo.toString();
        String expectedSha512Hex = Sha512DigestUtils.shaHex(content + ":" + serverSecret);
        Assert.isTrue((boolean)expectedSha512Hex.equals(sha1Hex), (String)"Key verification failure");
        return new DefaultToken(key, creationTime, extendedInfo.toString());
    }

    private byte[] convertToBytes(String input) {
        try {
            return input.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String convertToString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String generatePseudoRandomNumber() {
        byte[] randomizedBits = new byte[this.pseudoRandomNumberBits];
        this.secureRandom.nextBytes(randomizedBits);
        return new String(Hex.encode(randomizedBits));
    }

    private String computeServerSecretApplicableAt(long time) {
        return this.serverSecret + ":" + new Long(time % (long)this.serverInteger.intValue()).intValue();
    }

    public void setServerSecret(String serverSecret) {
        this.serverSecret = serverSecret;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public void setPseudoRandomNumberBits(int pseudoRandomNumberBits) {
        Assert.isTrue((pseudoRandomNumberBits >= 0 ? 1 : 0) != 0, (String)"Must have a positive pseudo random number bit size");
        this.pseudoRandomNumberBits = pseudoRandomNumberBits;
    }

    public void setServerInteger(Integer serverInteger) {
        this.serverInteger = serverInteger;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.serverSecret, (String)"Server secret required");
        Assert.notNull((Object)this.serverInteger, (String)"Server integer required");
        Assert.notNull((Object)this.secureRandom, (String)"SecureRandom instance required");
    }
}

