/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.config.JNDIConstants;
import org.alfresco.filter.ByteArrayServletOutputStream;
import org.alfresco.filter.ByteResponseWrapper;
import org.alfresco.filter.CacheControlFilterInfoBean;

public class CacheControlFilter
implements Filter {
    protected static CacheControlFilterInfoBean FilterInfo_;
    protected FilterConfig config = null;
    protected static String[] CacheControlHeader_;
    protected static Pattern[] HostPattern_;
    public static final String LOOKUP_DEPENDENCY_HEADER = "X-Alfresco-Lookup";
    private static ThreadLocal<HashMap<String, String>> LookupDependency_;

    public static void StartLookupDependency() {
        if (LookupDependency_.get() == null) {
            LookupDependency_.set(new HashMap());
        }
    }

    public static void StopLookupDependency() {
        LookupDependency_.set(null);
    }

    public static void AddLookupDependency(String file) {
        HashMap<String, String> lookup_dependency = LookupDependency_.get();
        if (lookup_dependency == null) {
            return;
        }
        lookup_dependency.put(file, null);
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        if (HostPattern_ == null) {
            CacheControlFilter.Init();
        }
    }

    public static void InitInfo(CacheControlFilterInfoBean info) {
        FilterInfo_ = info;
    }

    protected static void Init() {
        Set<Map.Entry<String, String>> cacheControlRulesEntrySet = FilterInfo_.getCacheControlRulesEntrySet();
        int len = cacheControlRulesEntrySet.size();
        CacheControlHeader_ = new String[len];
        HostPattern_ = new Pattern[len];
        int i = 0;
        for (Map.Entry<String, String> e : cacheControlRulesEntrySet) {
            String key = e.getKey();
            CacheControlFilter.CacheControlHeader_[i] = e.getValue();
            CacheControlFilter.HostPattern_[i] = Pattern.compile(key, 2);
            ++i;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HashMap<String, String> lookup_dependency;
        ByteArrayServletOutputStream byte_stream = new ByteArrayServletOutputStream();
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        ByteResponseWrapper wrapper = new ByteResponseWrapper(res, byte_stream);
        chain.doFilter(request, (ServletResponse)wrapper);
        wrapper.flushOutputStreamOrWriter();
        byte[] bytes = byte_stream.toByteArray();
        String serverName = request.getServerName();
        for (int i = 0; i < HostPattern_.length; ++i) {
            if (!HostPattern_[i].matcher(serverName).find()) continue;
            wrapper.setHeader("Cache-Control", CacheControlHeader_[i]);
            break;
        }
        if ((lookup_dependency = LookupDependency_.get()) != null) {
            StringBuilder hdr = new StringBuilder();
            String delim = "";
            for (String file : lookup_dependency.keySet()) {
                if (JNDIConstants.DEFAULT_INF_PATTERN.matcher(file).find()) continue;
                try {
                    file = URLEncoder.encode(file, "UTF-8");
                    hdr.append(delim + file);
                    delim = ", ";
                }
                catch (Exception e) {}
            }
            String header = hdr.toString();
            if (header != null && header.length() != 0) {
                wrapper.setHeader(LOOKUP_DEPENDENCY_HEADER, header);
            }
        }
        try {
            ServletOutputStream out = res.getOutputStream();
            out.write(bytes);
        }
        catch (Throwable t) {
            PrintWriter out = res.getWriter();
            out.write(new String(bytes));
        }
    }

    public void destroy() {
    }

    static {
        LookupDependency_ = new ThreadLocal();
    }
}

