/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.impl.fsr;

import java.io.File;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.alfresco.deployment.DeploymentReceiverTransport;
import org.alfresco.deployment.FSDeploymentRunnable;
import org.alfresco.deployment.impl.DeploymentException;
import org.alfresco.deployment.impl.fsr.FSRunnableTester;
import org.alfresco.deployment.impl.fsr.FileSystemDeploymentTarget;
import org.alfresco.deployment.impl.server.DeploymentTargetRegistry;
import org.alfresco.util.Deleter;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class FileSystemDeploymentTargetTest
extends TestCase {
    private File log = null;
    private File metadata = null;
    private File data = null;
    private File target = null;
    private String TEST_USER = "Giles";
    private char[] TEST_PASSWORD = "Watcher".toCharArray();
    private String TEST_TARGET = "sampleTarget";
    private DeploymentTargetRegistry registry = null;
    private DeploymentReceiverTransport transport = null;

    public FileSystemDeploymentTargetTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.log = new File("deplog");
        this.log.mkdir();
        this.metadata = new File("depmetadata");
        this.metadata.mkdir();
        this.data = new File("depdata");
        this.data.mkdir();
        this.target = new File("sampleTarget");
        this.target.mkdir();
        ClassPathXmlApplicationContext receiverContext = new ClassPathXmlApplicationContext("application-context.xml");
        this.transport = (DeploymentReceiverTransport)receiverContext.getBean("deploymentReceiverEngine");
        this.registry = (DeploymentTargetRegistry)receiverContext.getBean("deploymentReceiverEngine");
    }

    protected void tearDown() throws Exception {
        String[] listing;
        super.tearDown();
        super.tearDown();
        if (this.log != null) {
            Deleter.Delete((File)this.log);
        }
        if (this.data != null) {
            Deleter.Delete((File)this.data);
        }
        if (this.metadata != null) {
            Deleter.Delete((File)this.metadata);
        }
        if (this.target != null) {
            Deleter.Delete((File)this.target);
        }
        File dot = new File(".");
        for (String name : listing = dot.list()) {
            if (!name.startsWith("dep-record-")) continue;
            File file = new File(name);
            file.delete();
        }
    }

    public void testAutoFix() {
    }

    public void testValidateMetaData() {
    }

    public void testPostCommit() {
        FSRunnableTester tester = new FSRunnableTester();
        tester.setThrowException(true);
        FileSystemDeploymentTarget t = (FileSystemDeploymentTarget)this.registry.getTargets().get(this.TEST_TARGET);
        FileSystemDeploymentTargetTest.assertNotNull((String)"sampleTarget null", (Object)t);
        ArrayList<FSDeploymentRunnable> postCommit = new ArrayList<FSDeploymentRunnable>();
        postCommit.add(tester);
        t.setPostCommit(postCommit);
        String ticket = t.begin(this.TEST_TARGET, "wibble", 1, this.TEST_USER, this.TEST_PASSWORD);
        t.prepare(ticket);
        t.commit(ticket);
        FileSystemDeploymentTargetTest.assertTrue((String)"isRunCalled", (boolean)tester.isRunCalled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrepare() {
        FSRunnableTester tester = new FSRunnableTester();
        tester.setThrowException(true);
        FileSystemDeploymentTarget t = (FileSystemDeploymentTarget)this.registry.getTargets().get(this.TEST_TARGET);
        FileSystemDeploymentTargetTest.assertNotNull((String)"sampleTarget null", (Object)t);
        ArrayList<FSDeploymentRunnable> prepare = new ArrayList<FSDeploymentRunnable>();
        prepare.add(tester);
        t.setPrepare(prepare);
        String ticket = t.begin(this.TEST_TARGET, "wibble", 1, this.TEST_USER, this.TEST_PASSWORD);
        try {
            t.prepare(ticket);
            FileSystemDeploymentTargetTest.fail((String)"deployment exception not thrown");
        }
        catch (DeploymentException de) {
        }
        finally {
            t.abort(ticket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiplePrepare() {
        FSRunnableTester bomb = new FSRunnableTester();
        bomb.setThrowException(true);
        FileSystemDeploymentTarget t = (FileSystemDeploymentTarget)this.registry.getTargets().get(this.TEST_TARGET);
        FileSystemDeploymentTargetTest.assertNotNull((String)"sampleTarget null", (Object)t);
        ArrayList<FSDeploymentRunnable> prepare = new ArrayList<FSDeploymentRunnable>();
        prepare.add(new FSRunnableTester());
        prepare.add(new FSRunnableTester());
        prepare.add(bomb);
        prepare.add(new FSRunnableTester());
        t.setPrepare(prepare);
        String ticket = t.begin(this.TEST_TARGET, "wibble", 1, this.TEST_USER, this.TEST_PASSWORD);
        try {
            t.prepare(ticket);
            FileSystemDeploymentTargetTest.fail((String)"deployment exception not thrown");
        }
        catch (DeploymentException de) {
            System.out.println(de.toString());
            de.printStackTrace();
        }
        finally {
            t.abort(ticket);
        }
        bomb.setThrowException(false);
        String ticket2 = t.begin(this.TEST_TARGET, "wibble", 1, this.TEST_USER, this.TEST_PASSWORD);
        try {
            t.prepare(ticket2);
        }
        catch (DeploymentException de) {
            FileSystemDeploymentTargetTest.fail((String)"deployment exception thrown");
        }
        finally {
            t.abort(ticket2);
        }
    }
}

