/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.impl.server;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.alfresco.deployment.impl.DeploymentException;
import org.alfresco.deployment.impl.server.DeployedFile;
import org.alfresco.deployment.impl.server.DeploymentState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Deployment
implements Iterable<DeployedFile>,
Serializable {
    private static final long serialVersionUID = -4675002987994484069L;
    private static Log logger = LogFactory.getLog(Deployment.class);
    private List<DeployedFile> deployedFiles = new Vector<DeployedFile>();
    private long fLastActivity;
    private String ticket;
    private String targetName;
    private boolean fCanBeStale;
    private boolean metaError = false;
    private DeploymentState fState;
    private int authoringVersion;
    private String authoringStoreName;

    public Deployment(String ticket, String targetName, String storeName, int version) throws IOException {
        this.targetName = targetName;
        this.ticket = ticket;
        this.fLastActivity = System.currentTimeMillis();
        this.fCanBeStale = true;
        this.fState = DeploymentState.WORKING;
        this.authoringStoreName = storeName;
        this.authoringVersion = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DeployedFile file) throws IOException {
        Deployment deployment = this;
        synchronized (deployment) {
            this.deployedFiles.add(file);
            this.fLastActivity = System.currentTimeMillis();
        }
    }

    public void prepare() throws IOException, DeploymentException {
        this.fCanBeStale = false;
        this.fState = DeploymentState.PREPARED;
    }

    public void commit() throws IOException {
        this.fState = DeploymentState.COMMITTED;
    }

    public void abort() throws IOException {
        this.fCanBeStale = false;
        this.fState = DeploymentState.ABORTED;
    }

    public boolean isStale(long timeout) {
        if (!this.fCanBeStale) {
            return false;
        }
        return System.currentTimeMillis() - this.fLastActivity > timeout;
    }

    @Override
    public Iterator<DeployedFile> iterator() {
        return this.deployedFiles.iterator();
    }

    public DeploymentState getState() {
        return this.fState;
    }

    public void setDeploymentState(DeploymentState state) {
        this.fState = state;
    }

    public void setMetaError(boolean metaError) {
        this.metaError = metaError;
    }

    public boolean isMetaError() {
        return this.metaError;
    }

    public void setAuthoringVersion(int version) {
        this.authoringVersion = version;
    }

    public int getAuthoringVersion() {
        return this.authoringVersion;
    }

    public void setAuthoringStoreName(String storeName) {
        this.authoringStoreName = storeName;
    }

    public String getAuthoringStoreName() {
        return this.authoringStoreName;
    }
}

