/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.impl.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.deployment.impl.DeploymentException;
import org.alfresco.deployment.impl.server.ReaderManagement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReaderManagementSimpleImpl
implements ReaderManagement {
    private static Log logger = LogFactory.getLog(ReaderManagementSimpleImpl.class);
    Map<String, ReaderThread> fThreads = new HashMap<String, ReaderThread>();

    @Override
    public void addCopyThread(InputStream is, OutputStream os, String token) {
        ReaderThread worker = new ReaderThread(is, os);
        worker.start();
        this.fThreads.put(token, worker);
    }

    @Override
    public void closeCopyThread(String token) throws IOException {
        ReaderThread worker = this.fThreads.get(token);
        if (worker == null) {
            throw new DeploymentException("Closed unknown file.");
        }
        this.fThreads.remove(token);
        try {
            worker.join();
            if (worker.getException() != null) {
                throw worker.getException();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class ReaderThread
    extends Thread {
        InputStream input;
        OutputStream output;
        IOException exception = null;

        public ReaderThread(InputStream input, OutputStream output) {
            this.input = input;
            this.output = output;
            super.setName("Reader Thread ");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] b = new byte[1000];
            int len = 0;
            try {
                while (len >= 0) {
                    len = this.input.read(b, 0, b.length);
                    if (len <= 0 || this.exception != null) continue;
                    try {
                        this.output.write(b, 0, len);
                    }
                    catch (IOException e) {
                        this.exception = e;
                    }
                }
            }
            catch (IOException e) {
                this.exception = e;
            }
            finally {
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Unable to close content stream", (Throwable)e);
                }
            }
        }

        public IOException getException() {
            return this.exception;
        }
    }
}

