/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.test.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.FileCopyUtils;

public class MockClientHttpResponse
implements ClientHttpResponse {
    private InputStream bodyStream;
    private byte[] body;
    private final HttpHeaders headers;
    private final HttpStatus statusCode;
    private final String statusText;

    public MockClientHttpResponse(String body, HttpHeaders headers, HttpStatus statusCode, String statusText) {
        this(MockClientHttpResponse.stringToInputStream(body), headers, statusCode, statusText);
    }

    public MockClientHttpResponse(InputStream bodyStream, HttpHeaders headers, HttpStatus statusCode, String statusText) {
        this.bodyStream = bodyStream;
        this.headers = headers;
        this.statusCode = statusCode;
        this.statusText = statusText;
    }

    public InputStream getBody() throws IOException {
        if (this.body == null) {
            this.body = FileCopyUtils.copyToByteArray((InputStream)this.bodyStream);
        }
        return new ByteArrayInputStream(this.body);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpStatus getStatusCode() throws IOException {
        return this.statusCode;
    }

    public String getStatusText() throws IOException {
        return this.statusText;
    }

    public void close() {
    }

    private static InputStream stringToInputStream(String in) {
        try {
            return new ByteArrayInputStream(in.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException shouldntHappen) {
            return null;
        }
    }
}

