/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.changelog;

import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.cmis.CMISDictionaryModel;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.cmis.CMISServices;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.CMISTypeId;
import org.alfresco.repo.audit.extractor.AbstractDataExtractor;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;

public class CMISChangeLogDataExtractor
extends AbstractDataExtractor {
    private CMISServices cmisService;
    public static final String KEY_NODE_REF = "nodeRef";
    public static final String KEY_OBJECT_ID = "objectId";

    @Override
    public Serializable extractData(Serializable value) throws Throwable {
        NodeRef nodeRef = this.getNodeRef(value);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put(KEY_NODE_REF, nodeRef);
        result.put(KEY_OBJECT_ID, this.cmisService.getProperty(nodeRef, "cmis:objectId"));
        return result;
    }

    @Override
    public boolean isSupported(Serializable data) {
        NodeRef nodeRef;
        if (data != null && (nodeRef = this.getNodeRef(data)) != null) {
            try {
                CMISTypeDefinition typeDef = this.cmisService.getTypeDefinition(nodeRef);
                if (typeDef != null) {
                    CMISTypeId typeId = typeDef.getBaseType().getTypeId();
                    return typeId.equals(CMISDictionaryModel.DOCUMENT_TYPE_ID) || typeId.equals(CMISDictionaryModel.FOLDER_TYPE_ID);
                }
            }
            catch (CMISInvalidArgumentException cMISInvalidArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    private NodeRef getNodeRef(Serializable data) {
        NodeRef nodeRef = null;
        if (data instanceof ChildAssociationRef) {
            nodeRef = ((ChildAssociationRef)data).getChildRef();
        }
        if (data instanceof FileInfo) {
            nodeRef = ((FileInfo)data).getNodeRef();
        } else if (data instanceof NodeRef) {
            nodeRef = (NodeRef)data;
        }
        return nodeRef;
    }

    public void setCmisService(CMISServices cmisService) {
        this.cmisService = cmisService;
    }
}

