/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dictionary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.alfresco.cmis.CMISActionEvaluator;
import org.alfresco.cmis.CMISAllowedActionEnum;
import org.alfresco.cmis.CMISContentStreamAllowedEnum;
import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISPropertyId;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.CMISTypeId;
import org.alfresco.cmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.cmis.dictionary.CMISBasePropertyDefinition;
import org.alfresco.cmis.mapping.CMISMapping;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CMISAbstractTypeDefinition
implements CMISTypeDefinition,
Serializable {
    protected static final Log logger = LogFactory.getLog(CMISAbstractTypeDefinition.class);
    private static final long serialVersionUID = -3131505923356013430L;
    protected Boolean isPublic = null;
    protected ClassDefinition cmisClassDef = null;
    protected CMISTypeId objectTypeId = null;
    protected String objectTypeQueryName = null;
    protected String displayName = null;
    protected CMISTypeId parentTypeId = null;
    protected CMISTypeDefinition parentType = null;
    protected CMISAbstractTypeDefinition internalParentType = null;
    protected CMISTypeDefinition rootType = null;
    protected String description = null;
    protected Boolean creatable = null;
    protected Boolean queryable = null;
    protected Boolean fullTextIndexed = null;
    protected Boolean controllablePolicy = null;
    protected Boolean controllableACL = null;
    protected Boolean includedInSuperTypeQuery = null;
    protected Collection<CMISTypeId> subTypeIds = null;
    protected Collection<CMISTypeDefinition> subTypes = null;
    protected Map<String, CMISPropertyDefinition> properties = null;
    protected Map<String, CMISPropertyDefinition> inheritedProperties = null;
    protected Map<String, CMISPropertyDefinition> ownedProperties = null;
    protected Map<CMISAllowedActionEnum, CMISActionEvaluator<? extends Object>> actionEvaluators = null;

    void assertComplete() {
        if (this.objectTypeId == null) {
            throw new IllegalStateException("objectTypeId not specified");
        }
        if (this.isPublic == null) {
            throw new IllegalStateException("isPublic not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.objectTypeQueryName == null) {
            throw new IllegalStateException("objectTypeQueryName not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.displayName == null) {
            throw new IllegalStateException("displayName not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.parentTypeId != null && this.internalParentType == null) {
            throw new IllegalStateException("parentType not specified; objectTypeId=" + this.objectTypeId + ",parentTypeId=" + this.parentTypeId);
        }
        if (this.rootType == null) {
            throw new IllegalStateException("rootType not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.description == null) {
            throw new IllegalStateException("description not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.creatable == null) {
            throw new IllegalStateException("creatable not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.queryable == null) {
            throw new IllegalStateException("queryable not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.fullTextIndexed == null) {
            throw new IllegalStateException("fullTextIndexed not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.controllablePolicy == null) {
            throw new IllegalStateException("controllablePolicy not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.controllableACL == null) {
            throw new IllegalStateException("controllablePolicy not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.includedInSuperTypeQuery == null) {
            throw new IllegalStateException("includedInSuperTypeQuery not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.subTypeIds == null) {
            throw new IllegalStateException("subTypeIds not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.subTypes == null) {
            throw new IllegalStateException("subTypes not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.properties == null) {
            throw new IllegalStateException("properties not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.inheritedProperties == null) {
            throw new IllegalStateException("inheritedProperties not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.ownedProperties == null) {
            throw new IllegalStateException("inheritedProperties not specified; objectTypeId=" + this.objectTypeId);
        }
        if (this.actionEvaluators == null) {
            throw new IllegalStateException("actionEvaluators not specified; objectTypeId=" + this.objectTypeId);
        }
    }

    Map<String, CMISPropertyDefinition> createProperties(CMISMapping cmisMapping, DictionaryService dictionaryService) {
        this.properties = new HashMap<String, CMISPropertyDefinition>();
        for (PropertyDefinition propDef : this.cmisClassDef.getProperties().values()) {
            if (!propDef.getContainerClass().equals(this.cmisClassDef) || propDef.isOverride() || cmisMapping.getDataType(propDef.getDataType()) == null) continue;
            CMISPropertyDefinition cmisPropDef = this.createProperty(cmisMapping, propDef);
            this.properties.put(cmisPropDef.getPropertyId().getId(), cmisPropDef);
        }
        return this.properties;
    }

    private CMISPropertyDefinition createProperty(CMISMapping cmisMapping, PropertyDefinition propDef) {
        QName propertyQName = propDef.getName();
        String propertyId = cmisMapping.getCmisPropertyId(propertyQName);
        CMISPropertyId cmisPropertyId = new CMISPropertyId(propertyQName, propertyId);
        return new CMISBasePropertyDefinition(cmisMapping, cmisPropertyId, propDef, this);
    }

    void createSubTypes(CMISMapping cmisMapping, DictionaryService dictionaryService) {
        this.subTypeIds = new ArrayList<CMISTypeId>();
        Collection subTypes = dictionaryService.getSubTypes(this.objectTypeId.getQName(), false);
        for (QName subType : subTypes) {
            CMISTypeId subTypeId;
            if (!cmisMapping.isValidCmisDocumentOrFolder(subType) || (subTypeId = cmisMapping.getCmisTypeId(subType)) == null) continue;
            this.subTypeIds.add(subTypeId);
        }
    }

    void resolveDependencies(CMISAbstractDictionaryService.DictionaryRegistry registry) {
        CMISTypeId rootTypeId;
        if (this.parentTypeId != null) {
            this.internalParentType = registry.objectDefsByTypeId.get(this.parentTypeId);
            if (this.internalParentType == null) {
                throw new AlfrescoRuntimeException("Failed to retrieve parent type for type id " + this.parentTypeId);
            }
            if (this.internalParentType.isPublic() == this.isPublic.booleanValue()) {
                this.parentType = this.internalParentType;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Type " + this.objectTypeId + ": parent=" + (this.parentType == null ? "<none>" : this.parentType.getTypeId()) + ", internal parent=" + (this.internalParentType == null ? "<none>" : this.internalParentType.getTypeId())));
        }
        if ((rootTypeId = this.objectTypeId.getBaseTypeId()) != null) {
            this.rootType = registry.objectDefsByTypeId.get(rootTypeId);
            if (this.rootType == null) {
                throw new AlfrescoRuntimeException("Failed to retrieve root type for type id " + rootTypeId);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Type " + this.objectTypeId + ": root=" + this.rootType.getTypeId()));
        }
        this.subTypes = new ArrayList<CMISTypeDefinition>();
        for (CMISTypeId subTypeId : this.subTypeIds) {
            CMISTypeDefinition subType = registry.objectDefsByTypeId.get(subTypeId);
            if (subType == null) {
                throw new AlfrescoRuntimeException("Failed to retrieve sub type for type id " + subTypeId + " for parent type " + this.objectTypeId);
            }
            if (subType.isPublic() != this.isPublic.booleanValue()) continue;
            this.subTypes.add(subType);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Type " + this.objectTypeId + ": subtype=" + subType.getTypeId()));
        }
    }

    void resolveInheritance(CMISAbstractDictionaryService.DictionaryRegistry registry) {
        this.inheritedProperties = new HashMap<String, CMISPropertyDefinition>();
        this.ownedProperties = new HashMap<String, CMISPropertyDefinition>();
        this.inheritedProperties.putAll(this.properties);
        this.ownedProperties.putAll(this.properties);
        if (this.internalParentType != null) {
            this.inheritedProperties.putAll(this.internalParentType.getPropertyDefinitions());
            if (this.internalParentType.isPublic != this.isPublic) {
                this.ownedProperties.putAll(this.internalParentType.getPropertyDefinitions());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Type " + this.objectTypeId + " inheriting properties: " + this.internalParentType.getPropertyDefinitions().size() + " from " + this.internalParentType.getTypeId()));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Type " + this.objectTypeId + " properties: " + this.inheritedProperties.size() + ", owned: " + this.ownedProperties.size()));
        }
    }

    public CMISAbstractTypeDefinition getInternalParentType() {
        return this.internalParentType;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public CMISTypeId getTypeId() {
        return this.objectTypeId;
    }

    @Override
    public String getQueryName() {
        return this.objectTypeQueryName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public CMISTypeDefinition getParentType() {
        return this.parentType;
    }

    @Override
    public CMISTypeDefinition getBaseType() {
        return this.rootType;
    }

    @Override
    public Collection<CMISTypeDefinition> getSubTypes(boolean includeDescendants) {
        if (!includeDescendants) {
            return this.subTypes;
        }
        ArrayList<CMISTypeDefinition> descendants = new ArrayList<CMISTypeDefinition>();
        LinkedList<CMISTypeDefinition> stack = new LinkedList<CMISTypeDefinition>();
        stack.addLast(this);
        while (stack.size() > 0) {
            CMISTypeDefinition current = (CMISTypeDefinition)stack.removeLast();
            if (!current.equals(this)) {
                descendants.add(current);
            }
            for (CMISTypeDefinition type : current.getSubTypes(false)) {
                stack.addLast(type);
            }
        }
        return descendants;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isCreatable() {
        return this.creatable;
    }

    @Override
    public boolean isQueryable() {
        return this.queryable;
    }

    @Override
    public boolean isFullTextIndexed() {
        return this.fullTextIndexed;
    }

    @Override
    public boolean isControllablePolicy() {
        return this.controllablePolicy;
    }

    @Override
    public boolean isControllableACL() {
        return this.controllableACL;
    }

    @Override
    public boolean isIncludedInSuperTypeQuery() {
        return this.includedInSuperTypeQuery;
    }

    @Override
    public Map<String, CMISPropertyDefinition> getPropertyDefinitions() {
        return this.inheritedProperties;
    }

    @Override
    public Map<String, CMISPropertyDefinition> getOwnedPropertyDefinitions() {
        return this.ownedProperties;
    }

    @Override
    public Map<CMISAllowedActionEnum, CMISActionEvaluator<? extends Object>> getActionEvaluators() {
        return this.actionEvaluators;
    }

    @Override
    public boolean isFileable() {
        return false;
    }

    @Override
    public boolean isVersionable() {
        return false;
    }

    @Override
    public CMISContentStreamAllowedEnum getContentStreamAllowed() {
        return CMISContentStreamAllowedEnum.NOT_ALLOWED;
    }

    @Override
    public Collection<CMISTypeDefinition> getAllowedSourceTypes() {
        return Collections.emptyList();
    }

    @Override
    public Collection<CMISTypeDefinition> getAllowedTargetTypes() {
        return Collections.emptyList();
    }

    public int hashCode() {
        return this.objectTypeId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CMISTypeDefinition other = (CMISTypeDefinition)obj;
        return !(this.objectTypeId == null ? other.getTypeId() != null : !this.objectTypeId.equals(other.getTypeId()));
    }
}

