/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dictionary;

import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.mapping.BaseCMISTest;

public class CMISDictionaryTest
extends BaseCMISTest {
    public void testAllTypes() {
        for (CMISTypeDefinition type : this.cmisDictionaryService.getAllTypes()) {
            System.out.println(type);
        }
    }

    public void testBaseTypes() {
        for (CMISTypeDefinition type : this.cmisDictionaryService.getBaseTypes()) {
            System.out.println(type);
        }
    }

    public void testSubTypes() {
        for (CMISTypeDefinition type : this.cmisDictionaryService.getAllTypes()) {
            System.out.println(type.getTypeId() + " children:");
            for (CMISTypeDefinition subType : type.getSubTypes(false)) {
                System.out.println(" " + subType.getTypeId());
            }
            System.out.println(type.getTypeId() + " descendants:");
            for (CMISTypeDefinition subType : type.getSubTypes(true)) {
                System.out.println(" " + subType.getTypeId());
            }
        }
    }

    public void testTypeIds() {
        for (CMISTypeDefinition typeDef : this.cmisDictionaryService.getAllTypes()) {
            CMISTypeDefinition typeDefLookup = this.cmisDictionaryService.findType(typeDef.getTypeId());
            CMISDictionaryTest.assertNotNull((Object)typeDefLookup);
            CMISDictionaryTest.assertEquals((Object)typeDef, (Object)typeDefLookup);
        }
    }

    public void testBasicPropertyDefinitions() {
        for (CMISTypeDefinition type : this.cmisDictionaryService.getAllTypes()) {
            System.out.println(type.getTypeId() + " properties:");
            for (CMISPropertyDefinition proDef : type.getPropertyDefinitions().values()) {
                System.out.println(" " + proDef);
            }
        }
    }
}

