/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.io.Serializable;
import org.alfresco.cmis.mapping.AbstractVersioningProperty;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;

public class CheckinCommentProperty
extends AbstractVersioningProperty {
    public CheckinCommentProperty(ServiceRegistry serviceRegistry) {
        super(serviceRegistry, "cmis:checkinComment");
    }

    @Override
    public Serializable getValue(NodeRef nodeRef) {
        if (this.isWorkingCopy(nodeRef)) {
            return null;
        }
        ServiceRegistry serviceRegistry = this.getServiceRegistry();
        String versionLabel = (String)((Object)serviceRegistry.getNodeService().getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
        if (versionLabel == null) {
            return null;
        }
        NodeRef versionSeries = this.getVersionSeries(nodeRef);
        VersionHistory versionHistory = serviceRegistry.getVersionService().getVersionHistory(versionSeries);
        if (versionHistory == null) {
            return null;
        }
        Version version = versionHistory.getVersion(versionLabel);
        if (version == null) {
            return null;
        }
        return version.getDescription();
    }
}

