/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.search;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.cmis.CMISDictionaryService;
import org.alfresco.cmis.CMISJoinEnum;
import org.alfresco.cmis.CMISQueryEnum;
import org.alfresco.cmis.CMISQueryOptions;
import org.alfresco.cmis.CMISQueryService;
import org.alfresco.cmis.CMISResultSet;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISServices;
import org.alfresco.cmis.search.CMISQueryParser;
import org.alfresco.cmis.search.CMISResultSetImpl;
import org.alfresco.cmis.search.CmisFunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryEngine;
import org.alfresco.repo.search.impl.querymodel.QueryEngineResults;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;

public class CMISQueryServiceImpl
implements CMISQueryService {
    private CMISServices cmisService;
    private CMISDictionaryService cmisDictionaryService;
    private QueryEngine queryEngine;
    private NodeService nodeService;
    private DictionaryService alfrescoDictionaryService;

    public void setCMISService(CMISServices cmisService) {
        this.cmisService = cmisService;
    }

    public void setCMISDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public void setQueryEngine(QueryEngine queryEngine) {
        this.queryEngine = queryEngine;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAlfrescoDictionaryService(DictionaryService alfrescoDictionaryService) {
        this.alfrescoDictionaryService = alfrescoDictionaryService;
    }

    @Override
    public CMISResultSet query(CMISQueryOptions options) {
        CMISJoinEnum joinSupport = this.getJoinSupport();
        if (options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS) {
            joinSupport = CMISJoinEnum.INNER_JOIN_SUPPORT;
        }
        CMISScope[] validScopes = options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT ? CmisFunctionEvaluationContext.STRICT_SCOPES : CmisFunctionEvaluationContext.ALFRESCO_SCOPES;
        CmisFunctionEvaluationContext functionContext = new CmisFunctionEvaluationContext();
        functionContext.setCmisDictionaryService(this.cmisDictionaryService);
        functionContext.setNodeService(this.nodeService);
        functionContext.setValidScopes(validScopes);
        CMISQueryParser parser = new CMISQueryParser(options, this.cmisDictionaryService, joinSupport);
        Query query = parser.parse(this.queryEngine.getQueryModelFactory(), functionContext);
        QueryEngineResults results = this.queryEngine.executeQuery(query, (QueryOptions)options, (FunctionEvaluationContext)functionContext);
        HashMap<String, ResultSet> wrapped = new HashMap<String, ResultSet>();
        Map map = results.getResults();
        for (Set group : map.keySet()) {
            ResultSet current = (ResultSet)map.get(group);
            for (String selector : group) {
                wrapped.put(selector, current);
            }
        }
        LimitBy limitBy = null;
        if (null != results.getResults() && !results.getResults().isEmpty() && null != results.getResults().values() && !results.getResults().values().isEmpty()) {
            limitBy = ((ResultSet)results.getResults().values().iterator().next()).getResultSetMetaData().getLimitedBy();
        }
        CMISResultSetImpl cmis = new CMISResultSetImpl(wrapped, options, limitBy, this.nodeService, query, this.cmisDictionaryService, this.alfrescoDictionaryService);
        return cmis;
    }

    @Override
    public CMISResultSet query(String query) {
        CMISQueryOptions options = new CMISQueryOptions(query, this.cmisService.getDefaultRootStoreRef());
        return this.query(options);
    }

    @Override
    public boolean getPwcSearchable() {
        return true;
    }

    @Override
    public boolean getAllVersionsSearchable() {
        return false;
    }

    @Override
    public CMISQueryEnum getQuerySupport() {
        return CMISQueryEnum.BOTH_COMBINED;
    }

    @Override
    public CMISJoinEnum getJoinSupport() {
        return CMISJoinEnum.NO_JOIN_SUPPORT;
    }
}

