/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.filesys.alfresco.DesktopAction;

public class DesktopActionTable {
    private Hashtable<String, DesktopAction> m_actions = new Hashtable();
    private Hashtable<String, DesktopAction> m_actionsPseudo = new Hashtable();

    public final DesktopAction getAction(String name) {
        return this.m_actions.get(name);
    }

    public final DesktopAction getActionViaPseudoName(String pseudoName) {
        return this.m_actionsPseudo.get(pseudoName.toUpperCase());
    }

    public final int numberOfActions() {
        return this.m_actions.size();
    }

    public final boolean addAction(DesktopAction action) {
        if (this.m_actions.get(action.getName()) == null) {
            this.m_actions.put(action.getName(), action);
            this.m_actionsPseudo.put(action.getPseudoFile().getFileName().toUpperCase(), action);
            return true;
        }
        return false;
    }

    public final Enumeration<String> enumerateActionNames() {
        return this.m_actions.keys();
    }

    public final DesktopAction removeAction(String name) {
        DesktopAction action = this.m_actions.remove(name);
        if (action != null) {
            this.m_actionsPseudo.remove(action.getPseudoFile().getFileName().toUpperCase());
        }
        return action;
    }
}

